/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.timeline.editpart;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gemoc.timeline.layout.LineLayout;
import org.eclipse.gemoc.timeline.model.Choice;
import org.eclipse.gemoc.timeline.model.Connection;
import org.eclipse.gemoc.timeline.model.PossibleStep;
import org.eclipse.jface.resource.JFaceResources;

public class PossibleStepEditPart
extends AbstractGraphicalEditPart {
    public static final int SIZE = 20;
    public static final int SPACING = 5;
    private final boolean withLabel;

    public PossibleStepEditPart(boolean withLabel) {
        this.withLabel = withLabel;
    }

    protected IFigure createFigure() {
        return new PossibleStepFigure();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        PossibleStepFigure figure = (PossibleStepFigure)this.getFigure();
        if (!this.getModel().getChoice().hasSelected()) {
            figure.getLabel().setText(this.getModel().getName());
            figure.getEllipse().setBackgroundColor(ColorConstants.orange);
            if (this.withLabel) {
                figure.getEllipseToolTip().setVisible(false);
                if (!figure.hasLabel()) {
                    figure.addLabel();
                    figure.invalidate();
                }
            } else {
                figure.getEllipseToolTip().setVisible(true);
                figure.getEllipseToolTip().setText(this.getModel().getName());
            }
        } else {
            figure.getEllipseToolTip().setText(this.getModel().getName());
            if (this.getModel().isCurrent()) {
                figure.getEllipse().setBackgroundColor(ColorConstants.blue);
            } else if (this.getModel().isSelected()) {
                figure.getEllipse().setBackgroundColor(ColorConstants.lightBlue);
            } else {
                figure.getEllipse().setBackgroundColor(ColorConstants.lightGreen);
            }
            if (this.withLabel && figure.hasLabel()) {
                figure.removeLabel();
                figure.invalidate();
            }
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new XYLayoutEditPolicy(){

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        });
    }

    protected List<Connection> getModelSourceConnections() {
        return this.getModel().getFollowing();
    }

    protected List<Connection> getModelTargetConnections() {
        return this.getModel().getPreceding();
    }

    public PossibleStep getModel() {
        return (PossibleStep)super.getModel();
    }

    public PossibleStepEditPart getLeftPossibleStepEditPart() {
        PossibleStepEditPart res;
        Choice previousChoice = this.getModel().getChoice().getPreviousChoice();
        if (previousChoice != null) {
            int connectionIndex;
            int previousConnectionIndex = previousChoice.getConnectedIndex();
            if (previousConnectionIndex < 0) {
                previousConnectionIndex = 0;
            }
            if ((connectionIndex = this.getModel().getChoice().getConnectedIndex()) < 0) {
                connectionIndex = 0;
            }
            int offset = previousConnectionIndex - connectionIndex;
            res = previousChoice.getPossibleSteps().size() > this.getModel().getPossibleStepIndex() + offset && this.getModel().getPossibleStepIndex() + offset > -1 ? (PossibleStepEditPart)((Object)this.getViewer().getEditPartRegistry().get(previousChoice.getPossibleSteps().get(this.getModel().getPossibleStepIndex() + offset))) : null;
        } else {
            res = null;
        }
        return res;
    }

    public PossibleStepEditPart getRightPossibleStepEditPart() {
        PossibleStepEditPart res;
        Choice nextChoice = this.getModel().getChoice().getNextChoice();
        if (nextChoice != null) {
            int connectionIndex;
            int nextConnectionIndex = nextChoice.getConnectedIndex();
            if (nextConnectionIndex < 0) {
                nextConnectionIndex = 0;
            }
            if ((connectionIndex = this.getModel().getChoice().getConnectedIndex()) < 0) {
                connectionIndex = 0;
            }
            int offset = nextConnectionIndex - connectionIndex;
            res = nextChoice.getPossibleSteps().size() > this.getModel().getPossibleStepIndex() + offset && this.getModel().getPossibleStepIndex() + offset > -1 ? (PossibleStepEditPart)((Object)this.getViewer().getEditPartRegistry().get(nextChoice.getPossibleSteps().get(this.getModel().getPossibleStepIndex() + offset))) : null;
        } else {
            res = null;
        }
        return res;
    }

    public PossibleStepEditPart getAbovePossibleStepEditPart() {
        return (PossibleStepEditPart)((Object)this.getViewer().getEditPartRegistry().get(this.getModel().getNextPossibleStep()));
    }

    public PossibleStepEditPart getBeneathPossibleStepEditPart() {
        return (PossibleStepEditPart)((Object)this.getViewer().getEditPartRegistry().get(this.getModel().getPreviousPossibleStep()));
    }

    private final class PossibleStepFigure
    extends Layer {
        private final Ellipse ellipse;
        private final Label toolTip;
        private final Label label;
        private boolean hasLabel;

        public PossibleStepFigure() {
            LineLayout layout = new LineLayout();
            layout.setHorizontal(true);
            layout.setMajorAlignment(1);
            layout.setMinorAlignment(0);
            layout.setMinorSpacing(5);
            this.setLayoutManager((LayoutManager)layout);
            this.toolTip = new Label();
            this.toolTip.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
            this.toolTip.setBackgroundColor(ColorConstants.tooltipBackground);
            this.toolTip.setForegroundColor(ColorConstants.tooltipForeground);
            this.ellipse = this.createEllipse();
            this.add((IFigure)this.ellipse);
            this.label = new Label();
            if (PossibleStepEditPart.this.withLabel) {
                this.add((IFigure)this.label);
                this.hasLabel = true;
            } else {
                this.ellipse.setToolTip((IFigure)this.toolTip);
                this.hasLabel = false;
            }
            this.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    if (me.button == 1) {
                        EditPartViewer viewer = PossibleStepEditPart.this.getViewer();
                        viewer.getSelectionManager().deselectAll();
                        viewer.getSelectionManager().appendSelection((EditPart)PossibleStepEditPart.this);
                    }
                }
            });
        }

        private Ellipse createEllipse() {
            Ellipse res = new Ellipse();
            res.setSize(20, 20);
            res.setForegroundColor(ColorConstants.listBackground);
            return res;
        }

        public boolean hasLabel() {
            return this.hasLabel;
        }

        public void removeLabel() {
            this.ellipse.setToolTip((IFigure)this.toolTip);
            this.remove((IFigure)this.label);
            this.hasLabel = false;
        }

        public void addLabel() {
            this.ellipse.setToolTip(null);
            this.add((IFigure)this.label);
            this.hasLabel = true;
        }

        public Ellipse getEllipse() {
            return this.ellipse;
        }

        public Label getEllipseToolTip() {
            return this.toolTip;
        }

        public Label getLabel() {
            return this.label;
        }
    }
}

