/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.event.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.executionframework.event.manager.EventInstance;
import org.eclipse.gemoc.executionframework.event.manager.IEventManager;
import org.eclipse.gemoc.executionframework.event.model.event.Event;
import org.eclipse.xtext.naming.DefaultDeclarativeQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;

public class EventTableView
extends TableView<EventInstance> {
    private final EClass eventClass;
    private final EFactory factory;
    private final Resource executedModel;
    private final List<EClass> eventParameterClasses = new ArrayList<EClass>();
    private final Map<EReference, EClass> referenceToParameterClass = new HashMap<EReference, EClass>();
    private final Map<EReference, List<EObject>> referenceToMatchingModelElements = new HashMap<EReference, List<EObject>>();
    private final ObservableList<EventInstance> events = FXCollections.observableArrayList();
    private final Function<EventInstance, Boolean> canDisplayEventFunction;

    public EventTableView(EClass eventClass, Resource executedModel, IEventManager eventManager) {
        this.eventClass = eventClass;
        this.factory = eventClass.getEPackage().getEFactoryInstance();
        this.executedModel = executedModel;
        this.extractEventParameters();
        this.setItems(this.events);
        this.setEditable(true);
        this.canDisplayEventFunction = event -> eventManager.canSendEvent(event);
        ArrayList columns = new ArrayList();
        eventClass.getEAllStructuralFeatures().stream().forEach(f -> {
            if (f instanceof EReference) {
                String name = f.getName().substring(0, f.getName().indexOf("Provider"));
                TableColumn col = new TableColumn(name);
                col.setCellValueFactory((Callback)new EventInstanceReferencePropertyValueFactory((EReference)f));
                columns.add(col);
            } else {
                String name = f.getName();
                TableColumn col = new TableColumn(name);
                col.setEditable(true);
                col.setCellValueFactory((Callback)new EventInstanceAttributePropertyValueFactory((EAttribute)f));
                col.setCellFactory(TextFieldTableCell.forTableColumn());
                col.setOnEditCommit(editEvent -> {
                    EventInstance event = (EventInstance)editEvent.getRowValue();
                    event.getParameters().put(f, editEvent.getNewValue());
                });
                columns.add(col);
            }
        });
        this.getColumns().setAll(columns);
    }

    public void refreshEvents() {
        Platform.runLater(() -> {
            this.referenceToMatchingModelElements.clear();
            this.gatherPotentialParameters();
            List newEvents = this.computeAllPossibleEvents().stream().filter(m -> !this.events.stream().anyMatch(event -> m.entrySet().stream().allMatch(entry -> {
                Object val2;
                EStructuralFeature ref = (EStructuralFeature)entry.getKey();
                Object val1 = event.getParameters().get(ref);
                return val1 == (val2 = entry.getValue());
            }))).map(m -> new EventInstance((Event)this.factory.create(this.eventClass), m)).filter(event -> this.canDisplayEventFunction.apply((EventInstance)event)).collect(Collectors.toList());
            List toRemove = this.events.stream().filter(event -> this.canDisplayEventFunction.apply((EventInstance)event) == false).collect(Collectors.toList());
            this.events.removeAll(toRemove);
            this.events.addAll(newEvents);
        });
    }

    private void extractEventParameters() {
        this.eventClass.getEReferences().forEach(f -> {
            EList genericTypes = ((EClass)f.getEType()).getEGenericSuperTypes();
            EList typeArguments = ((EGenericType)genericTypes.get(0)).getETypeArguments();
            EClass correspondingClass = (EClass)((EGenericType)typeArguments.get(0)).getEClassifier();
            this.eventParameterClasses.add(correspondingClass);
            this.referenceToParameterClass.put((EReference)f, correspondingClass);
        });
    }

    private void gatherPotentialParameters() {
        Set<EReference> eventParameters = this.referenceToParameterClass.keySet();
        this.executedModel.getAllContents().forEachRemaining(modelElement -> {
            EClass elementClass = modelElement.eClass();
            eventParameters.stream().filter(r -> {
                EClass parameterClass = this.referenceToParameterClass.get(r);
                return elementClass.getClassifierID() == parameterClass.getClassifierID() || elementClass.getEAllSuperTypes().contains((Object)parameterClass);
            }).forEach(r -> {
                List<EObject> elements = this.referenceToMatchingModelElements.get(r);
                if (elements == null) {
                    elements = new ArrayList<EObject>();
                    this.referenceToMatchingModelElements.put((EReference)r, elements);
                }
                elements.add((EObject)modelElement);
            });
        });
    }

    private List<Map<EStructuralFeature, Object>> computeAllPossibleEvents() {
        ArrayList<Map<EStructuralFeature, Object>> result = new ArrayList<Map<EStructuralFeature, Object>>();
        int nbEvents = this.referenceToMatchingModelElements.values().stream().map(l -> l.size()).reduce((i1, i2) -> i1 * i2).orElse(0);
        ArrayList<Map.Entry<EReference, List<EObject>>> entries = new ArrayList<Map.Entry<EReference, List<EObject>>>(this.referenceToMatchingModelElements.entrySet());
        int i = 0;
        while (i < nbEvents) {
            int j = 1;
            HashMap parametersAssociation = new HashMap();
            for (Map.Entry entry : entries) {
                List modelElements = (List)entry.getValue();
                parametersAssociation.put((EStructuralFeature)entry.getKey(), modelElements.get(i / j % modelElements.size()));
                j *= modelElements.size();
            }
            result.add(parametersAssociation);
            ++i;
        }
        return result;
    }

    static class EventInstanceAttributePropertyValueFactory
    implements Callback<TableColumn.CellDataFeatures<EventInstance, String>, ObservableValue<String>> {
        private final EAttribute attribute;

        public EventInstanceAttributePropertyValueFactory(EAttribute attribute) {
            this.attribute = attribute;
        }

        public ObservableValue<String> call(TableColumn.CellDataFeatures<EventInstance, String> p) {
            EventInstance event = (EventInstance)p.getValue();
            Object refValue = event.getParameters().get(this.attribute);
            if (refValue != null) {
                ReadOnlyObjectWrapper result = new ReadOnlyObjectWrapper((Object)refValue.toString());
                return result;
            }
            return null;
        }
    }

    static class EventInstanceReferencePropertyValueFactory
    implements Callback<TableColumn.CellDataFeatures<EventInstance, String>, ObservableValue<String>> {
        private final EReference reference;
        private final DefaultDeclarativeQualifiedNameProvider nameprovider = new DefaultDeclarativeQualifiedNameProvider();
        private final Function<Object, String> stringGetter = o -> {
            QualifiedName qname;
            if (o instanceof EObject && (qname = this.nameprovider.getFullyQualifiedName((EObject)o)) != null) {
                return qname.toString();
            }
            String string = o.toString();
            return string.substring(string.lastIndexOf(".") + 1);
        };

        public EventInstanceReferencePropertyValueFactory(EReference reference) {
            this.reference = reference;
        }

        public ObservableValue<String> call(TableColumn.CellDataFeatures<EventInstance, String> p) {
            EventInstance event = (EventInstance)p.getValue();
            Object refValue = event.getParameters().get(this.reference);
            if (refValue != null) {
                String string = this.stringGetter.apply(refValue);
                ReadOnlyObjectWrapper result = new ReadOnlyObjectWrapper((Object)string);
                return result;
            }
            return null;
        }
    }
}

