package org.eclipse.gemoc.ui.highlighting;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

@SuppressWarnings("all")
public class DslHighlightingConfiguration extends DefaultHighlightingConfiguration {
  public final static String KEY_ID = "dsl_key";
  
  public final static String VALUE_ID = "dsl_value";
  
  public final static String SEPARATOR_ID = "dsl_separator";
  
  public final static String LINESEPARATOR_ID = "dsl_lineseparator";
  
  @Override
  public void configure(final IHighlightingConfigurationAcceptor acceptor) {
    super.configure(acceptor);
    TextStyle _keyTextStyle = this.keyTextStyle();
    acceptor.acceptDefaultHighlighting(DslHighlightingConfiguration.KEY_ID, "Entry key", _keyTextStyle);
    TextStyle _valueTextStyle = this.valueTextStyle();
    acceptor.acceptDefaultHighlighting(DslHighlightingConfiguration.VALUE_ID, "Entry value", _valueTextStyle);
    TextStyle _separatorTextStyle = this.separatorTextStyle();
    acceptor.acceptDefaultHighlighting(DslHighlightingConfiguration.SEPARATOR_ID, "Entry separator", _separatorTextStyle);
    TextStyle _lineSeparatorTextStyle = this.lineSeparatorTextStyle();
    acceptor.acceptDefaultHighlighting(DslHighlightingConfiguration.LINESEPARATOR_ID, "Line separator", _lineSeparatorTextStyle);
  }
  
  public TextStyle keyTextStyle() {
    TextStyle _defaultTextStyle = this.defaultTextStyle();
    final TextStyle textStyle = _defaultTextStyle.copy();
    RGB _rGB = new RGB(0, 26, 171);
    textStyle.setColor(_rGB);
    return textStyle;
  }
  
  public TextStyle valueTextStyle() {
    TextStyle _defaultTextStyle = this.defaultTextStyle();
    final TextStyle textStyle = _defaultTextStyle.copy();
    textStyle.setStyle(SWT.ITALIC);
    return textStyle;
  }
  
  public TextStyle separatorTextStyle() {
    TextStyle _defaultTextStyle = this.defaultTextStyle();
    final TextStyle textStyle = _defaultTextStyle.copy();
    return textStyle;
  }
  
  public TextStyle lineSeparatorTextStyle() {
    TextStyle _numberTextStyle = this.numberTextStyle();
    final TextStyle textStyle = _numberTextStyle.copy();
    textStyle.setStyle(SWT.NORMAL);
    return textStyle;
  }
}
