/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.internal;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.EclipseMessagingSystem;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.helper.FileHelpers;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.helper.ResourceHelpers;
import org.eclipse.gemoc.commons.messagingsystem.api.reference.FileReference;
import org.eclipse.gemoc.commons.messagingsystem.api.reference.Reference;
import org.eclipse.gemoc.commons.messagingsystem.api.reference.TextReference;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class EclipseReporter {
    public static final String PROBLEM_MARKER_ID = "org.eclipse.gemoc.commons.eclipse.messagingsystem.ui.Kermeta2ProblemMarker";
    public static final String KERMETA_MARKER_ATTRIBUTE = "kermeta2_marker";
    protected MessagingSystem ms;

    public EclipseReporter(EclipseMessagingSystem eclipseMessagingSystem) {
        this.ms = eclipseMessagingSystem;
    }

    public void addMarker(int markerSeverity, Reference ref, String msg, String msgGroup) {
        if (ref instanceof TextReference) {
            try {
                IFile iFile = (IFile)ResourceHelpers.getIResourceFromURL(((TextReference)ref).getFileURL());
                iFile = this.check(iFile, ((TextReference)ref).getFileURL());
                this.addMarker(markerSeverity, PROBLEM_MARKER_ID, iFile, msg, ((TextReference)ref).getBeginLine(), ((TextReference)ref).getBeginOffset(), ((TextReference)ref).getEndOffset(), msgGroup);
                this.ms.log(MessagingSystem.Kind.DevDEBUG, "File marked (" + iFile + ")", "org.eclipse.gemoc.commons.eclipse.messagingsystem.ui");
            }
            catch (Exception e) {
                this.ms.log(MessagingSystem.Kind.DevERROR, "Failed to mark TextFile (" + ((TextReference)ref).getFileURL().getPath() + ") => " + msg, "org.eclipse.gemoc.commons.eclipse.messagingsystem.ui", (Throwable)e);
            }
        } else if (ref instanceof FileReference) {
            try {
                IFile iFile = (IFile)ResourceHelpers.getIResourceFromURL(((FileReference)ref).getFileURL());
                iFile = this.check(iFile, ((FileReference)ref).getFileURL());
                this.addMarker(markerSeverity, PROBLEM_MARKER_ID, iFile, msg, msgGroup);
                this.ms.log(MessagingSystem.Kind.DevDEBUG, "File marked (" + iFile + ")", "org.eclipse.gemoc.commons.eclipse.messagingsystem.ui");
            }
            catch (Exception e) {
                this.ms.log(MessagingSystem.Kind.DevERROR, "Failed to mark File (" + ((FileReference)ref).getFileURL().getPath() + ") => " + msg, "org.eclipse.gemoc.commons.eclipse.messagingsystem.ui", (Throwable)e);
            }
        }
    }

    public void addMarker(int markerSeverity, String Marker, IFile file, String message, Integer lineNumber, Integer beginChar, Integer endChar, String msgGroup) {
        try {
            HashMap<String, Object> datas = new HashMap<String, Object>();
            datas.put("message", message != null ? message : "<null>");
            datas.put("severity", markerSeverity);
            if (beginChar != null) {
                datas.put("charStart", beginChar);
            } else {
                datas.put("charStart", 0);
            }
            if (endChar != null) {
                datas.put("charEnd", endChar);
            } else {
                datas.put("charEnd", 0);
            }
            if (lineNumber != null) {
                datas.put("lineNumber", lineNumber);
            }
            datas.put(KERMETA_MARKER_ATTRIBUTE, msgGroup);
            MarkerUtilities.createMarker((IResource)file, datas, (String)"org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            this.ms.log(MessagingSystem.Kind.DevERROR, "Failed to mark TextFile", "org.eclipse.gemoc.commons.eclipse.messagingsystem.ui", (Throwable)e);
        }
    }

    public void addMarker(int markerSeverity, String Marker, IFile file, String message, String msgGroup) {
        this.addMarker(markerSeverity, Marker, file, message, 0, 0, 0, msgGroup);
    }

    private IFile check(IFile iFile, URL theRef) {
        if (iFile != null) {
            return iFile;
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject aProject = iProjectArray[n2];
            IFile attempt = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(FileHelpers.URLToStringWithoutFile(theRef).replaceFirst(aProject.getLocation().toString().substring(0, aProject.getLocation().toString().lastIndexOf(aProject.getName())), ""));
            if (attempt != null) {
                return attempt;
            }
            ++n2;
        }
        return null;
    }

    public void flushProblem(String problemGroup, URL url) {
        try {
            IResource ifile = ResourceHelpers.getIResourceFromURL(url);
            if (ifile != null) {
                IMarker[] iMarkerArray = ifile.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker aMarker = iMarkerArray[n2];
                    if (aMarker.getAttribute(KERMETA_MARKER_ATTRIBUTE).equals(problemGroup)) {
                        aMarker.delete();
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            this.ms.log(MessagingSystem.Kind.DevERROR, "Failed to flush markers for group " + problemGroup, "org.eclipse.gemoc.commons.eclipse.messagingsystem.ui", (Throwable)e);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void flushAllProblems(URL url) {
        try {
            IResource ifile = ResourceHelpers.getIResourceFromURL(url);
            if (ifile != null) {
                ifile.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            }
        }
        catch (CoreException e) {
            this.ms.log(MessagingSystem.Kind.DevERROR, "Failed to flush all markers", "org.eclipse.gemoc.commons.eclipse.messagingsystem.ui", (Throwable)e);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

