/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p3order.AbstractPortDistributor;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.alg.layered.properties.PortType;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public final class LayerTotalPortDistributor
extends AbstractPortDistributor {
    private static final float INCR_ONE = 1.0f;
    private static final float INCR_TWO = 2.0f;
    private static final float INCR_THREE = 3.0f;
    private static final float INCR_FOUR = 4.0f;

    public LayerTotalPortDistributor(float[] portRanks) {
        super(portRanks);
    }

    @Override
    protected float calculatePortRanks(LNode node, float rankSum, PortType type) {
        float[] portRanks = this.getPortRanks();
        if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
            switch (type) {
                case INPUT: {
                    int inputCount = 0;
                    int northInputCount = 0;
                    for (LPort port : node.getPorts()) {
                        if (port.getIncomingEdges().isEmpty()) continue;
                        ++inputCount;
                        if (port.getSide() != PortSide.NORTH) continue;
                        ++northInputCount;
                    }
                    float northPos = rankSum + (float)northInputCount;
                    float restPos = rankSum + (float)inputCount;
                    for (LPort port : node.getPorts(PortType.INPUT)) {
                        if (port.getSide() == PortSide.NORTH) {
                            portRanks[port.id] = northPos;
                            northPos -= 1.0f;
                            continue;
                        }
                        portRanks[port.id] = restPos;
                        restPos -= 1.0f;
                    }
                    return inputCount;
                }
                case OUTPUT: {
                    int pos = 0;
                    for (LPort port : node.getPorts(PortType.OUTPUT)) {
                        portRanks[port.id] = rankSum + (float)(++pos);
                    }
                    return pos;
                }
            }
            throw new IllegalArgumentException();
        }
        float minIncr = 4.0f;
        float maxIncr = 0.0f;
        for (LPort port : node.getPorts(type)) {
            float incr = LayerTotalPortDistributor.getPortIncr(type, port.getSide());
            minIncr = Math.min(minIncr, incr - 1.0f);
            maxIncr = Math.max(maxIncr, incr);
        }
        if (maxIncr > minIncr) {
            for (LPort port : node.getPorts(type)) {
                portRanks[port.id] = rankSum + LayerTotalPortDistributor.getPortIncr(type, port.getSide()) - minIncr;
            }
            return maxIncr - minIncr;
        }
        return 0.0f;
    }

    private static float getPortIncr(PortType type, PortSide side) {
        switch (type) {
            case INPUT: {
                switch (side) {
                    case NORTH: {
                        return 1.0f;
                    }
                    case WEST: {
                        return 2.0f;
                    }
                    case SOUTH: {
                        return 3.0f;
                    }
                    case EAST: {
                        return 4.0f;
                    }
                }
                break;
            }
            case OUTPUT: {
                switch (side) {
                    case NORTH: {
                        return 1.0f;
                    }
                    case EAST: {
                        return 2.0f;
                    }
                    case SOUTH: {
                        return 3.0f;
                    }
                    case WEST: {
                        return 4.0f;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Port type is undefined");
            }
        }
        return 0.0f;
    }
}

