/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.BetweenLayerEdgeAllCrossingsCounter;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

public class BetweenLayerHyperedgeAllCrossingsCounter
extends BetweenLayerEdgeAllCrossingsCounter {
    public BetweenLayerHyperedgeAllCrossingsCounter(LNode[][] graph) {
        super(graph);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int countCrossings(LNode[] leftLayer, LNode[] rightLayer) {
        void var14_78;
        void var14_77;
        int n;
        void var14_75;
        void var13_66;
        void var12_54;
        void var11_41;
        int sourceCount = 0;
        LNode[] lNodeArray = leftLayer;
        int n2 = leftLayer.length;
        int n22 = 0;
        while (n22 < n2) {
            LNode node = lNodeArray[n22];
            if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort port : node.getPorts()) {
                    int portEdges = 0;
                    for (LEdge lEdge : port.getOutgoingEdges()) {
                        if (node.getLayer() == lEdge.getTarget().getNode().getLayer()) continue;
                        ++portEdges;
                    }
                    if (portEdges <= 0) continue;
                    this.getPortPos()[port.id] = sourceCount++;
                }
            } else {
                int nodeEdges232 = 0;
                for (LPort port : node.getPorts()) {
                    for (LEdge lEdge : port.getOutgoingEdges()) {
                        if (node.getLayer() == lEdge.getTarget().getNode().getLayer()) continue;
                        ++nodeEdges232;
                    }
                    this.getPortPos()[port.id] = sourceCount;
                }
                if (nodeEdges232 > 0) {
                    ++sourceCount;
                }
            }
            ++n22;
        }
        int targetCount = 0;
        LNode[] nodeEdges232 = rightLayer;
        int n3 = rightLayer.length;
        n2 = 0;
        while (n2 < n3) {
            LNode node = nodeEdges232[n2];
            if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                int northInputPorts = 0;
                block14: for (LPort port : node.getPorts()) {
                    if (port.getSide() != PortSide.NORTH) break;
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++northInputPorts;
                        continue block14;
                    }
                }
                int otherInputPorts = 0;
                ListIterator<LPort> listIterator = node.getPorts().listIterator(node.getPorts().size());
                while (listIterator.hasPrevious()) {
                    void var13_60;
                    LPort lPort = listIterator.previous();
                    boolean bl = false;
                    for (LEdge lEdge : lPort.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++var13_60;
                    }
                    if (var13_60 <= 0) continue;
                    if (lPort.getSide() == PortSide.NORTH) {
                        this.getPortPos()[lPort.id] = targetCount++;
                        continue;
                    }
                    this.getPortPos()[lPort.id] = targetCount + northInputPorts + otherInputPorts;
                    ++otherInputPorts;
                }
                targetCount += otherInputPorts;
            } else {
                int nodeEdges = 0;
                for (LPort port : node.getPorts()) {
                    for (LEdge lEdge : port.getIncomingEdges()) {
                        if (node.getLayer() == lEdge.getSource().getNode().getLayer()) continue;
                        ++nodeEdges;
                    }
                    this.getPortPos()[port.id] = targetCount;
                }
                if (nodeEdges > 0) {
                    ++targetCount;
                }
            }
            ++n2;
        }
        HashMap<Object, Hyperedge> port2HyperedgeMap = new HashMap<Object, Hyperedge>();
        HashSet<Hyperedge> hyperedgeSet = new HashSet<Hyperedge>();
        LNode[] port = leftLayer;
        int nodeEdges = leftLayer.length;
        int nodeEdges232 = 0;
        while (nodeEdges232 < nodeEdges) {
            LNode node = port[nodeEdges232];
            for (LPort lPort : node.getPorts()) {
                for (LEdge lEdge : lPort.getOutgoingEdges()) {
                    LPort targetPort = lEdge.getTarget();
                    if (node.getLayer() == targetPort.getNode().getLayer()) continue;
                    Hyperedge sourceHE = (Hyperedge)port2HyperedgeMap.get((Object)lPort);
                    Hyperedge targetHE = (Hyperedge)port2HyperedgeMap.get((Object)targetPort);
                    if (sourceHE == null && targetHE == null) {
                        Hyperedge hyperedge = new Hyperedge();
                        hyperedgeSet.add(hyperedge);
                        hyperedge.edges.add(lEdge);
                        hyperedge.ports.add(lPort);
                        port2HyperedgeMap.put((Object)lPort, hyperedge);
                        hyperedge.ports.add(targetPort);
                        port2HyperedgeMap.put((Object)targetPort, hyperedge);
                        continue;
                    }
                    if (sourceHE == null) {
                        targetHE.edges.add(lEdge);
                        targetHE.ports.add(lPort);
                        port2HyperedgeMap.put((Object)lPort, targetHE);
                        continue;
                    }
                    if (targetHE == null) {
                        sourceHE.edges.add(lEdge);
                        sourceHE.ports.add(targetPort);
                        port2HyperedgeMap.put((Object)targetPort, sourceHE);
                        continue;
                    }
                    if (sourceHE == targetHE) {
                        sourceHE.edges.add(lEdge);
                        continue;
                    }
                    sourceHE.edges.add(lEdge);
                    for (LPort p : targetHE.ports) {
                        port2HyperedgeMap.put((Object)p, sourceHE);
                    }
                    sourceHE.edges.addAll(targetHE.edges);
                    sourceHE.ports.addAll(targetHE.ports);
                    hyperedgeSet.remove(targetHE);
                }
            }
            ++nodeEdges232;
        }
        Object[] hyperedges = hyperedgeSet.toArray(new Hyperedge[hyperedgeSet.size()]);
        Layer leftLayerRef = leftLayer[0].getLayer();
        Layer rightLayerRef = rightLayer[0].getLayer();
        Object[] objectArray = hyperedges;
        int n4 = hyperedges.length;
        boolean bl = false;
        while (var11_41 < n4) {
            Object he = objectArray[var11_41];
            ((Hyperedge)he).upperLeft = sourceCount;
            ((Hyperedge)he).upperRight = targetCount;
            for (LPort lPort : ((Hyperedge)he).ports) {
                int pos = this.getPortPos()[lPort.id];
                if (lPort.getNode().getLayer() == leftLayerRef) {
                    if (pos < ((Hyperedge)he).upperLeft) {
                        ((Hyperedge)he).upperLeft = pos;
                        ((Hyperedge)he).hashCode = ((Object)((Object)lPort)).hashCode();
                    }
                    if (pos <= ((Hyperedge)he).lowerLeft) continue;
                    ((Hyperedge)he).lowerLeft = pos;
                    continue;
                }
                if (lPort.getNode().getLayer() != rightLayerRef) continue;
                if (pos < ((Hyperedge)he).upperRight) {
                    ((Hyperedge)he).upperRight = pos;
                }
                if (pos <= ((Hyperedge)he).lowerRight) continue;
                ((Hyperedge)he).lowerRight = pos;
            }
            ++var11_41;
        }
        Arrays.sort(hyperedges);
        int[] southSequence = new int[hyperedges.length];
        int[] nArray = new int[targetCount + 1];
        boolean bl2 = false;
        while (var12_54 < hyperedges.length) {
            southSequence[var12_54] = ((Hyperedge)hyperedges[var12_54]).upperRight;
            nArray[southSequence[var12_54]] = 1;
            ++var12_54;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        while (var13_66 < nArray.length) {
            void var12_56;
            if (nArray[var13_66] == 1) {
                nArray[var13_66] = var12_56;
            } else {
                --var12_56;
            }
            ++var13_66;
        }
        boolean bl5 = false;
        boolean bl6 = false;
        while (var14_75 < southSequence.length) {
            void v0 = var14_75;
            southSequence[v0] = southSequence[v0] + nArray[southSequence[var14_75]];
            n = Math.max(n, southSequence[var14_75] + 1);
            ++var14_75;
        }
        boolean bl7 = true;
        while (var14_77 < n) {
            var14_77 *= 2;
        }
        int treeSize = 2 * var14_77 - 1;
        --var14_78;
        int[] tree = new int[treeSize];
        int crossings = 0;
        int[] nArray2 = southSequence;
        int n5 = southSequence.length;
        int n6 = 0;
        while (n6 < n5) {
            int index;
            int element = nArray2[n6];
            int n7 = index = element + var14_78;
            tree[n7] = tree[n7] + 1;
            while (index > 0) {
                if (index % 2 > 0) {
                    crossings += tree[index + 1];
                }
                int n8 = index = (index - 1) / 2;
                tree[n8] = tree[n8] + 1;
            }
            ++n6;
        }
        Object[] leftCorners = new HyperedgeCorner[hyperedges.length * 2];
        int i4 = 0;
        while (i4 < hyperedges.length) {
            leftCorners[2 * i4] = new HyperedgeCorner((Hyperedge)hyperedges[i4], ((Hyperedge)hyperedges[i4]).upperLeft, ((Hyperedge)hyperedges[i4]).lowerLeft, HyperedgeCorner.Type.UPPER);
            leftCorners[2 * i4 + 1] = new HyperedgeCorner((Hyperedge)hyperedges[i4], ((Hyperedge)hyperedges[i4]).lowerLeft, ((Hyperedge)hyperedges[i4]).upperLeft, HyperedgeCorner.Type.LOWER);
            ++i4;
        }
        Arrays.sort(leftCorners);
        int openHyperedges = 0;
        Object[] objectArray2 = leftCorners;
        int n9 = leftCorners.length;
        int n10 = 0;
        while (n10 < n9) {
            Object leftCorner = objectArray2[n10];
            switch (((HyperedgeCorner)leftCorner).type) {
                case UPPER: {
                    ++openHyperedges;
                    break;
                }
                case LOWER: {
                    crossings += --openHyperedges;
                }
            }
            ++n10;
        }
        Object[] rightCorners = new HyperedgeCorner[hyperedges.length * 2];
        int i5 = 0;
        while (i5 < hyperedges.length) {
            rightCorners[2 * i5] = new HyperedgeCorner((Hyperedge)hyperedges[i5], ((Hyperedge)hyperedges[i5]).upperRight, ((Hyperedge)hyperedges[i5]).lowerRight, HyperedgeCorner.Type.UPPER);
            rightCorners[2 * i5 + 1] = new HyperedgeCorner((Hyperedge)hyperedges[i5], ((Hyperedge)hyperedges[i5]).lowerRight, ((Hyperedge)hyperedges[i5]).upperRight, HyperedgeCorner.Type.LOWER);
            ++i5;
        }
        Arrays.sort(rightCorners);
        openHyperedges = 0;
        Object[] objectArray3 = rightCorners;
        int n11 = rightCorners.length;
        n9 = 0;
        while (n9 < n11) {
            Object rightCorner = objectArray3[n9];
            switch (((HyperedgeCorner)rightCorner).type) {
                case UPPER: {
                    ++openHyperedges;
                    break;
                }
                case LOWER: {
                    crossings += --openHyperedges;
                }
            }
            ++n9;
        }
        return crossings;
    }

    private static class Hyperedge
    implements Comparable<Hyperedge> {
        private final List<LEdge> edges = new LinkedList<LEdge>();
        private final List<LPort> ports = new LinkedList<LPort>();
        private int upperLeft;
        private int lowerLeft;
        private int upperRight;
        private int lowerRight;
        private int hashCode;

        private Hyperedge() {
        }

        @Override
        public int compareTo(Hyperedge other) {
            if (this.upperLeft < other.upperLeft) {
                return -1;
            }
            if (this.upperLeft > other.upperLeft) {
                return 1;
            }
            if (this.upperRight < other.upperRight) {
                return -1;
            }
            if (this.upperRight > other.upperRight) {
                return 1;
            }
            return this.hashCode - other.hashCode;
        }
    }

    private static class HyperedgeCorner
    implements Comparable<HyperedgeCorner> {
        private final Hyperedge hyperedge;
        private final int position;
        private final int oppositePosition;
        private final Type type;

        HyperedgeCorner(Hyperedge hyperedge, int position, int oppositePosition, Type type) {
            this.hyperedge = hyperedge;
            this.position = position;
            this.oppositePosition = oppositePosition;
            this.type = type;
        }

        @Override
        public int compareTo(HyperedgeCorner other) {
            if (this.position < other.position) {
                return -1;
            }
            if (this.position > other.position) {
                return 1;
            }
            if (this.oppositePosition < other.oppositePosition) {
                return -1;
            }
            if (this.oppositePosition > other.oppositePosition) {
                return 1;
            }
            if (this.hyperedge != other.hyperedge) {
                return this.hyperedge.hashCode - other.hyperedge.hashCode;
            }
            if (this.type == Type.UPPER && other.type == Type.LOWER) {
                return -1;
            }
            if (this.type == Type.LOWER && other.type == Type.UPPER) {
                return 1;
            }
            return 0;
        }

        private static enum Type {
            UPPER,
            LOWER;

        }
    }
}

