/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.builder;

import com.google.inject.Inject;
import fr.inria.diverse.melange.lib.ModelUtils;
import fr.inria.diverse.melange.metamodel.melange.Import;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Builder for the {@link Import} operator.
 */
@SuppressWarnings("all")
public class ImportBuilder extends OperatorBuilder<Import> {
  @Inject
  private ModelUtils modelUtils;

  @Inject
  @Extension
  private RenamerHelper _renamerHelper;

  public ImportBuilder(final Import source) {
    super(source);
  }

  /**
   * Loads the {@link EPackage} associated to the {@link Import} operator
   * and apply the associated renaming rules.
   */
  @Override
  public void make() {
    final Function1<EPackage, Boolean> _function = (EPackage it) -> {
      EPackage _eSuperPackage = it.getESuperPackage();
      return Boolean.valueOf((_eSuperPackage == null));
    };
    this.model = IterableExtensions.<EPackage>toSet(IterableExtensions.<EPackage>filter(this.modelUtils.loadAllPkgs(this.source.getEcoreUri()), _function));
    final Consumer<EPackage> _function_1 = (EPackage it) -> {
      this._renamerHelper.applyRenaming(it, this.source.getMappingRules());
    };
    this.model.forEach(_function_1);
  }
}
