/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.model.business.internal.query.ResourceQueryInternal;
import org.eclipse.sirius.tools.api.Messages;

public class ControlledResourcesDetector
extends ResourceSetListenerImpl {
    private static final NotificationFilter CONTROLLED_RESOURCES_EVENTS = NotificationFilter.createFeatureFilter(ResourceSet.class, (int)0).and(NotificationFilter.NOT_TOUCH);
    private DAnalysisSessionImpl session;

    public ControlledResourcesDetector(DAnalysisSessionImpl session) {
        this.session = Objects.requireNonNull(session);
    }

    public void initialize() {
        this.session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public NotificationFilter getFilter() {
        return CONTROLLED_RESOURCES_EVENTS;
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public boolean isAggregatePrecommitListener() {
        return true;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        for (Notification notif : event.getNotifications()) {
            boolean resourcesWereAdded;
            int change = notif.getEventType();
            boolean bl = resourcesWereAdded = change == 3 || change == 1 || change == 5;
            if (!resourcesWereAdded) continue;
            return new RefreshControlledResourcesCommand(this.session);
        }
        return null;
    }

    public void dispose() {
        if (this.session != null) {
            this.session.getTransactionalEditingDomain().removeResourceSetListener((ResourceSetListener)this);
        }
        this.session = null;
    }

    static void refreshControlledResources(DAnalysisSessionImpl session) {
        Collection<Resource> semantics = session.getSemanticResources();
        ArrayList allResources = new ArrayList(session.getTransactionalEditingDomain().getResourceSet().getResources());
        EList controlledResources = session.getControlledResources();
        boolean addedControlledResources = false;
        for (Resource resource : allResources) {
            if (controlledResources.contains(resource) || !new ResourceQueryInternal(resource).hasControlledRootIn(semantics)) continue;
            if (controlledResources instanceof InternalEList) {
                ((InternalEList)controlledResources).addUnique((Object)resource);
            } else {
                controlledResources.add(resource);
            }
            addedControlledResources = true;
            session.registerResourceInCrossReferencer(resource);
        }
        boolean removedControlledResources = controlledResources.retainAll(allResources);
        if (addedControlledResources || removedControlledResources) {
            session.notifyListeners(11);
            session.setSemanticResourcesNotUptodate();
        }
    }

    private static class RefreshControlledResourcesCommand
    extends RecordingCommand {
        private final DAnalysisSessionImpl session;

        RefreshControlledResourcesCommand(DAnalysisSessionImpl session) {
            super(session.getTransactionalEditingDomain(), Messages.ControlledResourcesDetector_refreshCommandLabel);
            this.session = session;
        }

        protected void doExecute() {
            ControlledResourcesDetector.refreshControlledResources(this.session);
        }
    }
}

