/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.ale.interpreted.engine.sirius;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.query.runtime.QueryParsing;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.interpreter.IAleInterpreter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.AleInterpreter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.OptimizedEvaluationResult;
import org.eclipse.emf.ecoretools.ale.core.interpreter.notapi.EvalEnvironment;
import org.eclipse.gemoc.ale.interpreted.engine.AleEngine;
import org.eclipse.gemoc.executionframework.engine.commons.GenericModelExecutionContext;
import org.eclipse.sirius.common.acceleo.aql.business.internal.AQLSiriusInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IEvaluationResult;
import org.eclipse.xtext.EcoreUtil2;

public class ALESiriusInterpreter
extends AQLSiriusInterpreter {
    HashSet<AleEngine> knownEngines = new HashSet();
    private static ALESiriusInterpreter instance = new ALESiriusInterpreter();
    EditionAleInterpreter editionAleInterpreterCache;

    private ALESiriusInterpreter() {
    }

    public static ALESiriusInterpreter getDefault() {
        return instance;
    }

    public boolean provides(String expression) {
        return expression != null && expression.startsWith("ale:");
    }

    public IEvaluationResult evaluateExpression(EObject target, String fullExpression) throws EvaluationException {
        Optional<AleInterpreter> aleInterpreter = this.findInterpreterForModel(target);
        if (aleInterpreter.isPresent() && aleInterpreter.get().getQueryEnvironment() != null) {
            return this.evaluateExpressionWithInterpreter(target, fullExpression, (IAleInterpreter)aleInterpreter.get());
        }
        if (this.editionAleInterpreterCache != null && this.editionAleInterpreterCache.resSet != target.eResource().getResourceSet()) {
            this.editionAleInterpreterCache.env.close();
            this.editionAleInterpreterCache.aleInterpreter.close();
            this.editionAleInterpreterCache = null;
        }
        if (this.editionAleInterpreterCache == null) {
            List<EPackage> metamodels = this.getMetamodels(target);
            List metmodelsPathes = metamodels.stream().map(ePack -> ePack.eResource().getURI().toString()).collect(Collectors.toList());
            IAleEnvironment env = IAleEnvironment.fromPaths(metmodelsPathes, new ArrayList());
            IAleInterpreter interpreter = env.getInterpreter();
            new EvalEnvironment(env, null, null);
            this.editionAleInterpreterCache = new EditionAleInterpreter(target.eResource().getResourceSet(), env, interpreter);
        }
        IEvaluationResult res = this.evaluateExpressionWithInterpreter(target, fullExpression, this.editionAleInterpreterCache.aleInterpreter);
        return res;
    }

    public IEvaluationResult evaluateExpressionWithInterpreter(EObject target, String fullExpression, IAleInterpreter aleInterpreter) throws EvaluationException {
        this.javaExtensions.reloadIfNeeded();
        String expression = fullExpression.replaceFirst("ale:", "");
        Map variables = this.getVariables();
        variables.put("self", target);
        IQueryEnvironment queryEnv = ((AleInterpreter)aleInterpreter).getQueryEnvironment();
        IQueryBuilderEngine builder = QueryParsing.newBuilder((IQueryEnvironment)queryEnv);
        IQueryBuilderEngine.AstResult build = builder.build(expression);
        IQueryEvaluationEngine evaluationEngine = QueryEvaluation.newEngine((IQueryEnvironment)queryEnv);
        EvaluationResult evalResult = evaluationEngine.eval(build, variables);
        BasicDiagnostic diagnostic = new BasicDiagnostic();
        if (build.getDiagnostic().getSeverity() != 0) {
            diagnostic.merge(build.getDiagnostic());
        }
        if (evalResult.getDiagnostic().getSeverity() != 0) {
            diagnostic.merge(evalResult.getDiagnostic());
        }
        return new OptimizedEvaluationResult(Optional.ofNullable(evalResult.getResult()), (Diagnostic)diagnostic);
    }

    protected Optional<AleInterpreter> findInterpreterForModel(EObject target) {
        for (AleEngine engine : this.knownEngines) {
            if (((GenericModelExecutionContext)engine.getExecutionContext()).getResourceModel().getResourceSet() != target.eResource().getResourceSet()) continue;
            return Optional.ofNullable(engine.getInterpreter());
        }
        return Optional.empty();
    }

    protected List<EPackage> getMetamodels(EObject target) {
        ArrayList<EPackage> metamodels = new ArrayList<EPackage>();
        for (Resource res : target.eResource().getResourceSet().getResources()) {
            metamodels.addAll(EcoreUtil2.typeSelect((List)EcoreUtil2.eAllContentsAsList((Resource)res), EPackage.class));
        }
        return metamodels;
    }

    public void addAleEngine(AleEngine engine) {
        this.knownEngines.add(engine);
    }

    public void removeAleEngine(AleEngine engine) {
        this.knownEngines.remove((Object)engine);
    }

    private class EditionAleInterpreter {
        public ResourceSet resSet;
        IAleEnvironment env;
        public IAleInterpreter aleInterpreter;

        public EditionAleInterpreter(ResourceSet resSet, IAleEnvironment env, IAleInterpreter aleInterpreter) {
            this.resSet = resSet;
            this.env = env;
            this.aleInterpreter = aleInterpreter;
        }
    }
}

