/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.uri;

import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.internal.uri.ViewpointProtocolException;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.util.DescriptionResourceFactoryImpl;

public class ViewpointProtocolParser
extends DescriptionResourceFactoryImpl {
    public Resource createResource(URI uri) {
        ViewpointProtocolParser.getViewpoint(uri);
        return super.createResource(uri);
    }

    public static Viewpoint getViewpoint(URI uri) throws ViewpointProtocolException {
        if (uri.segmentCount() == 2 && "viewpoint".equals(uri.scheme())) {
            Set<Viewpoint> viewpoints = ViewpointRegistry.getInstance().getViewpoints();
            String pluginName = URI.decode((String)uri.segment(0));
            String viewpointName = URI.decode((String)uri.lastSegment());
            Set<Viewpoint> vpWithGoodName = ViewpointProtocolParser.filterByNameAndId(viewpoints, viewpointName, pluginName);
            if (!vpWithGoodName.isEmpty()) {
                return vpWithGoodName.iterator().next();
            }
        } else {
            throw new ViewpointProtocolException(MessageFormat.format(Messages.ViewpointProtocolParser_invalidURIErrorMsg, uri));
        }
        throw new ViewpointProtocolException(MessageFormat.format(Messages.ViewpointProtocolParser_noViewpointErrorMsg, uri));
    }

    private static Set<Viewpoint> filterByNameAndId(Set<Viewpoint> viewpoints, String viewpointName, String pluginId) {
        LinkedHashSet<Viewpoint> filtered = new LinkedHashSet<Viewpoint>();
        for (Viewpoint viewpoint : viewpoints) {
            if (!viewpointName.equals(viewpoint.getName()) || !ViewpointProtocolParser.hasGoodPluginID(viewpoint, pluginId)) continue;
            filtered.add(viewpoint);
        }
        return filtered;
    }

    private static boolean hasGoodPluginID(Viewpoint viewpoint, String pluginId) {
        URI vpURI;
        Resource resource = viewpoint.eResource();
        if (resource != null && resource.getURI() != null && (vpURI = resource.getURI()).isPlatform()) {
            String uriPluginId = vpURI.segment(1);
            return pluginId.equals(uriPluginId);
        }
        return false;
    }

    public static boolean match(URI resourceSetURi, String viewpointURI) {
        URI computedURI;
        boolean result = false;
        if (resourceSetURi.isPlatform() && (computedURI = ViewpointProtocolParser.buildViewpointUri(resourceSetURi)) != null) {
            if (URI.createURI((String)viewpointURI, (boolean)false).toString().equals(computedURI.toString())) {
                result = true;
            } else {
                try {
                    result = URI.decode((String)computedURI.toString()).matches(viewpointURI);
                }
                catch (PatternSyntaxException patternSyntaxException) {}
            }
        }
        return result;
    }

    public static URI buildViewpointUri(URI resourceSetURi) {
        URI result = null;
        if (resourceSetURi != null && resourceSetURi.isPlatform()) {
            String uriPluginID = ViewpointProtocolParser.extractPluginID(resourceSetURi);
            String viewpointName = ViewpointProtocolParser.extractViewpointName(resourceSetURi);
            String computedURI = "viewpoint:/" + uriPluginID + "/" + viewpointName;
            result = URI.createURI((String)computedURI);
        }
        return result;
    }

    private static String extractViewpointName(URI resourceSetURi) {
        String fragment = resourceSetURi.fragment();
        if (fragment.contains("'")) {
            String name = fragment.substring(fragment.indexOf("'") + 1);
            name = name.substring(0, name.indexOf("'"));
            return name;
        }
        return Messages.ViewpointProtocolParser_unamed;
    }

    private static String extractPluginID(URI resourceSetURi) {
        return resourceSetURi.segment(1);
    }
}

