/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryBuilderEngine;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.acceleo.query.runtime.QueryParsing;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.AleInterpreter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.OptimizedEvaluationResult;
import org.eclipse.emf.ecoretools.ale.core.messages.Messages;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IEvaluationResult;

public class AleDynamicExpressionEvaluator {
    private AleInterpreter aleInterpreter;

    public AleDynamicExpressionEvaluator(AleInterpreter aleInterpreter) {
        this.aleInterpreter = aleInterpreter;
    }

    public IEvaluationResult evaluateExpression(EObject target, String fullExpression) {
        String expression = fullExpression.replaceFirst("ale:", "");
        HashMap<String, EObject> variables = new HashMap<String, EObject>();
        variables.put("self", target);
        IQueryEnvironment queryEnv = this.aleInterpreter.getQueryEnvironment();
        if (queryEnv != null) {
            IQueryBuilderEngine builder = QueryParsing.newBuilder((IQueryEnvironment)queryEnv);
            IQueryBuilderEngine.AstResult build = builder.build(expression);
            IQueryEvaluationEngine evaluationEngine = QueryEvaluation.newEngine((IQueryEnvironment)queryEnv);
            EvaluationResult evalResult = evaluationEngine.eval(build, variables);
            BasicDiagnostic diagnostic = new BasicDiagnostic();
            if (build.getDiagnostic().getSeverity() != 0) {
                diagnostic.merge(build.getDiagnostic());
            }
            if (evalResult.getDiagnostic().getSeverity() != 0) {
                diagnostic.merge(evalResult.getDiagnostic());
            }
            return new OptimizedEvaluationResult(Optional.ofNullable(evalResult.getResult()), (Diagnostic)diagnostic);
        }
        return org.eclipse.sirius.common.tools.api.interpreter.EvaluationResult.ofValue(null);
    }

    public Object evaluate(EObject target, String fullExpression) throws EvaluationException {
        IEvaluationResult evaluationResult = this.evaluateExpression(target, fullExpression);
        Diagnostic diagnostic = evaluationResult.getDiagnostic();
        if (diagnostic.getSeverity() == 4) {
            String uri = EcoreUtil.getURI((EObject)target).toString();
            String message = MessageFormat.format(Messages.AleInterpreter_errorWithExpression, fullExpression, diagnostic.toString(), uri, target);
            throw new EvaluationException(message, diagnostic.getException());
        }
        return evaluationResult.getValue();
    }

    public Collection<EObject> evaluateCollection(EObject context, String expression) throws EvaluationException {
        Object raw = this.evaluate(context, expression);
        Collection<Object> result = raw instanceof Collection ? Lists.newArrayList((Iterable)Iterables.filter((Iterable)((Collection)raw), EObject.class)) : (raw instanceof EObject ? Collections.singleton((EObject)raw) : (raw != null && raw.getClass().isArray() ? Lists.newArrayList((Iterable)Iterables.filter((Iterable)Lists.newArrayList((Object[])((Object[])raw)), EObject.class)) : Collections.emptySet()));
        return result;
    }

    public boolean evaluateBoolean(EObject context, String expression) throws EvaluationException {
        String toString;
        Object raw = this.evaluate(context, expression);
        boolean result = raw == null ? false : (raw instanceof Boolean ? (Boolean)raw : ("true".equalsIgnoreCase(toString = raw.toString()) ? true : !"false".equalsIgnoreCase(toString)));
        return result;
    }

    public EObject evaluateEObject(EObject context, String expression) throws EvaluationException {
        Object raw = this.evaluate(context, expression);
        if (raw instanceof EObject) {
            return (EObject)raw;
        }
        return null;
    }

    public String evaluateString(EObject context, String expression) throws EvaluationException {
        Object raw = this.evaluate(context, expression);
        if (raw != null) {
            return String.valueOf(raw);
        }
        return "";
    }

    public Integer evaluateInteger(EObject context, String expression) throws EvaluationException {
        Object raw = this.evaluate(context, expression);
        try {
            return Integer.parseInt(String.valueOf(raw));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

