/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.jvmmodel;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import fr.inria.diverse.melange.ast.ModelingElementExtensions;
import fr.inria.diverse.melange.lib.IModelType;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Infers the Java code supporting the definition of {@link ModelType}s
 */
@SuppressWarnings("all")
public class ModelTypeInferrer {
  @Inject
  @Extension
  private JvmTypesBuilder _jvmTypesBuilder;
  
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Inject
  @Extension
  private ModelingElementExtensions _modelingElementExtensions;
  
  /**
   * Currently only generates a Java class for a {@link ModelType}
   * implementing the IModelType interface and providing basic access
   * to the contents of the underlying model and the corresponding factory
   * 
   * @see IModelType
   */
  public void generateInterfaces(final ModelType mt, final IJvmDeclaredTypeAcceptor acceptor, @Extension final JvmTypeReferenceBuilder builder) {
    final Stopwatches.StoppedTask task = Stopwatches.forTask("generate model types");
    task.start();
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmTypeReference _typeRef = builder.typeRef(IModelType.class);
        ModelTypeInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
        EList<JvmMember> _members = it.getMembers();
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setAbstract(true);
          }
        };
        JvmOperation _method = ModelTypeInferrer.this._jvmTypesBuilder.toMethod(mt, "getContents", builder.typeRef(EList.class, builder.typeRef(EObject.class)), _function);
        ModelTypeInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
        final Function1<GenModel, EList<GenPackage>> _function_1 = new Function1<GenModel, EList<GenPackage>>() {
          @Override
          public EList<GenPackage> apply(final GenModel it) {
            return it.getUsedGenPackages();
          }
        };
        final List<GenPackage> excluded = IterableExtensions.<GenPackage>toList(Iterables.<GenPackage>concat(IterableExtensions.<GenModel, EList<GenPackage>>map(ModelTypeInferrer.this._modelingElementExtensions.getGenmodels(mt), _function_1)));
        final Function1<GenPackage, Boolean> _function_2 = new Function1<GenPackage, Boolean>() {
          @Override
          public Boolean apply(final GenPackage genPkg) {
            boolean _contains = excluded.contains(genPkg);
            return Boolean.valueOf((!_contains));
          }
        };
        final Consumer<GenPackage> _function_3 = new Consumer<GenPackage>() {
          @Override
          public void accept(final GenPackage genPkg) {
            EList<JvmMember> _members = it.getMembers();
            String _factoryName = genPkg.getFactoryName();
            String _plus = ("get" + _factoryName);
            final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
              @Override
              public void apply(final JvmOperation it) {
                it.setAbstract(true);
              }
            };
            JvmOperation _method = ModelTypeInferrer.this._jvmTypesBuilder.toMethod(mt, _plus, builder.typeRef(genPkg.getQualifiedFactoryInterfaceName()), _function);
            ModelTypeInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
          }
        };
        IterableExtensions.<GenPackage>filter(ModelTypeInferrer.this._modelingElementExtensions.getAllGenPkgs(mt), _function_2).forEach(_function_3);
        EList<JvmMember> _members_1 = it.getMembers();
        final Procedure1<JvmOperation> _function_4 = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setAbstract(true);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmFormalParameter _parameter = ModelTypeInferrer.this._jvmTypesBuilder.toParameter(mt, "uri", builder.typeRef(String.class));
            ModelTypeInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            EList<JvmTypeReference> _exceptions = it.getExceptions();
            JvmTypeReference _typeRef = builder.typeRef(IOException.class);
            ModelTypeInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, _typeRef);
          }
        };
        JvmOperation _method_1 = ModelTypeInferrer.this._jvmTypesBuilder.toMethod(mt, "save", builder.typeRef(Void.TYPE), _function_4);
        ModelTypeInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _method_1);
      }
    };
    acceptor.<JvmGenericType>accept(
      this._jvmTypesBuilder.toInterface(mt, this._iQualifiedNameProvider.getFullyQualifiedName(mt).toString(), _function));
    task.stop();
  }
}
