/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.jvmmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.inria.diverse.melange.ast.ASTHelper;
import fr.inria.diverse.melange.ast.NamingHelper;
import fr.inria.diverse.melange.jvmmodel.LanguageAdapterInferrer;
import fr.inria.diverse.melange.lib.IMetamodel;
import fr.inria.diverse.melange.metamodel.melange.ExternalLanguage;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.Mapping;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import fr.inria.diverse.melange.metamodel.melange.ModelTypingSpace;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.util.internal.Stopwatches;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Generates the Java runtime support for each {@link Language}.
 */
@SuppressWarnings("all")
public class LanguageInferrer {
  @Inject
  @Extension
  private ASTHelper _aSTHelper;
  
  @Inject
  @Extension
  private JvmTypesBuilder _jvmTypesBuilder;
  
  @Inject
  @Extension
  private NamingHelper _namingHelper;
  
  @Inject
  @Extension
  private LanguageAdapterInferrer _languageAdapterInferrer;
  
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Inject
  @Extension
  private IQualifiedNameConverter _iQualifiedNameConverter;
  
  /**
   * Generates a Java class whose name is the fully qualified name of the
   * {@link Language} {@code l} that encapsulates a {@link Resource} and
   * provides basic load/save capabilities around this {@link Resource}.
   * 
   * @see IMetamodel
   */
  public void generateAdapters(final Language l, final ModelTypingSpace root, final IJvmDeclaredTypeAcceptor acceptor, @Extension final JvmTypeReferenceBuilder builder) {
    final Stopwatches.StoppedTask task = Stopwatches.forTask("generate metamodels");
    task.start();
    final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
      @Override
      public void apply(final JvmGenericType it) {
        EList<JvmTypeReference> _superTypes = it.getSuperTypes();
        JvmTypeReference _typeRef = builder.typeRef(IMetamodel.class);
        LanguageInferrer.this._jvmTypesBuilder.<JvmTypeReference>operator_add(_superTypes, _typeRef);
        EList<JvmMember> _members = it.getMembers();
        JvmField _field = LanguageInferrer.this._jvmTypesBuilder.toField(l, "resource", builder.typeRef(Resource.class));
        LanguageInferrer.this._jvmTypesBuilder.<JvmField>operator_add(_members, _field);
        EList<JvmMember> _members_1 = it.getMembers();
        JvmOperation _getter = LanguageInferrer.this._jvmTypesBuilder.toGetter(l, "resource", builder.typeRef(Resource.class));
        LanguageInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_1, _getter);
        EList<JvmMember> _members_2 = it.getMembers();
        JvmOperation _setter = LanguageInferrer.this._jvmTypesBuilder.toSetter(l, "resource", builder.typeRef(Resource.class));
        LanguageInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_2, _setter);
        EList<JvmMember> _members_3 = it.getMembers();
        final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
          @Override
          public void apply(final JvmOperation it) {
            it.setStatic(true);
            EList<JvmFormalParameter> _parameters = it.getParameters();
            JvmFormalParameter _parameter = LanguageInferrer.this._jvmTypesBuilder.toParameter(l, "uri", builder.typeRef(String.class));
            LanguageInferrer.this._jvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
            StringConcatenationClient _client = new StringConcatenationClient() {
              @Override
              protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(ResourceSet.class);
                _builder.append(" rs = new ");
                _builder.append(ResourceSetImpl.class);
                _builder.append("();");
                _builder.newLineIfNotEmpty();
                _builder.append(Resource.class);
                _builder.append(" res = rs.getResource(");
                _builder.append(URI.class);
                _builder.append(".createURI(uri), true);");
                _builder.newLineIfNotEmpty();
                String _name = l.getName();
                _builder.append(_name);
                _builder.append(" mm = new ");
                String _name_1 = l.getName();
                _builder.append(_name_1);
                _builder.append("();");
                _builder.newLineIfNotEmpty();
                _builder.append("mm.setResource(res);");
                _builder.newLine();
                _builder.append("return mm ;");
                _builder.newLine();
              }
            };
            LanguageInferrer.this._jvmTypesBuilder.setBody(it, _client);
          }
        };
        JvmOperation _method = LanguageInferrer.this._jvmTypesBuilder.toMethod(l, "load", builder.typeRef(LanguageInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(l).toString()), _function);
        LanguageInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members_3, _method);
        final Function1<ModelType, Boolean> _function_1 = new Function1<ModelType, Boolean>() {
          @Override
          public Boolean apply(final ModelType mt) {
            return Boolean.valueOf((!((l instanceof ExternalLanguage) && Objects.equal(l.getExactType(), mt))));
          }
        };
        final Consumer<ModelType> _function_2 = new Consumer<ModelType>() {
          @Override
          public void accept(final ModelType mt) {
            final String mtFqn = LanguageInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(mt).toString();
            final String adapName = LanguageInferrer.this._namingHelper.adapterNameFor(l.getSyntax(), mt);
            EList<JvmMember> _members = it.getMembers();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("to");
            String _lastSegment = LanguageInferrer.this._iQualifiedNameConverter.toQualifiedName(mt.getName()).getLastSegment();
            _builder.append(_lastSegment);
            final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
              @Override
              public void apply(final JvmOperation it) {
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(adapName);
                    _builder.append(" adaptee = new ");
                    _builder.append(adapName);
                    _builder.append("() ;");
                    _builder.newLineIfNotEmpty();
                    _builder.append("adaptee.setAdaptee(resource);");
                    _builder.newLine();
                    _builder.append("return adaptee;");
                    _builder.newLine();
                  }
                };
                LanguageInferrer.this._jvmTypesBuilder.setBody(it, _client);
              }
            };
            JvmOperation _method = LanguageInferrer.this._jvmTypesBuilder.toMethod(l, _builder.toString(), builder.typeRef(mtFqn), _function);
            LanguageInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
          }
        };
        IterableExtensions.<ModelType>filter(l.getImplements(), _function_1).forEach(_function_2);
        final Function1<Mapping, Boolean> _function_3 = new Function1<Mapping, Boolean>() {
          @Override
          public Boolean apply(final Mapping it) {
            Language _from = it.getFrom();
            String _name = l.getName();
            return Boolean.valueOf(Objects.equal(_from, _name));
          }
        };
        final Consumer<Mapping> _function_4 = new Consumer<Mapping>() {
          @Override
          public void accept(final Mapping bind) {
            final Function1<Language, Boolean> _function = new Function1<Language, Boolean>() {
              @Override
              public Boolean apply(final Language it) {
                ModelType _to = bind.getTo();
                String _name = it.getName();
                return Boolean.valueOf(Objects.equal(_to, _name));
              }
            };
            final ModelType mt = IterableExtensions.<Language>findFirst(LanguageInferrer.this._aSTHelper.getLanguages(root), _function).getExactType();
            final String mtFqn = LanguageInferrer.this._iQualifiedNameProvider.getFullyQualifiedName(mt).toString();
            final String adapName = LanguageInferrer.this._namingHelper.mapperNameFor(l.getSyntax(), mt);
            EList<JvmMember> _members = it.getMembers();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("to");
            String _name = mt.getName();
            _builder.append(_name);
            final Procedure1<JvmOperation> _function_1 = new Procedure1<JvmOperation>() {
              @Override
              public void apply(final JvmOperation it) {
                StringConcatenationClient _client = new StringConcatenationClient() {
                  @Override
                  protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(adapName);
                    _builder.append(" adapter = new ");
                    _builder.append(adapName);
                    _builder.append("();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("adapter.setAdaptee(resource);");
                    _builder.newLine();
                    _builder.append("return adapter;");
                    _builder.newLine();
                  }
                };
                LanguageInferrer.this._jvmTypesBuilder.setBody(it, _client);
              }
            };
            JvmOperation _method = LanguageInferrer.this._jvmTypesBuilder.toMethod(l, _builder.toString(), builder.typeRef(mtFqn), _function_1);
            LanguageInferrer.this._jvmTypesBuilder.<JvmOperation>operator_add(_members, _method);
          }
        };
        IterableExtensions.<Mapping>filter(LanguageInferrer.this._aSTHelper.getMappings(root), _function_3).forEach(_function_4);
      }
    };
    acceptor.<JvmGenericType>accept(this._jvmTypesBuilder.toClass(l, this._iQualifiedNameProvider.getFullyQualifiedName(l).toString()), _function);
    final Consumer<ModelType> _function_1 = new Consumer<ModelType>() {
      @Override
      public void accept(final ModelType mt) {
        boolean _not = (!((l instanceof ExternalLanguage) && Objects.equal(l.getExactType(), mt)));
        if (_not) {
          LanguageInferrer.this._languageAdapterInferrer.generateAdapter(l, mt, acceptor, builder);
        }
      }
    };
    l.getImplements().forEach(_function_1);
    task.stop();
  }
}
