/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.operations;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.operations.IFailedStatusEvaluator;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.operations.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.operations.ResolutionResult;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.operations.IProfileChangeJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;

public class PlannerResolutionJob
extends ProvisioningJob
implements IProfileChangeJob {
    ProfileChangeRequest request;
    String profileId;
    IProvisioningPlan plan;
    MultiStatus additionalStatus;
    ResolutionResult report;
    ProvisioningContext firstPass;
    ProvisioningContext successful;
    IFailedStatusEvaluator evaluator;

    public static MultiStatus getProfileChangeRequestAlteredStatus() {
        return PlanAnalyzer.getProfileChangeAlteredStatus();
    }

    public PlannerResolutionJob(String label, ProvisioningSession session, String profileId, ProfileChangeRequest request, ProvisioningContext context, IFailedStatusEvaluator evaluator, MultiStatus additionalStatus) {
        super(label, session);
        this.request = request;
        this.profileId = profileId;
        this.firstPass = context == null ? new ProvisioningContext(session.getProvisioningAgent()) : context;
        this.evaluator = evaluator;
        Assert.isNotNull((Object)additionalStatus);
        this.additionalStatus = additionalStatus;
    }

    public IProvisioningPlan getProvisioningPlan() {
        return this.plan;
    }

    public ProfileChangeRequest getProfileChangeRequest() {
        return this.request;
    }

    public ProvisioningContext getActualProvisioningContext() {
        return this.successful;
    }

    public void setFirstPassProvisioningContext(ProvisioningContext firstPass) {
        this.firstPass = firstPass;
    }

    @Override
    public IStatus runModal(IProgressMonitor monitor) {
        IStatus status;
        SubMonitor sub = this.evaluator != null ? SubMonitor.convert((IProgressMonitor)monitor, (int)1000) : SubMonitor.convert((IProgressMonitor)monitor, (int)500);
        this.plan = ((IPlanner)this.getSession().getProvisioningAgent().getService(IPlanner.class)).getProvisioningPlan((IProfileChangeRequest)this.request, this.firstPass, (IProgressMonitor)sub.newChild(500));
        if (this.plan == null) {
            status = new Status(4, "org.eclipse.equinox.p2.operations", Messages.PlannerResolutionJob_NullProvisioningPlan);
            this.additionalStatus.add(status);
        } else {
            status = this.plan.getStatus();
        }
        if (status.getSeverity() != 4 || this.evaluator == null) {
            this.successful = this.firstPass;
            return status;
        }
        ProvisioningContext secondPass = this.evaluator.getSecondPassProvisioningContext(this.plan);
        if (secondPass == null) {
            return status;
        }
        this.successful = secondPass;
        this.plan = ((IPlanner)this.getSession().getProvisioningAgent().getService(IPlanner.class)).getProvisioningPlan((IProfileChangeRequest)this.request, secondPass, (IProgressMonitor)sub.newChild(500));
        if (this.plan == null) {
            status = new Status(4, "org.eclipse.equinox.p2.operations", Messages.PlannerResolutionJob_NullProvisioningPlan);
            this.additionalStatus.add(status);
            return status;
        }
        return this.plan.getStatus();
    }

    public ResolutionResult getResolutionResult() {
        if (this.report == null) {
            if (this.plan == null) {
                if (this.additionalStatus.getSeverity() != 4) {
                    this.additionalStatus.add((IStatus)new Status(4, "org.eclipse.equinox.p2.operations", Messages.PlannerResolutionJob_NullProvisioningPlan));
                }
                this.report = new ResolutionResult();
                this.report.addSummaryStatus((IStatus)this.additionalStatus);
            } else {
                this.report = PlanAnalyzer.computeResolutionResult(this.request, this.plan, this.additionalStatus);
            }
        }
        return this.report;
    }

    @Override
    public String getProfileId() {
        return this.profileId;
    }
}

