/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.env.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.IBehaviors;
import org.eclipse.emf.ecoretools.ale.core.env.impl.ImmutableBehaviors;
import org.eclipse.emf.ecoretools.ale.core.interpreter.IAleInterpreter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.impl.AleInterpreter;
import org.eclipse.emf.ecoretools.ale.core.interpreter.internal.ExtensionEnvironment;
import org.eclipse.emf.ecoretools.ale.core.parser.BehaviorsParser;
import org.eclipse.emf.ecoretools.ale.core.parser.ParsedFile;
import org.eclipse.emf.ecoretools.ale.implementation.ImplementationPackage;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public abstract class AbstractAleEnvironment
implements IAleEnvironment {
    protected IQueryEnvironment context;
    protected IBehaviors behaviors;
    protected IAleInterpreter interpreter;

    @Override
    public List<EPackage> getMetamodels() {
        ResourceSetImpl resources = new ResourceSetImpl();
        resources.getResourceFactoryRegistry().getExtensionToFactoryMap().put("ecore", new XMIResourceFactoryImpl());
        return this.getMetamodelsSources().stream().map(URI::createURI).map(arg_0 -> AbstractAleEnvironment.lambda$1((ResourceSet)resources, arg_0)).flatMap(res -> res.getContents().stream()).filter(EPackage.class::isInstance).map(EPackage.class::cast).collect(Collectors.toList());
    }

    @Override
    public IQueryEnvironment getContext() {
        if (this.context == null) {
            this.context = new ExtensionEnvironment();
            this.context.registerEPackage((EPackage)EcorePackage.eINSTANCE);
            this.context.registerEPackage((EPackage)ImplementationPackage.eINSTANCE);
            this.context.registerEPackage((EPackage)AstPackage.eINSTANCE);
            this.context.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        }
        return this.context;
    }

    @Override
    public IAleInterpreter getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = new AleInterpreter(this, this.getContext());
        }
        return this.interpreter;
    }

    @Override
    public IBehaviors getBehaviors() {
        if (this.behaviors == null) {
            BehaviorsParser parser = new BehaviorsParser(this.getContext());
            List<ParsedFile<ModelUnit>> ast = parser.parse(this.getMetamodels(), this.getBehaviorsSources());
            this.behaviors = new ImmutableBehaviors(ast);
        }
        return this.behaviors;
    }

    @Override
    public List<EObject> loadModel(URI modelURI) {
        return this.loadResource(modelURI).getContents();
    }

    @Override
    public Resource loadResource(URI modelURI) {
        this.ensureBehaviorsHaveBeenLoaded();
        ResourceSetImpl resources = new ResourceSetImpl();
        resources.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        this.getMetamodels().forEach(arg_0 -> AbstractAleEnvironment.lambda$5((ResourceSet)resources, arg_0));
        this.getContext().getEPackageProvider().getRegisteredEPackages().stream().forEach(arg_0 -> AbstractAleEnvironment.lambda$6((ResourceSet)resources, arg_0));
        return resources.getResource(modelURI, true);
    }

    @Override
    public void close() {
        if (this.context != null) {
            Set registeredPackages = this.context.getEPackageProvider().getRegisteredEPackages();
            for (EPackage registeredPackage : registeredPackages) {
                this.context.removeEPackage(registeredPackage);
            }
            this.getInterpreter().close();
            this.context = null;
            this.behaviors = null;
            this.interpreter = null;
        }
    }

    private void ensureBehaviorsHaveBeenLoaded() {
        this.getBehaviors();
    }

    private static /* synthetic */ Resource lambda$1(ResourceSet resourceSet, URI metamodelURI) {
        return resourceSet.getResource(metamodelURI, true);
    }

    private static /* synthetic */ void lambda$5(ResourceSet resourceSet, EPackage pkg) {
        Object object = resourceSet.getPackageRegistry().put((Object)pkg.getNsURI(), (Object)pkg);
    }

    private static /* synthetic */ void lambda$6(ResourceSet resourceSet, EPackage pkg) {
        Object object = resourceSet.getPackageRegistry().put((Object)pkg.getNsURI(), (Object)pkg);
    }
}

