/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecoretools.ale.core.interpreter.IServiceCallListener;
import org.eclipse.emf.ecoretools.ale.core.interpreter.ServiceNotFoundException;

public class NotifyingEvaluationServices
extends EvaluationServices {
    private static final String INTERNAL_ERROR_MSG = "An internal error occured during evaluation of a query";
    private List<IServiceCallListener> listeners;

    public NotifyingEvaluationServices(IReadOnlyQueryEnvironment queryEnv) {
        super(queryEnv);
        this.listeners = new ArrayList<IServiceCallListener>();
    }

    public NotifyingEvaluationServices(IReadOnlyQueryEnvironment queryEnv, List<IServiceCallListener> listeners) {
        super(queryEnv);
        this.listeners = listeners;
    }

    public Object call(String serviceName, Object[] arguments, Diagnostic diagnostic) {
        if (arguments.length == 0) {
            throw new AcceleoQueryEvaluationException("An internal error occured during evaluation of a query : at least one argument must be specified for service " + serviceName + ".");
        }
        try {
            IType[] argumentTypes = this.getArgumentTypes(arguments);
            Optional<Nothing> unresolvedArgument = Arrays.stream(arguments).filter(Nothing.class::isInstance).map(Nothing.class::cast).findFirst();
            if (unresolvedArgument.isPresent()) {
                return unresolvedArgument.get();
            }
            IService service = this.queryEnvironment.getLookupEngine().lookup(serviceName, argumentTypes);
            if (service == null) {
                throw new ServiceNotFoundException(serviceName, this.serviceSignature(serviceName, argumentTypes), Arrays.asList(argumentTypes), Arrays.asList(arguments));
            }
            this.listeners.forEach(l -> l.preCall(service, arguments));
            Object result = this.callService(service, arguments, diagnostic);
            this.listeners.forEach(l -> l.postCall(service, arguments, result));
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, (Throwable)e);
        }
    }

    private Object callService(IService service, Object[] arguments, Diagnostic diagnostic) {
        try {
            Object result = service.invoke(arguments);
            if (result instanceof Nothing) {
                this.addDiagnosticFor(diagnostic, 2, (Nothing)result);
            }
            return result;
        }
        catch (AcceleoQueryEvaluationException e) {
            Nothing placeHolder = new Nothing(e.getMessage(), (Throwable)e);
            if (e.getCause() instanceof AcceleoQueryEvaluationException) {
                this.addDiagnosticFor(diagnostic, 2, placeHolder);
            } else {
                this.addDiagnosticFor(diagnostic, 4, placeHolder);
            }
            return placeHolder;
        }
    }

    private void addDiagnosticFor(Diagnostic chain, int severity, Nothing nothing) {
        if (chain instanceof DiagnosticChain) {
            BasicDiagnostic child = new BasicDiagnostic(severity, "org.eclipse.acceleo.query", 0, nothing.getMessage(), new Object[]{nothing.getCause()});
            ((DiagnosticChain)chain).add((Diagnostic)child);
        }
    }

    private IType[] getArgumentTypes(Object[] arguments) {
        IType[] argumentTypes = new IType[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            argumentTypes[i] = arguments[i] == null ? new ClassType(this.queryEnvironment, null) : (arguments[i] instanceof EObject ? new EClassifierType(this.queryEnvironment, (EClassifier)((EObject)arguments[i]).eClass()) : new ClassType(this.queryEnvironment, arguments[i].getClass()));
            ++i;
        }
        return argumentTypes;
    }

    private Nothing nothing(String message, Object ... msgArgs) {
        String formatedMessage = String.format(message, msgArgs);
        return new Nothing(formatedMessage);
    }
}

