/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.figures;

import java.util.ListIterator;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GraphicsSource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemsAwareFreeFormLayer;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemsUtil;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.IExpandableFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;

public class BorderItemContainerFigure
extends NodeFigure {
    private Rectangle extendedBounds = new Rectangle();
    private BorderItemContainerHelper helper = new BorderItemContainerHelper();
    private BorderedItemContainerUpdateManagerWrapper updateManagerWrapper = new BorderedItemContainerUpdateManagerWrapper();

    protected void paintClientArea(Graphics graphics) {
        if (this.getChildren().isEmpty() || !this.isVisible()) {
            return;
        }
        Rectangle clip = this.getVisibleExtendedBounds();
        graphics.setClip(clip);
        if (this.useLocalCoordinates()) {
            graphics.translate(this.getBounds().x + this.getInsets().left, this.getBounds().y + this.getInsets().top);
        }
        graphics.pushState();
        this.paintChildren(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    public Rectangle getHandleBounds() {
        Rectangle handleRect = null;
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            Object object = listIterator.next();
            if (!(object instanceof NodeFigure) || !((NodeFigure)object).isVisible()) continue;
            if (handleRect == null) {
                handleRect = ((NodeFigure)object).getHandleBounds().getCopy();
                continue;
            }
            handleRect.union(((NodeFigure)object).getHandleBounds().getCopy());
        }
        return handleRect;
    }

    protected void primTranslate(int dx, int dy) {
        this.helper.ignoreChildFigureMovesHandling = true;
        super.primTranslate(dx, dy);
        this.helper.ignoreChildFigureMovesHandling = false;
    }

    public boolean containsPoint(int x, int y) {
        if (this.useLocalCoordinates()) {
            x = x - this.getBounds().x - this.getInsets().left;
            y = y - this.getBounds().y - this.getInsets().top;
        }
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.containsPoint(x, y)) continue;
            return true;
        }
        return false;
    }

    protected IFigure findDescendantAtExcluding(int x, int y, TreeSearch search) {
        Point pt = new Point(x, y);
        this.translateFromParent((Translatable)pt);
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || (fig = fig.findFigureAt(pt.x, pt.y, search)) == null) continue;
            return fig;
        }
        return null;
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        if (search.prune((IFigure)this)) {
            return null;
        }
        IFigure child = this.findDescendantAtExcluding(x, y, search);
        if (child != null) {
            return child;
        }
        return null;
    }

    public IFigure findMouseEventTargetAt(int x, int y) {
        IFigure f = this.findMouseEventTargetInDescendantsAt(x, y);
        if (f != null) {
            return f;
        }
        if (this.isMouseEventTarget()) {
            return this;
        }
        return null;
    }

    protected IFigure findMouseEventTargetInDescendantsAt(int x, int y) {
        Point pt = new Point(x, y);
        this.translateFromParent((Translatable)pt);
        int i = this.getChildren().size();
        while (i > 0) {
            IFigure fig = (IFigure)this.getChildren().get(--i);
            if (!fig.isVisible() || !fig.isEnabled() || !fig.containsPoint(pt.x, pt.y)) continue;
            fig = fig.findMouseEventTargetAt(pt.x, pt.y);
            return fig;
        }
        return null;
    }

    public boolean intersects(Rectangle rect) {
        Rectangle rectangle = this.getExtendedBounds();
        return rectangle.intersects(rect);
    }

    private Rectangle getVisibleExtendedBounds() {
        Rectangle extendedRect = this.getExtendedBounds().getCopy();
        this.translateToAbsolute((Translatable)extendedRect);
        Rectangle parentRect = this.getViewportBounds().getIntersection(extendedRect);
        this.translateToRelative((Translatable)parentRect);
        return parentRect;
    }

    private Rectangle getViewportBounds() {
        Rectangle rect = this.getParent().getParent().getClientArea().getCopy();
        this.getParent().getParent().translateToParent((Translatable)rect);
        this.getParent().getParent().translateToAbsolute((Translatable)rect);
        IFigure port = this.getViewport();
        if (port != null) {
            Rectangle portRect = port.getClientArea().getCopy();
            port.translateToParent((Translatable)portRect);
            port.translateToAbsolute((Translatable)portRect);
            if (portRect.height != 0 && portRect.width != 0) {
                rect = portRect;
            }
        }
        return rect;
    }

    public IFigure getMainFigure() {
        return ((BorderedNodeFigure)this.getParent()).getMainFigure();
    }

    private IFigure getViewport() {
        IFigure fig = this.getMainFigure();
        while (fig != null) {
            if (fig instanceof Viewport || fig instanceof ScalableFreeformLayeredPane) {
                return fig;
            }
            if (!((fig = fig.getParent()) instanceof BorderItemContainerFigure)) continue;
            fig = ((BorderItemContainerFigure)fig).getMainFigure();
        }
        return null;
    }

    public void erase() {
        if (this.getParent() != null && this.isVisible()) {
            this.repaint();
        }
    }

    public void repaint() {
        this.repaint(this.getExtendedBounds());
    }

    public void invalidate() {
        this.extendedBounds = null;
        super.invalidate();
        this.updateLayerExtents();
    }

    public void validate() {
        this.extendedBounds = null;
        super.validate();
    }

    public UpdateManager getUpdateManager() {
        if (this.getParent() != null) {
            return this.updateManagerWrapper;
        }
        return super.getUpdateManager();
    }

    public Rectangle getExtendedBounds() {
        if (this.extendedBounds == null) {
            this.extendedBounds = this.getParent().getBounds().getCopy();
            for (IFigure childFigure : this.getChildren()) {
                Rectangle childBounds;
                Rectangle rectangle = childBounds = childFigure instanceof IExpandableFigure ? ((IExpandableFigure)childFigure).getExtendedBounds() : childFigure.getBounds();
                if (this.useLocalCoordinates()) {
                    childBounds = childBounds.getCopy();
                    childBounds.translate(this.getLocation());
                }
                this.extendedBounds.union(childBounds);
            }
        }
        return this.extendedBounds;
    }

    protected void fireFigureMoved() {
        super.fireFigureMoved();
        this.extendedBounds = null;
        this.updateLayerExtents();
    }

    private void updateLayerExtents() {
        BorderItemsAwareFreeFormLayer layer = BorderItemsUtil.getBorderItemLayer((IFigure)this);
        if (layer != null) {
            layer.borderFigureMoved();
        }
    }

    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
        this.helper.hookChild(figure);
    }

    public void remove(IFigure figure) {
        this.helper.unhookChild(figure);
        super.remove(figure);
    }

    private class BorderItemContainerHelper {
        boolean ignoreChildFigureMovesHandling;
        private FigureListener figureListener = new ChildTracker();

        private BorderItemContainerHelper() {
        }

        public void hookChild(IFigure child) {
            BorderItemContainerFigure.this.revalidate();
            child.addFigureListener(this.figureListener);
        }

        public void unhookChild(IFigure child) {
            BorderItemContainerFigure.this.revalidate();
            child.removeFigureListener(this.figureListener);
        }

        class ChildTracker
        implements FigureListener {
            ChildTracker() {
            }

            public void figureMoved(IFigure source) {
                if (!BorderItemContainerHelper.this.ignoreChildFigureMovesHandling) {
                    BorderItemContainerFigure.this.revalidate();
                }
            }
        }
    }

    private class BorderedItemContainerUpdateManagerWrapper
    extends UpdateManager {
        public void setGraphicsSource(GraphicsSource gs) {
            BorderItemContainerFigure.this.getParent().getUpdateManager().setGraphicsSource(gs);
        }

        public synchronized void addDirtyRegion(IFigure figure, int x, int y, int w, int h) {
            Rectangle r = new Rectangle(x, y, w, h);
            IFigure borderedNodeParent = BorderItemContainerFigure.this.getParent().getParent();
            IFigure walker = figure;
            do {
                walker = walker.getParent();
                walker.translateToParent((Translatable)r);
            } while (walker != borderedNodeParent && walker.getParent() != null);
            walker.getUpdateManager().addDirtyRegion(walker, r.x, r.y, r.width, r.height);
        }

        public synchronized void addInvalidFigure(IFigure f) {
            BorderItemContainerFigure.this.getParent().getUpdateManager().addInvalidFigure(f);
        }

        public synchronized void performUpdate() {
            BorderItemContainerFigure.this.getParent().getUpdateManager().performUpdate();
        }

        public synchronized void performUpdate(Rectangle exposed) {
            BorderItemContainerFigure.this.getParent().getUpdateManager().performUpdate(exposed);
        }

        public void performValidation() {
            BorderItemContainerFigure.this.getParent().getUpdateManager().performValidation();
        }

        public synchronized void runWithUpdate(Runnable runnable) {
            BorderItemContainerFigure.this.getParent().getUpdateManager().runWithUpdate(runnable);
        }

        public void setRoot(IFigure figure) {
            BorderItemContainerFigure.this.getParent().getUpdateManager().setRoot(figure);
        }
    }
}

