/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public class DragEditPartsTracker
extends SelectEditPartTracker {
    static final int MODIFIER_CLONE = "macosx".equals(Platform.getOS()) ? 65536 : 262144;
    static final int MODIFIER_CONSTRAINED_MOVE = 131072;
    private static final int FLAG_SOURCE_FEEDBACK = 256;
    protected static final int MAX_FLAG = 256;
    private List exclusionSet;
    private PrecisionPoint sourceRelativeStartPoint;
    private SnapToHelper snapToHelper;
    private PrecisionRectangle sourceRectangle;
    private PrecisionRectangle compoundSrcRect;
    private boolean cloneActive = false;
    static /* synthetic */ Class class$0;

    public DragEditPartsTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
        this.setDisabledCursor(SharedCursors.NO);
    }

    private boolean acceptClone(KeyEvent e) {
        int key = e.keyCode;
        if (!this.isInState(52)) {
            return false;
        }
        return key == MODIFIER_CLONE;
    }

    private boolean acceptSHIFT(KeyEvent e) {
        return this.isInState(52) && e.keyCode == 131072;
    }

    protected Cursor getDefaultCursor() {
        if (this.isCloneActive()) {
            return SharedCursors.CURSOR_TREE_ADD;
        }
        return super.getDefaultCursor();
    }

    protected PrecisionRectangle getSourceBounds() {
        return this.sourceRectangle;
    }

    protected PrecisionRectangle getOperationSetBounds() {
        return this.compoundSrcRect;
    }

    protected SnapToHelper getSnapToHelper() {
        return this.snapToHelper;
    }

    public void commitDrag() {
        this.eraseSourceFeedback();
        this.eraseTargetFeedback();
        this.performDrag();
        this.setState(0x40000000);
    }

    private void captureSourceDimensions() {
        List editparts = this.getOperationSet();
        int i = 0;
        while (i < editparts.size()) {
            GraphicalEditPart child = (GraphicalEditPart)editparts.get(i);
            IFigure figure = child.getFigure();
            PrecisionRectangle bounds = null;
            bounds = figure instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)bounds);
            this.compoundSrcRect = this.compoundSrcRect == null ? new PrecisionRectangle((Rectangle)bounds) : this.compoundSrcRect.union(bounds);
            if (child == this.getSourceEditPart()) {
                this.sourceRectangle = bounds;
            }
            ++i;
        }
        if (this.sourceRectangle == null) {
            IFigure figure = ((GraphicalEditPart)this.getSourceEditPart()).getFigure();
            this.sourceRectangle = figure instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)this.sourceRectangle);
        }
    }

    protected List createOperationSet() {
        if (this.getCurrentViewer() != null) {
            List list = ToolUtilities.getSelectionWithoutDependants(this.getCurrentViewer());
            ToolUtilities.filterEditPartsUnderstanding(list, this.getTargetRequest());
            return list;
        }
        return new ArrayList();
    }

    protected Request createTargetRequest() {
        if (this.isCloneActive()) {
            return new ChangeBoundsRequest("clone");
        }
        return new ChangeBoundsRequest("move");
    }

    public void deactivate() {
        this.eraseSourceFeedback();
        super.deactivate();
        this.exclusionSet = null;
        this.sourceRelativeStartPoint = null;
        this.sourceRectangle = null;
        this.compoundSrcRect = null;
        this.snapToHelper = null;
    }

    protected void eraseSourceFeedback() {
        if (!this.getFlag(256)) {
            return;
        }
        this.setFlag(256, false);
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.eraseSourceFeedback(this.getTargetRequest());
            ++i;
        }
    }

    protected Command getCommand() {
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel("Drag Object Tracker");
        Iterator iter = this.getOperationSet().iterator();
        Request request = this.getTargetRequest();
        if (this.isCloneActive()) {
            request.setType("clone");
        } else if (this.isMove()) {
            request.setType("move");
        } else {
            request.setType("orphan");
        }
        if (!this.isCloneActive()) {
            while (iter.hasNext()) {
                EditPart editPart = (EditPart)iter.next();
                command.add(editPart.getCommand(request));
            }
        }
        if (!this.isMove() || this.isCloneActive()) {
            if (!this.isCloneActive()) {
                request.setType("add children");
            }
            if (this.getTargetEditPart() == null) {
                command.add(UnexecutableCommand.INSTANCE);
            } else {
                command.add(this.getTargetEditPart().getCommand(this.getTargetRequest()));
            }
        }
        return command.unwrap();
    }

    protected String getCommandName() {
        if (this.isCloneActive()) {
            return "clone";
        }
        if (this.isMove()) {
            return "move";
        }
        return "add children";
    }

    protected String getDebugName() {
        return "DragEditPartsTracker:" + this.getCommandName();
    }

    protected Collection getExclusionSet() {
        if (this.exclusionSet == null) {
            List set = this.getOperationSet();
            this.exclusionSet = new ArrayList(set.size() + 1);
            int i = 0;
            while (i < set.size()) {
                GraphicalEditPart editpart = (GraphicalEditPart)set.get(i);
                this.exclusionSet.add(editpart.getFigure());
                ++i;
            }
            LayerManager layerManager = (LayerManager)this.getCurrentViewer().getEditPartRegistry().get(LayerManager.ID);
            if (layerManager != null) {
                this.exclusionSet.add(layerManager.getLayer("Connection Layer"));
            }
        }
        return this.exclusionSet;
    }

    protected void handleAutoexpose() {
        this.updateTargetRequest();
        this.updateTargetUnderMouse();
        this.showTargetFeedback();
        this.showSourceFeedback();
        this.setCurrentCommand(this.getCommand());
    }

    protected boolean handleButtonUp(int button) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseSourceFeedback();
            this.eraseTargetFeedback();
            this.performDrag();
            return true;
        }
        return super.handleButtonUp(button);
    }

    protected boolean handleDragInProgress() {
        if (this.isInDragInProgress()) {
            this.updateTargetRequest();
            if (this.updateTargetUnderMouse()) {
                this.updateTargetRequest();
            }
            this.showTargetFeedback();
            this.showSourceFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected boolean handleHover() {
        if (this.isInDragInProgress()) {
            this.updateAutoexposeHelper();
        }
        return true;
    }

    protected boolean handleInvalidInput() {
        super.handleInvalidInput();
        this.eraseSourceFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        this.setAutoexposeHelper(null);
        if (this.acceptArrowKey(e)) {
            this.accStepIncrement();
            if (this.stateTransition(1, 32)) {
                this.setStartLocation(this.getLocation());
            }
            switch (e.keyCode) {
                case 0x1000002: {
                    this.placeMouseInViewer(this.getLocation().getTranslated(0, this.accGetStep()));
                    break;
                }
                case 0x1000001: {
                    this.placeMouseInViewer(this.getLocation().getTranslated(0, -this.accGetStep()));
                    break;
                }
                case 0x1000004: {
                    int stepping = this.accGetStep();
                    if (this.isCurrentViewerMirrored()) {
                        stepping = -stepping;
                    }
                    this.placeMouseInViewer(this.getLocation().getTranslated(stepping, 0));
                    break;
                }
                case 0x1000003: {
                    int step = -this.accGetStep();
                    if (this.isCurrentViewerMirrored()) {
                        step = -step;
                    }
                    this.placeMouseInViewer(this.getLocation().getTranslated(step, 0));
                }
            }
            return true;
        }
        if (this.acceptClone(e)) {
            this.setCloneActive(true);
            this.handleDragInProgress();
            return true;
        }
        if (this.acceptSHIFT(e)) {
            this.handleDragInProgress();
            return true;
        }
        return false;
    }

    protected boolean handleKeyUp(KeyEvent e) {
        if (this.acceptArrowKey(e)) {
            this.accStepReset();
            return true;
        }
        if (this.acceptClone(e)) {
            this.setCloneActive(false);
            this.handleDragInProgress();
            return true;
        }
        if (this.acceptSHIFT(e)) {
            this.handleDragInProgress();
            return true;
        }
        return false;
    }

    protected boolean isCloneActive() {
        return this.cloneActive;
    }

    protected boolean isMove() {
        EditPart part = this.getSourceEditPart();
        while (part != this.getTargetEditPart() && part != null) {
            if (part.getParent() == this.getTargetEditPart() && part.getSelected() != 0) {
                return true;
            }
            part = part.getParent();
        }
        return false;
    }

    protected void performDrag() {
        this.executeCurrentCommand();
    }

    protected void repairStartLocation() {
        if (this.sourceRelativeStartPoint == null) {
            return;
        }
        IFigure figure = ((GraphicalEditPart)this.getSourceEditPart()).getFigure();
        PrecisionPoint newStart = (PrecisionPoint)this.sourceRelativeStartPoint.getCopy();
        figure.translateToAbsolute((Translatable)newStart);
        Point delta = new Point(newStart.x - this.getStartLocation().x, newStart.y - this.getStartLocation().y);
        this.setStartLocation((Point)newStart);
        if (this.sourceRectangle != null) {
            this.sourceRectangle.translate(delta);
        }
        if (this.compoundSrcRect != null) {
            this.compoundSrcRect.translate(delta);
        }
    }

    protected void setAutoexposeHelper(AutoexposeHelper helper) {
        super.setAutoexposeHelper(helper);
        if (helper != null && this.sourceRelativeStartPoint == null && this.isInDragInProgress()) {
            IFigure figure = ((GraphicalEditPart)this.getSourceEditPart()).getFigure();
            this.sourceRelativeStartPoint = new PrecisionPoint(this.getStartLocation());
            figure.translateToRelative((Translatable)this.sourceRelativeStartPoint);
        }
    }

    protected void setCloneActive(boolean cloneActive) {
        if (this.cloneActive == cloneActive) {
            return;
        }
        this.eraseSourceFeedback();
        this.eraseTargetFeedback();
        this.cloneActive = cloneActive;
    }

    protected void setTargetEditPart(EditPart editpart) {
        if (this.getTargetEditPart() == editpart) {
            return;
        }
        super.setTargetEditPart(editpart);
        this.snapToHelper = null;
        if (this.getTargetEditPart() != null && this.getOperationSet().size() > 0) {
            EditPart editPart = this.getTargetEditPart();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.SnapToHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.snapToHelper = (SnapToHelper)editPart.getAdapter(clazz);
        }
    }

    protected void showSourceFeedback() {
        List editParts = this.getOperationSet();
        int i = 0;
        while (i < editParts.size()) {
            EditPart editPart = (EditPart)editParts.get(i);
            editPart.showSourceFeedback(this.getTargetRequest());
            ++i;
        }
        this.setFlag(256, true);
    }

    protected void setState(int state) {
        boolean check = this.isInState(1);
        super.setState(state);
        if (this.isInState(52) && this.getCurrentInput().isModKeyDown(MODIFIER_CLONE)) {
            this.setCloneActive(true);
            this.handleDragInProgress();
        }
        if (check && this.isInState(50)) {
            this.captureSourceDimensions();
        }
    }

    protected void updateTargetRequest() {
        this.repairStartLocation();
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        request.setEditParts(this.getOperationSet());
        Dimension delta = this.getDragMoveDelta();
        request.setConstrainedMove(this.getCurrentInput().isModKeyDown(131072));
        request.setSnapToEnabled(!this.getCurrentInput().isModKeyDown(MODIFIER_NO_SNAPPING));
        if (request.isConstrainedMove()) {
            float ratio = 0.0f;
            if (delta.width != 0) {
                ratio = (float)delta.height / (float)delta.width;
            }
            if ((double)(ratio = Math.abs(ratio)) > 0.5 && (double)ratio < 1.5) {
                if (Math.abs(delta.height) > Math.abs(delta.width)) {
                    delta.height = delta.height > 0 ? Math.abs(delta.width) : -Math.abs(delta.width);
                } else {
                    delta.width = delta.width > 0 ? Math.abs(delta.height) : -Math.abs(delta.height);
                }
            } else if (Math.abs(delta.width) > Math.abs(delta.height)) {
                delta.height = 0;
            } else {
                delta.width = 0;
            }
        }
        Point moveDelta = new Point(delta.width, delta.height);
        request.getExtendedData().clear();
        request.setMoveDelta(moveDelta);
        this.snapPoint(request);
        request.setLocation(this.getLocation());
        request.setType(this.getCommandName());
    }

    protected void snapPoint(ChangeBoundsRequest request) {
        Point moveDelta = request.getMoveDelta();
        if (this.snapToHelper != null && request.isSnapToEnabled()) {
            PrecisionRectangle baseRect = this.sourceRectangle.getPreciseCopy();
            PrecisionRectangle jointRect = this.compoundSrcRect.getPreciseCopy();
            baseRect.translate(moveDelta);
            jointRect.translate(moveDelta);
            PrecisionPoint preciseDelta = new PrecisionPoint(moveDelta);
            this.snapToHelper.snapPoint((Request)request, 192, new PrecisionRectangle[]{baseRect, jointRect}, preciseDelta);
            request.setMoveDelta((Point)preciseDelta);
        }
    }
}

