/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.core.interpreter.services;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecoretools.ale.core.interpreter.notapi.DynamicFeatureRegistry;
import org.eclipse.emf.ecoretools.ale.core.interpreter.services.DynamicEObjectFeatureAccess;

public class DynamicEObjectServices
extends EObjectServices {
    public static final String UNKNOWN_FEATURE = "Feature %s not found in EClass %s";
    public static final String NON_EOBJECT_FEATURE_ACCESS = "Attempt to access feature (%s) on a non ModelObject value (%s).";
    DynamicFeatureRegistry dynamicFeatures;

    public DynamicEObjectServices(IReadOnlyQueryEnvironment queryEnvironment, CrossReferenceProvider crossReferencer, IRootEObjectProvider rootProvider, DynamicFeatureRegistry dynamicFeatures) {
        super(queryEnvironment, crossReferencer, rootProvider);
        this.dynamicFeatures = dynamicFeatures;
    }

    public Object aqlFeatureAccess(EObject self, String featureName) {
        return this.dynamicFeatures.aqlFeatureAccess(self, featureName);
    }

    public List<EObject> eContents(EObject eObject) {
        ArrayList contents = Lists.newArrayList((Iterable)eObject.eContents());
        Optional<EObject> extension = this.dynamicFeatures.getRuntimeExtension(eObject);
        if (extension.isPresent()) {
            contents.addAll(extension.get().eContents());
        }
        return contents;
    }

    public EObject eContainer(EObject eObject) {
        return this.dynamicFeatures.getInstanceOrSelf(eObject.eContainer());
    }

    public EObject eContainer(EObject eObject, EClass type) {
        EObject current = this.eContainer(eObject);
        while (current != null && !type.isSuperTypeOf(current.eClass()) && !type.isInstance((Object)current)) {
            current = this.eContainer(current);
        }
        EObject result = current != null && (type.isSuperTypeOf(current.eClass()) || type.isInstance((Object)current)) ? current : null;
        return result;
    }

    public List<EObject> eAllContents(EObject eObject) {
        return Lists.newArrayList(this.dynamicEAllContents(eObject));
    }

    private TreeIterator<EObject> dynamicEAllContents(EObject eObject) {
        return new AbstractTreeIterator<EObject>((Object)eObject, false){
            private static final long serialVersionUID = 1L;

            public Iterator<EObject> getChildren(Object object) {
                return DynamicEObjectServices.this.eContents((EObject)object).iterator();
            }
        };
    }

    public List<EObject> eCrossReferences(EObject eObject) {
        ArrayList crossRef = Lists.newArrayList((Iterable)eObject.eCrossReferences());
        Optional<EObject> extension = this.dynamicFeatures.getRuntimeExtension(eObject);
        if (extension.isPresent()) {
            crossRef.addAll(extension.get().eCrossReferences());
        }
        return crossRef;
    }

    public Object eGet(EObject eObject, String featureName) {
        Optional<EObject> extension;
        Object result = super.eGet(eObject, featureName);
        if (result == null && (extension = this.dynamicFeatures.getRuntimeExtension(eObject)).isPresent()) {
            EStructuralFeature feature = extension.get().eClass().getEStructuralFeature(featureName);
            if (feature != null) {
                result = extension.get().eGet(feature);
            }
            if (result instanceof Set) {
                result = Sets.newLinkedHashSet((Iterable)((Set)result));
            } else if (result instanceof EMap) {
                result = new BasicEMap(((EMap)result).map());
            } else if (result instanceof Collection) {
                result = Lists.newArrayList((Iterable)((Collection)result));
            }
        }
        return result;
    }

    protected IService getService(Method publicMethod) {
        if ("aqlFeatureAccess".equals(publicMethod.getName())) {
            return new DynamicEObjectFeatureAccess(publicMethod, (Object)this, this.dynamicFeatures);
        }
        if ("eCrossReferences".equals(publicMethod.getName()) && publicMethod.getReturnType() == Object.class) {
            return null;
        }
        return super.getService(publicMethod);
    }
}

