/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gemoc.commons.eclipse.core.resources.FileFinderVisitor;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.AbstractNewProjectWizardWithTemplates;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.BaseProjectWizardFields;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.IProjectContentWizard;
import org.eclipse.gemoc.commons.eclipse.pde.wizards.pages.pde.ui.ProjectTemplateApplicationOperation;
import org.eclipse.gemoc.dsl.Dsl;
import org.eclipse.gemoc.dsl.DslFactory;
import org.eclipse.gemoc.dsl.DslPackage;
import org.eclipse.gemoc.dsl.Entry;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.Activator;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages.NewGemocSiriusProjectMainWizardPage;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages.NewGemocSiriusProjectWizardFields;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages.NewODesignFileWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditorPlugin;
import org.eclipse.sirius.ui.tools.api.project.ViewpointSpecificationProject;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewGemocSiriusProjectWizard
extends AbstractNewProjectWizardWithTemplates
implements INewWizard {
    protected NewGemocSiriusProjectWizardFields context = new NewGemocSiriusProjectWizardFields();
    private IWorkbench workbench;
    protected NewGemocSiriusProjectMainWizardPage projectPage;
    private NewODesignFileWizardPage newOdesignPage;

    public void addPages() {
        this.projectPage = new NewGemocSiriusProjectMainWizardPage(this.context);
        this.addPage((IWizardPage)this.projectPage);
        this.newOdesignPage = new NewODesignFileWizardPage("ODesign Model", this.context);
        this.newOdesignPage.setTitle(SiriusEditorPlugin.getPlugin().getString("_UI_SiriusModelWizard_label"));
        this.newOdesignPage.setDescription(SiriusEditorPlugin.getPlugin().getString("_UI_SiriusModelWizard_description"));
        this.addPage((IWizardPage)this.newOdesignPage);
        this.addPage((IWizardPage)this.getTemplateListSelectionPage(this.context));
        super.addPages();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setWindowTitle("New Viewpoint Specification Project for GEMOC");
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SiriusEditorPlugin.INSTANCE.getImage("full/wizban/banner_viewpoint_specification_project.gif")));
    }

    public boolean performFinish() {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription description = workspace.newProjectDescription(this.context.projectName);
            if (!this.context.projectLocation.equals(workspace.getRoot().getLocation().toOSString())) {
                description.setLocation((IPath)new Path(this.context.projectLocation));
            }
            final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.context.projectName);
            IWorkspaceRunnable operation = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    Path projectLocationPath = new Path(NewGemocSiriusProjectWizard.this.context.projectLocation);
                    ViewpointSpecificationProject.createNewViewpointSpecificationProject((IWorkbench)NewGemocSiriusProjectWizard.this.workbench, (String)NewGemocSiriusProjectWizard.this.context.projectName, (IPath)projectLocationPath, (String)NewGemocSiriusProjectWizard.this.newOdesignPage.getModelName().getText(), (String)NewGemocSiriusProjectWizard.this.newOdesignPage.getInitialObjectName(), (String)NewGemocSiriusProjectWizard.this.newOdesignPage.getEncoding(), (IRunnableContext)NewGemocSiriusProjectWizard.this.getContainer());
                    IProjectContentWizard contentWizard = NewGemocSiriusProjectWizard.this.templateSelectionPage.getSelectedWizard();
                    try {
                        NewGemocSiriusProjectWizard.this.getContainer().run(false, true, (IRunnableWithProgress)new ProjectTemplateApplicationOperation((BaseProjectWizardFields)NewGemocSiriusProjectWizard.this.context, project, contentWizard));
                    }
                    catch (InvocationTargetException e) {
                        Activator.logErrorMessage(e.getMessage(), e);
                    }
                    catch (InterruptedException e) {
                        Activator.logErrorMessage(e.getMessage(), e);
                    }
                    project.refreshLocal(2, monitor);
                    NewGemocSiriusProjectWizard.this.waitForAutoBuild();
                    NewGemocSiriusProjectWizard.this.updateDsl(project);
                    project.refreshLocal(2, monitor);
                }
            };
            ResourcesPlugin.getWorkspace().run(operation, null);
        }
        catch (Exception exception) {
            Activator.logErrorMessage(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    protected void updateDsl(IProject siriusProject) {
        FileFinderVisitor odesignProjectVisitor = new FileFinderVisitor("odesign");
        try {
            siriusProject.accept((IResourceVisitor)odesignProjectVisitor);
            IFile odesignIFile = odesignProjectVisitor.getFile();
            if (odesignIFile != null) {
                Resource res = new ResourceSetImpl().getResource(URI.createURI((String)this.context.dslFilePath), true);
                Dsl dsl = (Dsl)res.getContents().get(0);
                Optional<Entry> sirius = dsl.getEntries().stream().filter(entry -> entry.getKey().equals("sirius")).findFirst();
                if (sirius.isPresent()) {
                    sirius.get().setValue(odesignIFile.getFullPath().toOSString());
                } else {
                    Entry siriusEntry = ((DslFactory)DslPackage.eINSTANCE.getEFactoryInstance()).createEntry();
                    siriusEntry.setKey("sirius");
                    siriusEntry.setValue(odesignIFile.getFullPath().toOSString());
                    dsl.getEntries().add((Object)siriusEntry);
                }
                try {
                    res.save(Collections.emptyMap());
                }
                catch (IOException e) {
                    Activator.logErrorMessage(e.getMessage(), e);
                }
            }
        }
        catch (CoreException e) {
            Activator.logErrorMessage(e.getMessage(), e);
        }
    }

    protected void waitForAutoBuild() {
        boolean wasInterrupted = false;
        do {
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                wasInterrupted = false;
            }
            catch (OperationCanceledException e) {
                Activator.logWarnMessage(e.getMessage(), e);
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        } while (wasInterrupted);
    }

    public boolean isHelpAvailable() {
        return true;
    }

    public NewGemocSiriusProjectWizardFields getContext() {
        return this.context;
    }

    public NewGemocSiriusProjectMainWizardPage getPageProject() {
        return this.projectPage;
    }

    public String getTargetPluginId() {
        return "org.eclipse.gemoc.xdsmlframework.extensions.sirius";
    }
}

