/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger;

import com.google.common.base.Objects;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.gemoc.executionframework.debugger.IMutableFieldExtractor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.executionframework.engine.commons.DslHelper;
import org.eclipse.gemoc.executionframework.engine.commons.K3DslHelper;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.osgi.framework.Bundle;

public class IntrospectiveMutableFieldExtractor
implements IMutableFieldExtractor {
    private String languageName;
    private Map<EObject, List<MutableField>> eObjects = new HashMap<EObject, List<MutableField>>();
    private Map<EClass, List<Pair<Class<?>, Class<?>>>> aspectClasses = new HashMap();

    public IntrospectiveMutableFieldExtractor(String languageName) {
        this.languageName = languageName;
    }

    private String decapitalize(String string) {
        char[] c = string.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    private String findName(Class<?> cls, EObject eObject) {
        Iterable name;
        block5: {
            try {
                Functions.Function1 _function = f -> f.getName().equals("name");
                name = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)cls.getDeclaredFields())), (Functions.Function1)_function);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)name);
                if (!_isEmpty) break block5;
                if (!Objects.equal(cls.getSuperclass(), EObjectImpl.class) && cls.getSuperclass() != null) {
                    return this.findName(cls.getSuperclass(), eObject);
                }
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        Field f2 = ((Field[])Conversions.unwrapArray((Object)name, Field.class))[0];
        f2.setAccessible(true);
        Object o = f2.get(eObject);
        if (o != null) {
            return f2.get(eObject).toString();
        }
        return null;
    }

    private String findId(Class<?> cls, EObject eObject) {
        Iterable id;
        block5: {
            try {
                Functions.Function1 _function = f -> f.getName().equals("id");
                id = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)cls.getDeclaredFields())), (Functions.Function1)_function);
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)id);
                if (!_isEmpty) break block5;
                if (!Objects.equal(cls.getSuperclass(), EObjectImpl.class) && cls.getSuperclass() != null) {
                    return this.findId(cls.getSuperclass(), eObject);
                }
                return null;
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        }
        Field f2 = ((Field[])Conversions.unwrapArray((Object)id, Field.class))[0];
        f2.setAccessible(true);
        Object o = f2.get(eObject);
        if (o != null) {
            return f2.get(eObject).toString();
        }
        return null;
    }

    private String findDataName(EObject eObject) {
        String name = this.findName(eObject.getClass(), eObject);
        if (name == null) {
            String id = this.findId(eObject.getClass(), eObject);
            if (id == null) {
                return eObject.toString();
            }
            String _decapitalize = this.decapitalize(eObject.eClass().getName());
            String _plus = String.valueOf(_decapitalize) + " ";
            return String.valueOf(_plus) + id;
        }
        return name;
    }

    private List<MutableField> getMutableFieldsFromAspect(EObject eObject, Class<?> properties, Class<?> aspect) {
        boolean _not;
        ArrayList<MutableField> result = new ArrayList<MutableField>();
        Field[] fields = properties.getFields();
        boolean _isEmpty = ((List)Conversions.doWrapArray((Object)fields)).isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Consumer<Field> _function = f -> {
                Functions.Function1 _function_1 = m -> m.getName().equals(f.getName());
                Iterable methods = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)aspect.getMethods())), (Functions.Function1)_function_1);
                Functions.Function1 _function_2 = m -> {
                    int _parameterCount = m.getParameterCount();
                    return _parameterCount == 1;
                };
                Method getter = (Method)IterableExtensions.findFirst((Iterable)methods, (Functions.Function1)_function_2);
                Functions.Function1 _function_3 = m -> {
                    int _parameterCount = m.getParameterCount();
                    return _parameterCount == 2;
                };
                Method setter = (Method)IterableExtensions.findFirst((Iterable)methods, (Functions.Function1)_function_3);
                if (getter != null && setter != null) {
                    String _findDataName = this.findDataName(eObject);
                    Supplier<Object> _function_4 = () -> {
                        try {
                            return getter.invoke(null, eObject);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    };
                    Consumer<Object> _function_5 = t -> {
                        try {
                            setter.invoke(null, eObject, t);
                        }
                        catch (Throwable _e) {
                            throw Exceptions.sneakyThrow((Throwable)_e);
                        }
                    };
                    MutableField data = new MutableField(_findDataName, eObject, _function_4, _function_5);
                    result.add(data);
                }
            };
            ((List)Conversions.doWrapArray((Object)fields)).forEach(_function);
        }
        return result;
    }

    @Override
    public List<MutableField> extractMutableField(EObject eObject) {
        boolean _not;
        boolean _containsKey = this.eObjects.containsKey(eObject);
        boolean bl = _not = !_containsKey;
        if (_not) {
            boolean _not_1;
            ArrayList<MutableField> datas = new ArrayList<MutableField>();
            boolean _containsKey_1 = this.aspectClasses.containsKey(eObject.eClass());
            boolean bl2 = _not_1 = !_containsKey_1;
            if (_not_1) {
                Map<Class<?>, List<Class<?>>> classes = this.getStaticHelperClasses(eObject);
                if (classes != null) {
                    ArrayList list = new ArrayList();
                    BiConsumer<Class, List> _function = (i, l) -> {
                        Consumer<Class> _function_1 = c -> {
                            block2: {
                                try {
                                    Bundle _dslBundle = DslHelper.getDslBundle((String)this.languageName);
                                    String _name = c.getName();
                                    String _simpleName = i.getSimpleName();
                                    String _plus = String.valueOf(_name) + _simpleName;
                                    String _plus_1 = String.valueOf(_plus) + "AspectProperties";
                                    Class properties = _dslBundle.loadClass(_plus_1);
                                    Pair pair = new Pair(c, (Object)properties);
                                    list.add(pair);
                                    datas.addAll(this.getMutableFieldsFromAspect(eObject, properties, (Class<?>)c));
                                }
                                catch (Throwable _t) {
                                    if (_t instanceof ClassNotFoundException) break block2;
                                    throw Exceptions.sneakyThrow((Throwable)_t);
                                }
                            }
                        };
                        l.forEach(_function_1);
                    };
                    classes.forEach(_function);
                    this.aspectClasses.put(eObject.eClass(), list);
                } else {
                    this.aspectClasses.put(eObject.eClass(), Collections.EMPTY_LIST);
                }
            } else {
                List<Pair<Class<?>, Class<?>>> list_1 = this.aspectClasses.get(eObject.eClass());
                Consumer<Pair> _function_1 = p -> datas.addAll(this.getMutableFieldsFromAspect(eObject, (Class)p.getValue(), (Class)p.getKey()));
                list_1.forEach(_function_1);
            }
            this.eObjects.put(eObject, datas);
            return datas;
        }
        return this.eObjects.get(eObject);
    }

    private void getSuperInterfacesOfInterface(Class<?> c, HashSet<Class<?>> set) {
        Functions.Function1 _function = i -> {
            boolean _equals = i.equals(EObject.class);
            return !_equals;
        };
        Iterable possibleSuperInterfaces = IterableExtensions.filter(Arrays.asList(c.getInterfaces()), (Functions.Function1)_function);
        Consumer<Class> _function_1 = i -> {
            boolean _add = set.add((Class<?>)i);
            if (_add) {
                this.getSuperInterfacesOfInterface((Class<?>)i, set);
            }
        };
        possibleSuperInterfaces.forEach(_function_1);
    }

    private List<Class<?>> getSuperInterfacesOfInterface(Class<?> c) {
        if (c == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        this.getSuperInterfacesOfInterface(c, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private List<Class<?>> getInterfacesOfEObject(EObject o) {
        Functions.Function1 _function;
        ArrayList possibleInterfaces = new ArrayList();
        List<Class<?>> interfaces = this.getAllInterfaces(o.getClass());
        Class baseInterface = (Class)IterableExtensions.findFirst(interfaces, (Functions.Function1)(_function = i -> i.getSimpleName().equals(o.eClass().getName())));
        if (baseInterface != null) {
            possibleInterfaces.add(baseInterface);
            possibleInterfaces.addAll(this.getSuperInterfacesOfInterface(baseInterface));
        }
        InputOutput.println(possibleInterfaces);
        return possibleInterfaces;
    }

    private List<Class<?>> getAllInterfaces(Class<? extends EObject> cls) {
        if (cls == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        this.getAllInterfaces(cls, interfacesFound);
        ArrayList res = new ArrayList(interfacesFound);
        return res;
    }

    private void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        Class<?> currCls = cls;
        while (currCls != null) {
            Consumer<Class> _function = i -> {
                boolean _add = interfacesFound.add((Class<?>)i);
                if (_add) {
                    this.getAllInterfaces((Class<?>)i, interfacesFound);
                }
            };
            ((List)Conversions.doWrapArray(currCls.getInterfaces())).forEach(_function);
            currCls = currCls.getSuperclass();
        }
    }

    private Map<Class<?>, List<Class<?>>> getStaticHelperClasses(EObject target) {
        List<Class<?>> allPossibleInterfaces = this.getInterfacesOfEObject(target);
        HashMap res = new HashMap();
        Set allAspects = K3DslHelper.getAspects((String)this.languageName);
        Consumer<Class> _function = i -> {
            Functions.Function1 _function_1 = asp -> {
                Class _target = K3DslHelper.getTarget((Class)asp);
                return Objects.equal((Object)_target, (Object)i);
            };
            Iterable appliedAspects = IterableExtensions.filter((Iterable)allAspects, (Functions.Function1)_function_1);
            res.put((Class<?>)i, IterableExtensions.toList((Iterable)appliedAspects));
        };
        allPossibleInterfaces.forEach(_function);
        return res;
    }
}

