/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.resource;

import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.sirius.business.internal.resource.SiriusRepresentationXMIResourceImpl;
import org.eclipse.sirius.business.internal.resource.SiriusResourceFactory;

public class SiriusRepresentationResourceFactory
extends SiriusResourceFactory {
    public Resource createResource(URI uri) {
        XMIResource resource = this.doCreateResource(uri);
        this.setOptions(resource);
        if (!resource.getEncoding().equals("UTF-8")) {
            resource.setEncoding("UTF-8");
        }
        return resource;
    }

    protected XMIResource doCreateResource(URI uri) {
        return new SiriusRepresentationXMIResourceImpl(uri);
    }

    private void setOptions(XMIResource resource) {
        HashMap<Object, Object> loadOptions = new HashMap<Object, Object>();
        HashMap<Object, Object> saveOptions = new HashMap<Object, Object>();
        loadOptions.putAll(SiriusRepresentationResourceFactory.getDefaultLoadOptions());
        saveOptions.putAll(SiriusRepresentationResourceFactory.getDefaultSaveOptions());
        loadOptions.put("DEFER_ATTACHMENT", true);
        loadOptions.put("DEFER_IDREF_RESOLUTION", true);
        loadOptions.put("USE_DEPRECATED_METHODS", false);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl(true));
        loadOptions.put("USE_XML_NAME_TO_FEATURE_MAP", new HashMap());
        loadOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        saveOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        resource.getDefaultSaveOptions().putAll(saveOptions);
        resource.getDefaultLoadOptions().putAll(loadOptions);
    }
}

