/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.gemini.web.core.WebApplication;
import org.eclipse.gemini.web.core.WebApplicationStartFailedException;
import org.eclipse.gemini.web.internal.StandardWebApplication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WebApplicationStartFailureRetryController {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebApplicationStartFailureRetryController.class);
    private final Object monitor = new Object();
    private final ConcurrentMap<String, Set<StandardWebApplication>> failures = new ConcurrentHashMap<String, Set<StandardWebApplication>>();

    WebApplicationStartFailureRetryController() {
    }

    void recordFailure(StandardWebApplication failedWebApplication) {
        String contextPath = failedWebApplication.getContextPath();
        if (contextPath != null) {
            this.addFailureForWebContextPath(contextPath, failedWebApplication);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFailureForWebContextPath(String contextPath, StandardWebApplication failedWebApplication) {
        Set previousContextFailures;
        Set<StandardWebApplication> contextFailures = (HashSet<StandardWebApplication>)this.failures.get(contextPath);
        if (contextFailures == null && (previousContextFailures = (Set)this.failures.putIfAbsent(contextPath, contextFailures = new HashSet<StandardWebApplication>())) != null) {
            contextFailures = previousContextFailures;
        }
        Object object = this.monitor;
        synchronized (object) {
            contextFailures.add(failedWebApplication);
        }
    }

    void retryFailures(StandardWebApplication stoppedWebApplication) {
        String contextPath = stoppedWebApplication.getContextPath();
        if (contextPath != null) {
            Set<StandardWebApplication> contextFailures = this.removeFailuresForWebContextPath(contextPath);
            contextFailures.remove(stoppedWebApplication);
            for (WebApplication webApplication : contextFailures) {
                try {
                    webApplication.start();
                }
                catch (WebApplicationStartFailedException _) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("", (Throwable)_);
                }
            }
        }
    }

    private Set<StandardWebApplication> removeFailuresForWebContextPath(String contextPath) {
        Set<StandardWebApplication> sortedContextFailures = this.createSetSortedByBundleId();
        Set contextFailures = (Set)this.failures.remove(contextPath);
        if (contextFailures != null) {
            sortedContextFailures.addAll(contextFailures);
        }
        return sortedContextFailures;
    }

    private Set<StandardWebApplication> createSetSortedByBundleId() {
        return new TreeSet<StandardWebApplication>(new Comparator<StandardWebApplication>(){

            @Override
            public int compare(StandardWebApplication wa1, StandardWebApplication wa2) {
                long id2;
                long id1 = wa1.getBundle().getBundleId();
                if (id1 < (id2 = wa2.getBundle().getBundleId())) {
                    return -1;
                }
                if (id1 > id2) {
                    return 1;
                }
                return this.compareHashcode(wa1, wa2);
            }

            private int compareHashcode(StandardWebApplication wa1, StandardWebApplication wa2) {
                long hashcode2;
                long hashcode1 = wa1.hashCode();
                if (hashcode1 < (hashcode2 = (long)wa2.hashCode())) {
                    return -1;
                }
                if (hashcode1 > hashcode2) {
                    return 1;
                }
                return 0;
            }
        });
    }

    void clear() {
        this.failures.clear();
    }
}

