/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.internal;

import java.util.List;
import org.eclipse.virgo.util.osgi.VersionRange;
import org.eclipse.virgo.util.osgi.manifest.DynamicallyImportedPackage;
import org.eclipse.virgo.util.osgi.manifest.internal.BaseCompoundHeaderEntry;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderParser;

class StandardDynamicallyImportedPackage
extends BaseCompoundHeaderEntry
implements DynamicallyImportedPackage {
    StandardDynamicallyImportedPackage(HeaderParser parser, String name) {
        super(parser, name);
    }

    HeaderDeclaration parse(HeaderParser parser, String parseString) {
        List<HeaderDeclaration> headerDeclarations = parser.parseDynamicImportPackageHeader(parseString);
        return headerDeclarations.get(0);
    }

    public String getPackageName() {
        return this.name;
    }

    public void setPackageName(String packageName) {
        this.name = packageName;
    }

    public String getBundleSymbolicName() {
        return this.getAttributes().get("bundle-symbolic-name");
    }

    public VersionRange getBundleVersion() {
        return new VersionRange(this.getAttributes().get("bundle-version"));
    }

    public VersionRange getVersion() {
        String value = this.getAttributes().get("version");
        return new VersionRange(value);
    }

    public void setVersion(VersionRange versionRange) {
        if (versionRange != null) {
            this.getAttributes().put("version", versionRange.toParseString());
        } else {
            this.getAttributes().remove("version");
        }
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        this.getAttributes().put("bundle-symbolic-name", bundleSymbolicName);
    }

    public void setBundleVersion(VersionRange versionRange) {
        if (versionRange != null) {
            this.getAttributes().put("bundle-version", versionRange.toParseString());
        } else {
            this.getAttributes().remove("bundle-version");
        }
    }
}

