/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import org.eclipse.gemini.naming.CloseableProviderAdmin;
import org.eclipse.gemini.naming.SecurityUtils;

class SecurityAwareProviderAdminImpl
implements CloseableProviderAdmin {
    private static final Logger logger = Logger.getLogger(SecurityAwareProviderAdminImpl.class.getName());
    private final CloseableProviderAdmin m_closeableProviderAdmin;

    public SecurityAwareProviderAdminImpl(CloseableProviderAdmin closeableProviderAdmin) {
        this.m_closeableProviderAdmin = closeableProviderAdmin;
    }

    @Override
    public Object getObjectInstance(Object refInfo, Name name, Context context, Map environment) throws Exception {
        GetObjectInstanceAction action = new GetObjectInstanceAction(refInfo, name, context, environment);
        return SecurityAwareProviderAdminImpl.invokePrivilegedAction(action);
    }

    @Override
    public Object getObjectInstance(Object refInfo, Name name, Context context, Map environment, Attributes attributes) throws Exception {
        GetObjectInstanceActionWithAttributes action = new GetObjectInstanceActionWithAttributes(refInfo, name, context, environment, attributes);
        return SecurityAwareProviderAdminImpl.invokePrivilegedAction(action);
    }

    @Override
    public void close() {
        try {
            SecurityUtils.invokePrivilegedActionNoReturn(new CloseAction());
        }
        catch (Exception exception) {
            logger.log(Level.FINE, "Exception occurred while trying to close this JNDIProviderAdmin implementation", exception);
        }
    }

    private static Object invokePrivilegedAction(PrivilegedExceptionAction action) throws Exception {
        return SecurityUtils.invokePrivilegedAction(action);
    }

    private class CloseAction
    implements PrivilegedExceptionAction {
        private CloseAction() {
        }

        public Object run() throws Exception {
            SecurityAwareProviderAdminImpl.this.m_closeableProviderAdmin.close();
            return null;
        }
    }

    private class GetObjectInstanceAction
    implements PrivilegedExceptionAction {
        protected final Object m_refInfo;
        protected final Name m_name;
        protected final Context m_context;
        protected final Map m_environment;

        GetObjectInstanceAction(Object refInfo, Name name, Context context, Map environment) {
            this.m_refInfo = refInfo;
            this.m_name = name;
            this.m_context = context;
            this.m_environment = environment;
        }

        public Object run() throws Exception {
            return SecurityAwareProviderAdminImpl.this.m_closeableProviderAdmin.getObjectInstance(this.m_refInfo, this.m_name, this.m_context, this.m_environment);
        }
    }

    private class GetObjectInstanceActionWithAttributes
    extends GetObjectInstanceAction {
        private final Attributes m_attributes;

        GetObjectInstanceActionWithAttributes(Object refInfo, Name name, Context context, Map environment, Attributes attributes) {
            super(refInfo, name, context, environment);
            this.m_attributes = attributes;
        }

        @Override
        public Object run() throws Exception {
            return SecurityAwareProviderAdminImpl.this.m_closeableProviderAdmin.getObjectInstance(this.m_refInfo, this.m_name, this.m_context, this.m_environment, this.m_attributes);
        }
    }
}

