/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.jpa;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.eclipse.gemini.jpa.GeminiUtil;

public class PersistenceDescriptorInfo {
    URL url;
    String jarPath;
    String descriptorPath;

    public PersistenceDescriptorInfo() {
    }

    public PersistenceDescriptorInfo(URL url, String descPath) {
        this();
        this.url = url;
        this.descriptorPath = descPath;
    }

    public PersistenceDescriptorInfo(URL url, String descPath, String jarPath) {
        this(url, descPath);
        this.jarPath = jarPath;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public String getDescriptorPath() {
        return this.descriptorPath;
    }

    public void setDescriptorPath(String descriptorPath) {
        this.descriptorPath = descriptorPath;
    }

    public boolean isEmbedded() {
        return this.jarPath != null;
    }

    public String fullDescriptorPath() {
        return this.isEmbedded() ? String.valueOf(this.jarPath) + "!/" + this.descriptorPath : this.descriptorPath;
    }

    public InputStream getDescriptorStream() {
        GeminiUtil.debug("getDescriptorStream - url=", this.url, " descPath=", this.descriptorPath, " jarPath=", this.jarPath);
        InputStream inStream = null;
        try {
            inStream = this.url.openStream();
        }
        catch (IOException iOException) {}
        if (!this.isEmbedded() || inStream == null) {
            return inStream;
        }
        JarInputStream jarStream = null;
        JarEntry jarEntry = null;
        try {
            jarStream = new JarInputStream(new BufferedInputStream(inStream));
            GeminiUtil.debug("getDescriptorStream - Looking in jar for embedded descriptor: ", (Object)this.descriptorPath);
            do {
                if ((jarEntry = jarStream.getNextJarEntry()) == null || !jarEntry.getName().equalsIgnoreCase(this.descriptorPath)) continue;
                GeminiUtil.debug("getDescriptorStream - Found jar entry: ", (Object)jarEntry.getName());
                break;
            } while (jarEntry != null);
        }
        catch (IOException ioEx) {
            GeminiUtil.warning("getDescriptorStream - Received exception looking for embedded descriptor ", ioEx);
            try {
                jarStream.close();
            }
            catch (Throwable throwable) {}
            return null;
        }
        return jarStream;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Descriptor: ").append(this.getDescriptorPath());
        if (this.isEmbedded()) {
            sb.append(" embedded in ");
            sb.append(this.jarPath);
        }
        return sb.toString();
    }
}

