/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import org.eclipse.gemini.naming.BuilderUtils;
import org.eclipse.gemini.naming.ReflectionUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jndi.JNDIContextManager;

class TraditionalInitialContextFactoryBuilder
implements InitialContextFactoryBuilder {
    private static final String JNDI_CONTEXT_MANAGER_CLASS = JNDIContextManager.class.getName();
    private static final String INITIAL_CONTEXT_CLASSNAME = InitialContext.class.getName();
    private static final String INITIAL_DIR_CONTEXT_CLASSNAME = InitialDirContext.class.getName();

    public InitialContextFactory createInitialContextFactory(Hashtable environment) throws NamingException {
        return new TraditionalInitialContextFactory();
    }

    private static class TraditionalContextInvocationHandler
    implements InvocationHandler {
        private final ServiceReference m_referenceToContextManager;
        private final Context m_context;
        private final BundleContext m_bundleContext;

        TraditionalContextInvocationHandler(ServiceReference refToContextManager, Context context, BundleContext bundleContext) {
            this.m_referenceToContextManager = refToContextManager;
            this.m_context = context;
            this.m_bundleContext = bundleContext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("close")) {
                this.m_bundleContext.ungetService(this.m_referenceToContextManager);
            }
            return ReflectionUtils.invokeMethodOnContext(method, this.m_context, args);
        }
    }

    private static class TraditionalInitialContextFactory
    implements InitialContextFactory {
        private TraditionalInitialContextFactory() {
        }

        public Context getInitialContext(Hashtable environment) throws NamingException {
            BundleContext clientBundleContext = BuilderUtils.getBundleContext(environment, INITIAL_CONTEXT_CLASSNAME);
            if (clientBundleContext == null) {
                clientBundleContext = BuilderUtils.getBundleContext(environment, INITIAL_DIR_CONTEXT_CLASSNAME);
            }
            if (clientBundleContext == null) {
                throw new NoInitialContextException("Client's BundleContext could not be located");
            }
            ServiceReference serviceRef = clientBundleContext.getServiceReference(JNDI_CONTEXT_MANAGER_CLASS);
            if (serviceRef == null) {
                throw new NamingException("JNDIContextManager service not available yet, cannot create a new context");
            }
            JNDIContextManager contextManager = (JNDIContextManager)clientBundleContext.getService(serviceRef);
            if (contextManager == null) {
                throw new NamingException("JNDIContextManager service not available yet, cannot create a new context");
            }
            try {
                Context newInitialContext = contextManager.newInitialContext(environment);
                TraditionalContextInvocationHandler handler = new TraditionalContextInvocationHandler(serviceRef, newInitialContext, clientBundleContext);
                if (newInitialContext instanceof DirContext) {
                    return (DirContext)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{DirContext.class}, (InvocationHandler)handler);
                }
                return (Context)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Context.class}, (InvocationHandler)handler);
            }
            catch (NamingException namingException) {
                clientBundleContext.ungetService(serviceRef);
                throw namingException;
            }
        }
    }
}

