/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.gemini.naming.OSGiURLParser;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

class ServiceUtils {
    private ServiceUtils() {
    }

    static ServiceReference[] sortServiceReferences(ServiceTracker serviceTracker) {
        ServiceReference[] serviceReferences = serviceTracker.getServiceReferences();
        if (serviceReferences == null) {
            return new ServiceReference[0];
        }
        return ServiceUtils.sortServiceReferences(serviceReferences);
    }

    static ServiceReference[] sortServiceReferences(ServiceReference[] serviceReferences) {
        Arrays.sort(serviceReferences, new Comparator(){

            public int compare(Object objectOne, Object objectTwo) {
                ServiceReference serviceReferenceOne = (ServiceReference)objectOne;
                ServiceReference serviceReferenceTwo = (ServiceReference)objectTwo;
                return serviceReferenceTwo.compareTo((Object)serviceReferenceOne);
            }
        });
        return serviceReferences;
    }

    static ServiceReference[] getServiceReferencesByServiceName(BundleContext bundleContext, OSGiURLParser urlParser) throws InvalidSyntaxException {
        String serviceNameFilter = "(osgi.jndi.service.name=" + urlParser.getServiceInterface() + ")";
        ServiceReference[] serviceReferencesByName = bundleContext.getServiceReferences(null, serviceNameFilter);
        return serviceReferencesByName;
    }
}

