/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.RelaySAPoint;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.SPPoint;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.common.base.support.NoResizeFeature;
import org.eclipse.etrice.ui.structure.DiagramTypeProvider;
import org.eclipse.etrice.ui.structure.dialogs.SPPPropertyDialog;
import org.eclipse.etrice.ui.structure.support.InterfaceItemSupport;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IMultiDeleteInfo;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.MultiDeleteInfo;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class SPPSupport
extends InterfaceItemSupport {
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public SPPSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    protected static String getSPPKind(SPP spp) {
        Object kind = "";
        if (SupportUtil.getInstance().getRoomHelpers().isRelay(spp)) {
            kind = (String)kind + "R";
        }
        return kind;
    }

    private class BehaviorProvider
    extends InterfaceItemSupport.BehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            return new FeatureProvider.PropertyFeature(this.getDiagramTypeProvider().getFeatureProvider());
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            ICreateConnectionFeature[] features;
            IContextButtonPadData data = super.getContextButtonPad(context);
            PictogramElement pe = context.getPictogramElement();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourcePictogramElement(pe);
            Anchor anchor = null;
            if (pe instanceof AnchorContainer) {
                anchor = (Anchor)((ContainerShape)pe).getAnchors().get(0);
            }
            ccc.setSourceAnchor(anchor);
            ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
            button.setText("Create Layer Connection");
            button.setIconId("org.eclipse.etrice.ui.structure.layer_connection");
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
                if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                    button.addDragAndDropFeature((IFeature)feature);
                }
                ++n2;
            }
            if (button.getDragAndDropFeatures().size() > 0) {
                data.getDomainSpecificContextButtons().add(button);
            }
            return data;
        }
    }

    private static class FeatureProvider
    extends InterfaceItemSupport.FeatureProvider {
        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp, fp);
        }

        public ICreateFeature[] getCreateFeatures() {
            return new ICreateFeature[]{new CreateFeature(this.fp)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        @Override
        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            return new InterfaceItemSupport.FeatureProvider.MoveShapeFeature(this.fp);
        }

        @Override
        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new NoResizeFeature(this.fp);
        }

        @Override
        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            ArrayList<PropertyFeature> features = new ArrayList<PropertyFeature>();
            features.add(new PropertyFeature(this.fp));
            Arrays.stream(super.getCustomFeatures(context)).forEach(e -> {
                boolean bl = features.add((PropertyFeature)((Object)e));
            });
            return features.toArray(new ICustomFeature[0]);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        @Override
        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        protected static void createSPPFigure(SPP spp, boolean refspp, ContainerShape containerShape, GraphicsAlgorithm invisibleRectangle, Color darkColor, Color brightDolor) {
            boolean relay = SupportUtil.getInstance().getRoomHelpers().isRelay(spp);
            int size = refspp ? 18 : 40;
            int margin = refspp ? 30 : 40;
            int line = refspp ? 1 : 2;
            Color bg = brightDolor;
            bg = refspp ? darkColor : (relay ? brightDolor : darkColor);
            IGaService gaService = Graphiti.getGaService();
            Ellipse rect = gaService.createEllipse((GraphicsAlgorithmContainer)invisibleRectangle);
            rect.setForeground(darkColor);
            rect.setBackground(bg);
            rect.setLineWidth(Integer.valueOf(line));
            gaService.setLocationAndSize((GraphicsAlgorithm)rect, margin - size / 2, margin - size / 2, size, size);
            if (containerShape.getAnchors().isEmpty()) {
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ChopboxAnchor anchor = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
                anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)rect);
            } else {
                ((Anchor)containerShape.getAnchors().get(0)).setReferencedGraphicsAlgorithm((GraphicsAlgorithm)rect);
            }
        }

        private static void updateSPPFigure(SPP spp, PictogramElement pe, Color dark, Color bright) {
            ContainerShape container = (ContainerShape)pe;
            GraphicsAlgorithm invisibleRect = pe.getGraphicsAlgorithm();
            invisibleRect.getGraphicsAlgorithmChildren().clear();
            FeatureProvider.createSPPFigure(spp, FeatureProvider.isRefItem(pe), container, invisibleRect, dark, bright);
            GraphicsAlgorithm ga = ((Shape)container.getChildren().get(0)).getGraphicsAlgorithm();
            if (ga instanceof Text) {
                ((Text)ga).setValue(spp.getName());
            }
        }

        private class AddFeature
        extends InterfaceItemSupport.FeatureProvider.AddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            @Override
            protected String getItemKind(InterfaceItem item) {
                if (item instanceof SPP) {
                    return SPPSupport.getSPPKind((SPP)item);
                }
                return "";
            }

            @Override
            protected void createItemFigure(InterfaceItem item, boolean refitem, ContainerShape containerShape, GraphicsAlgorithm invisibleRectangle, Color darkColor, Color brightDolor) {
                if (item instanceof SPP) {
                    FeatureProvider.createSPPFigure((SPP)item, refitem, containerShape, invisibleRectangle, darkColor, brightDolor);
                }
            }
        }

        private static class CreateFeature
        extends InterfaceItemSupport.FeatureProvider.CreateFeature {
            public CreateFeature(IFeatureProvider fp) {
                super(fp, false, "SPP", "create SPP");
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.structure.spp";
            }

            public Object[] doCreate(ICreateContext context) {
                ActorContainerClass acc = (ActorContainerClass)context.getTargetContainer().getLink().getBusinessObjects().get(0);
                SPP spp = RoomFactory.eINSTANCE.createSPP();
                spp.setName(SupportUtil.getInstance().getRoomUtil().getUniqueName("spp", (StructureClass)acc));
                acc.getServiceProvisionPoints().add((Object)spp);
                IScopeProvider scopeProvider = ((DiagramTypeProvider)this.getFeatureProvider().getDiagramTypeProvider()).getScopeProvider();
                IScope scope = scopeProvider.getScope(spp.eContainer().eContainer(), RoomPackage.eINSTANCE.getInterfaceItem_Protocol());
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SPPPropertyDialog dlg = new SPPPropertyDialog(shell, spp, scope, true, false);
                if (dlg.open() == 0) {
                    this.addGraphicalRepresentation((IAreaContext)context, spp);
                    return new Object[]{spp};
                }
                return null;
            }
        }

        private static class DeleteFeature
        extends InterfaceItemSupport.FeatureProvider.DeleteFeature {
            private ArrayList<LayerConnection> external = new ArrayList();
            private ArrayList<LayerConnection> internal = new ArrayList();

            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            @Override
            public boolean canDelete(IDeleteContext context) {
                if (!super.canDelete(context)) {
                    return false;
                }
                ContainerShape shape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)shape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof SPP;
            }

            public void delete(IDeleteContext context) {
                boolean proceed;
                this.external.clear();
                this.internal.clear();
                SPP spp = (SPP)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                StructureClass sc = (StructureClass)spp.eContainer();
                Collection refs = EcoreUtil.UsageCrossReferencer.find((EObject)spp, (ResourceSet)spp.eResource().getResourceSet());
                for (EStructuralFeature.Setting ref : refs) {
                    if (ref.getEObject() instanceof RelaySAPoint || ref.getEObject() instanceof SPPoint) {
                        if (ref.getEObject().eContainer().eContainer() instanceof StructureClass && ref.getEObject().eContainer().eContainer() == sc) {
                            this.internal.add((LayerConnection)ref.getEObject().eContainer());
                            continue;
                        }
                        this.external.add((LayerConnection)ref.getEObject().eContainer());
                        continue;
                    }
                    if (!(ref.getEObject() instanceof ServiceImplementation)) continue;
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete SPP", (String)"This spp cannot be deleted since it is referenced by a service implementation.");
                    return;
                }
                if (!this.external.isEmpty() && !(proceed = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete SPP", (String)"This spp is connected externally.\nIt can only be deleted if the external layer connections are also deleted.\n\nProceed?"))) {
                    return;
                }
                super.delete(context);
            }

            public void preDelete(IDeleteContext context) {
                for (LayerConnection bind : this.internal) {
                    PictogramElement connection = this.getFeatureProvider().getPictogramElementForBusinessObject((Object)bind);
                    DeleteContext ctx = new DeleteContext(connection);
                    ctx.setMultiDeleteInfo((IMultiDeleteInfo)new MultiDeleteInfo(false, false, 1));
                    IDeleteFeature deleteFeature = this.getFeatureProvider().getDeleteFeature((IDeleteContext)ctx);
                    if (deleteFeature == null) continue;
                    deleteFeature.delete((IDeleteContext)ctx);
                }
                for (LayerConnection bind : this.external) {
                    EcoreUtil.delete((EObject)bind);
                }
                super.preDelete(context);
            }
        }

        private static class PropertyFeature
        extends InterfaceItemSupport.FeatureProvider.PropertyFeature {
            public PropertyFeature(IFeatureProvider fp) {
                super(fp, "Edit SPP...", "Edit SPP Properties");
            }

            @Override
            public boolean canExecute(ICustomContext context) {
                if (!super.canExecute(context)) {
                    return false;
                }
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && pes[0] instanceof ContainerShape) {
                    Object bo = this.getBusinessObjectForPictogramElement(pes[0]);
                    return bo instanceof SPP;
                }
                return false;
            }

            public boolean doExecute(ICustomContext context) {
                SPP spp = (SPP)this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
                boolean refport = FeatureProvider.isRefItem(context.getPictogramElements()[0]);
                IScopeProvider scopeProvider = ((DiagramTypeProvider)this.getFeatureProvider().getDiagramTypeProvider()).getScopeProvider();
                IScope scope = scopeProvider.getScope(spp.eContainer().eContainer(), RoomPackage.eINSTANCE.getInterfaceItem_Protocol());
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                SPPPropertyDialog dlg = new SPPPropertyDialog(shell, spp, scope, false, refport);
                if (dlg.open() == 0) {
                    FeatureProvider.updateSPPFigure(spp, context.getPictogramElements()[0], this.manageColor(DARK_COLOR), this.manageColor(BRIGHT_COLOR));
                    return true;
                }
                return false;
            }
        }

        private class UpdateFeature
        extends InterfaceItemSupport.FeatureProvider.UpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            @Override
            protected String getItemKind(InterfaceItem item) {
                if (item instanceof SPP) {
                    return SPPSupport.getSPPKind((SPP)item);
                }
                return "";
            }

            @Override
            protected void updateFigure(InterfaceItem item, PictogramElement pe, Color dark, Color bright) {
                FeatureProvider.updateSPPFigure((SPP)item, pe, dark, bright);
            }
        }
    }
}

