/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.quickfix;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.etrice.core.common.ui.modelpath.ModelPathManager;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ui.editor.model.edit.IModification;
import org.eclipse.xtext.ui.editor.model.edit.IMultiModification;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.Fixes;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.validation.Issue;

public class BaseQuickfixProvider
extends DefaultQuickfixProvider {
    @Fix(value="BaseJavaValidator.DeprecatedImportUri")
    public void removeImportUri(Issue issue, IssueResolutionAcceptor acceptor) {
        ISemanticModification iSemanticModification = (element, context) -> {
            Import imp = (Import)element;
            imp.setImportURI(null);
        };
        acceptor.accept(issue, "Remove import uri", "Remove the import uri", null, iSemanticModification);
    }

    @Fixes(value={@Fix(value="BaseJavaValidator.ModelpathDescriptionMissing"), @Fix(value="BaseJavaValidator.ImportedNamespaceMissing")})
    public void editModelpathDescription(Issue issue, IssueResolutionAcceptor acceptor) {
        URI resourceUri = issue.getUriToProblem().trimFragment();
        boolean bl = resourceUri.isPlatform();
        if (bl) {
            boolean bl2;
            String string = resourceUri.toPlatformString(true);
            Path path = new Path(string);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path).getProject();
            IFile file = project.getFile((IPath)ModelPathManager.MODELPATH_FILE);
            boolean bl3 = file.exists();
            boolean bl4 = bl2 = !bl3;
            if (bl2) {
                IModification iModification = it -> {
                    StringConcatenation stringConcatenation = new StringConcatenation();
                    stringConcatenation.append("// modelpath description");
                    stringConcatenation.newLine();
                    stringConcatenation.newLine();
                    stringConcatenation.append("// HOWTO define source directory");
                    stringConcatenation.newLine();
                    stringConcatenation.append("// srcDir <directory path>");
                    stringConcatenation.newLine();
                    stringConcatenation.newLine();
                    stringConcatenation.append("// HOWTO define project dependency");
                    stringConcatenation.newLine();
                    stringConcatenation.append("// project <project name>");
                    stringConcatenation.newLine();
                    StringInputStream input = new StringInputStream(stringConcatenation.toString());
                    file.create((InputStream)input, false, null);
                    IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
                };
                acceptor.accept(issue, "Create modelpath description", "Create modelpath description file", null, iModification);
            } else {
                IModification iModification = it -> IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
                acceptor.accept(issue, "Edit modelpath description", "Edit modelpath description file to configure modelpath definitions", null, iModification);
            }
        }
    }

    @Fix(value="BaseJavaValidator.DeprecatedDocumentation")
    public void removeDeprecatedDocStrings(Issue issue, IssueResolutionAcceptor acceptor) {
        IMultiModification iMultiModification = doc -> doc.eContainer().eSet(doc.eContainingFeature(), null);
        acceptor.acceptMulti(issue, "Remove documentation string", "Remove deprecated documentation string", null, iMultiModification);
    }
}

