/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.fsm.util;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.base.util.BaseHelpers;
import org.eclipse.etrice.core.fsm.fSM.AbstractInterfaceItem;
import org.eclipse.etrice.core.fsm.fSM.ChoicePoint;
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.fsm.fSM.FSMFactory;
import org.eclipse.etrice.core.fsm.fSM.FSMPackage;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.MessageFromIf;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.NonInitialTransition;
import org.eclipse.etrice.core.fsm.fSM.RefinedState;
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition;
import org.eclipse.etrice.core.fsm.fSM.SimpleState;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.fSM.StateGraphItem;
import org.eclipse.etrice.core.fsm.fSM.StateGraphNode;
import org.eclipse.etrice.core.fsm.fSM.StateTerminal;
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.TrPoint;
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal;
import org.eclipse.etrice.core.fsm.fSM.Transition;
import org.eclipse.etrice.core.fsm.fSM.TransitionChainStartTransition;
import org.eclipse.etrice.core.fsm.fSM.TransitionPoint;
import org.eclipse.etrice.core.fsm.fSM.TransitionTerminal;
import org.eclipse.etrice.core.fsm.fSM.Trigger;

public class FSMHelpers
extends BaseHelpers {
    public boolean isCircularClassHierarchy(ModelComponent mc) {
        HashSet<ModelComponent> classes = new HashSet<ModelComponent>();
        classes.add(mc);
        while (mc.getBase() != null) {
            if (classes.contains(mc = mc.getBase())) {
                return true;
            }
            classes.add(mc);
        }
        return false;
    }

    public StateGraph getActualStateMachine(ModelComponent mc) {
        while (mc != null) {
            if (mc.getStateMachine() != null) {
                return mc.getStateMachine();
            }
            mc = mc.getBase();
        }
        return null;
    }

    public StateGraph getSuperStateMachine(ModelComponent mc) {
        StateGraph stateMachine = this.getActualStateMachine(mc);
        if ((mc = this.getModelComponent(stateMachine)) != null && mc.getBase() != null) {
            return this.getActualStateMachine(mc.getBase());
        }
        return null;
    }

    public ModelComponent getModelComponent(StateGraphItem item) {
        StateGraphItem parent = item;
        while (parent != null) {
            if (!((parent = parent.eContainer()) instanceof ModelComponent)) continue;
            return (ModelComponent)((Object)parent);
        }
        assert (false) : "data structure broken";
        return null;
    }

    public ModelComponent getModelComponent(EObject obj) {
        EObject parent = obj;
        while (parent != null) {
            if (!((parent = parent.eContainer()) instanceof ModelComponent)) continue;
            return (ModelComponent)parent;
        }
        return null;
    }

    public boolean hasSubStructure(State state, ModelComponent mc) {
        if (this.hasDirectSubStructure(state)) {
            return true;
        }
        if (state instanceof RefinedState) {
            State target = ((RefinedState)state).getTarget();
            while (target != null) {
                if (this.hasDirectSubStructure(target)) {
                    return true;
                }
                if (!(target instanceof RefinedState)) break;
                target = ((RefinedState)target).getTarget();
            }
        }
        if (mc.getStateMachine() != null) {
            Iterator<State> iterator = this.getAllStatesRecursive(mc.getStateMachine()).iterator();
            block1: while (iterator.hasNext()) {
                State s;
                State predecessor = s = iterator.next();
                while (predecessor instanceof RefinedState) {
                    if ((predecessor = ((RefinedState)predecessor).getTarget()) != state) continue;
                    predecessor = s;
                    while (predecessor instanceof RefinedState) {
                        if (this.hasDirectSubStructure(predecessor)) {
                            return true;
                        }
                        predecessor = ((RefinedState)s).getTarget();
                        if (predecessor == state) continue block1;
                    }
                    continue block1;
                }
            }
        }
        return false;
    }

    public boolean hasDirectSubStructure(State s) {
        return !this.isEmpty(s.getSubgraph());
    }

    public boolean hasNonEmptyStateMachine(ModelComponent mc) {
        return !this.isEmpty(mc.getStateMachine());
    }

    public boolean isEmpty(StateGraph sg) {
        if (sg == null) {
            return true;
        }
        if (!sg.getStates().isEmpty()) {
            return false;
        }
        if (!sg.getTransitions().isEmpty()) {
            return false;
        }
        if (!sg.getTrPoints().isEmpty()) {
            return false;
        }
        if (!sg.getChPoints().isEmpty()) {
            return false;
        }
        return sg.getRefinedTransitions().isEmpty();
    }

    public boolean isTopLevel(StateGraph sg) {
        return !(sg.eContainer() instanceof State);
    }

    public boolean isTopLevel(StateGraphNode s) {
        return this.isTopLevel((StateGraph)s.eContainer());
    }

    public boolean isLeaf(State s) {
        return s.getSubgraph() == null;
    }

    public List<State> getLeafStateList(State state) {
        return this.getLeafStateList(state.getSubgraph());
    }

    public List<State> getLeafStateList(StateGraph sg) {
        ArrayList<State> res = new ArrayList<State>();
        if (sg != null) {
            TreeIterator it = sg.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof State) || !this.isLeaf((State)obj)) continue;
                res.add((State)obj);
            }
        }
        return res;
    }

    public List<State> getStateList(StateGraph sg) {
        ArrayList<State> res = new ArrayList<State>();
        if (sg != null) {
            TreeIterator it = sg.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof State)) continue;
                res.add((State)obj);
            }
        }
        return res;
    }

    public List<State> getBaseStateList(StateGraph sg) {
        ArrayList<State> res = new ArrayList<State>();
        if (sg != null) {
            TreeIterator it = sg.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof SimpleState)) continue;
                res.add((State)obj);
            }
        }
        return res;
    }

    public List<State> getAllBaseStates(ModelComponent mc) {
        return this.getBaseStateList(mc.getStateMachine());
    }

    public State getParentState(StateGraphNode s) {
        if (this.isTopLevel(s)) {
            return null;
        }
        return (State)s.eContainer().eContainer();
    }

    public State getTargettingState(State state, ModelComponent mc) {
        State targetting = state;
        Iterator<State> iterator = this.getAllStatesRecursive(mc.getStateMachine()).iterator();
        while (iterator.hasNext()) {
            State s;
            State predecessor = s = iterator.next();
            while (predecessor instanceof RefinedState) {
                if ((predecessor = ((RefinedState)predecessor).getTarget()) != state) continue;
                targetting = s;
            }
        }
        return targetting;
    }

    public SimpleState getFinalTarget(RefinedState state) {
        State target = state.getTarget();
        if (target instanceof SimpleState) {
            return (SimpleState)target;
        }
        if (target instanceof RefinedState) {
            return this.getFinalTarget((RefinedState)target);
        }
        assert (false) : "unexpected sub type";
        return null;
    }

    public boolean hasDetailCode(DetailCode dc) {
        if (dc == null) {
            return false;
        }
        if (dc.getLines().isEmpty() && dc.isUsed()) {
            return true;
        }
        for (String cmd : dc.getLines()) {
            if (cmd.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGuard(Trigger trig) {
        return trig.getGuard() != null && this.hasDetailCode(trig.getGuard().getGuard());
    }

    public boolean hasEntryCode(State s, boolean includeInherited) {
        return this.hasDetailCode(s, includeInherited, FSMPackage.Literals.STATE__ENTRY_CODE);
    }

    public boolean hasExitCode(State s, boolean includeInherited) {
        return this.hasDetailCode(s, includeInherited, FSMPackage.Literals.STATE__EXIT_CODE);
    }

    public boolean hasDoCode(State s, boolean includeInherited) {
        return this.hasDetailCode(s, includeInherited, FSMPackage.Literals.STATE__DO_CODE);
    }

    private boolean hasDetailCode(State s, boolean includeInherited, EReference feature) {
        DetailCode dc = (DetailCode)s.eGet((EStructuralFeature)feature);
        if (this.hasDetailCode(dc)) {
            return true;
        }
        if (includeInherited && s instanceof RefinedState) {
            return !this.getInheritedCode((RefinedState)s, feature, true).getLines().isEmpty();
        }
        return false;
    }

    public String getDetailCode(DetailCode code) {
        if (code == null || code.getLines().isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String cmd : code.getLines()) {
            result.append(String.valueOf(cmd) + "\n");
        }
        return result.toString();
    }

    public DetailCode getInheritedEntryCode(RefinedState rs) {
        return this.getInheritedCode(rs, FSMPackage.Literals.STATE__ENTRY_CODE, true);
    }

    public DetailCode getInheritedExitCode(RefinedState rs) {
        return this.getInheritedCode(rs, FSMPackage.Literals.STATE__EXIT_CODE, false);
    }

    public DetailCode getInheritedDoCode(RefinedState rs) {
        return this.getInheritedCode(rs, FSMPackage.Literals.STATE__DO_CODE, true);
    }

    private DetailCode getInheritedCode(RefinedState rs, EReference code, boolean addFront) {
        DetailCode result = FSMFactory.eINSTANCE.createDetailCode();
        boolean used = false;
        State s = rs.getTarget();
        while (s != null) {
            DetailCode dc = (DetailCode)s.eGet((EStructuralFeature)code);
            if (dc != null) {
                if (addFront) {
                    result.getLines().addAll(0, dc.getLines());
                } else {
                    result.getLines().addAll(dc.getLines());
                }
            }
            used = this.hasDetailCode(dc);
            if (!(s instanceof RefinedState)) break;
            s = ((RefinedState)s).getTarget();
        }
        result.setUsed(used);
        return result;
    }

    public State getRefinedStateFor(StateGraph sg, State state) {
        ModelComponent mc;
        for (State s : sg.getStates()) {
            if (!(s instanceof RefinedState) || !s.getName().equals(state.getName())) continue;
            return s;
        }
        if (sg.eContainer() instanceof State) {
            if (sg.eContainer() instanceof RefinedState) {
                return this.getRefinedStateFor(((RefinedState)sg.eContainer()).getTarget().getSubgraph(), state);
            }
        } else if (sg.eContainer() instanceof ModelComponent && (mc = (ModelComponent)sg.eContainer()).getBase() != null && mc.getBase().getStateMachine() != null) {
            return this.getRefinedStateFor(mc.getBase().getStateMachine(), state);
        }
        return state;
    }

    public boolean isGuarded(Trigger trig) {
        return this.hasGuard(trig);
    }

    public boolean isHandler(Transition tr) {
        if (tr instanceof TransitionChainStartTransition) {
            TrPoint tp;
            TransitionChainStartTransition trans = (TransitionChainStartTransition)tr;
            if (trans.getFrom() instanceof TrPointTerminal) {
                TrPoint tp2 = ((TrPointTerminal)trans.getFrom()).getTrPoint();
                if (tp2 instanceof TransitionPoint) {
                    return ((TransitionPoint)tp2).isHandler();
                }
            } else if (trans.getFrom() instanceof SubStateTrPointTerminal && (tp = ((SubStateTrPointTerminal)trans.getFrom()).getTrPoint()) instanceof TransitionPoint) assert (false) : "not allowed to connect TransitionPoint to exterior";
        }
        return false;
    }

    public State getSuperState(Transition tr) {
        if (tr.eContainer().eContainer() instanceof State) {
            return (State)tr.eContainer().eContainer();
        }
        return null;
    }

    public StateGraphNode getNode(TransitionTerminal tt) {
        if (tt instanceof StateTerminal) {
            return ((StateTerminal)tt).getState();
        }
        if (tt instanceof TrPointTerminal) {
            return ((TrPointTerminal)tt).getTrPoint();
        }
        if (tt instanceof SubStateTrPointTerminal) {
            return ((SubStateTrPointTerminal)tt).getTrPoint();
        }
        if (tt instanceof ChoicepointTerminal) {
            return ((ChoicepointTerminal)tt).getCp();
        }
        return null;
    }

    public List<State> getAllStates(StateGraph sg) {
        return this.getAllStateGraphItems(sg, FSMPackage.eINSTANCE.getStateGraph_States(), false);
    }

    public List<State> getAllStatesRecursive(StateGraph sg) {
        return this.getAllStateGraphItems(sg, FSMPackage.eINSTANCE.getStateGraph_States(), true);
    }

    public List<TrPoint> getAllTrPoints(StateGraph sg) {
        return this.getAllStateGraphItems(sg, FSMPackage.eINSTANCE.getStateGraph_TrPoints(), false);
    }

    public List<TrPoint> getAllTrPointsRecursive(StateGraph sg) {
        return this.getAllStateGraphItems(sg, FSMPackage.eINSTANCE.getStateGraph_TrPoints(), true);
    }

    public List<ChoicePoint> getAllChoicePoints(StateGraph sg) {
        return this.getAllStateGraphItems(sg, FSMPackage.eINSTANCE.getStateGraph_ChPoints(), false);
    }

    public List<Transition> getAllTransitions(StateGraph sg) {
        return this.getAllStateGraphItems(sg, FSMPackage.eINSTANCE.getStateGraph_Transitions(), false);
    }

    public List<Transition> getAllTransitionsRecursive(StateGraph sg) {
        return this.getAllStateGraphItems(sg, FSMPackage.eINSTANCE.getStateGraph_Transitions(), true);
    }

    private <T extends StateGraphItem> List<T> getAllStateGraphItems(StateGraph sg, EReference feature, boolean recurse) {
        ArrayList<T> result = new ArrayList<T>();
        while (sg != null) {
            ModelComponent base;
            Object items = sg.eGet((EStructuralFeature)feature);
            if (items instanceof List) {
                result.addAll((List)items);
            }
            if (recurse) {
                for (State s : sg.getStates()) {
                    if (s.getSubgraph() == null) continue;
                    List<T> subItems = this.getAllStateGraphItems(s.getSubgraph(), feature, recurse);
                    result.addAll(subItems);
                }
            }
            if (sg.eContainer() instanceof RefinedState) {
                sg = ((RefinedState)sg.eContainer()).getTarget().getSubgraph();
                continue;
            }
            if (!(sg.eContainer() instanceof ModelComponent) || (base = ((ModelComponent)sg.eContainer()).getBase()) != null && this.isCircularClassHierarchy(base)) break;
            StateGraph stateGraph = sg = base != null ? base.getStateMachine() : null;
        }
        return result;
    }

    public Set<String> getAllNames(StateGraph sg) {
        return this.getAllNames(sg, null);
    }

    public Set<String> getAllNames(StateGraph sg, StateGraphItem skip) {
        HashSet<String> result = new HashSet<String>();
        do {
            ModelComponent base;
            for (State st : sg.getStates()) {
                if (st == skip) continue;
                result.add(st.getName());
            }
            for (TrPoint tp : sg.getTrPoints()) {
                if (tp == skip) continue;
                result.add(tp.getName());
            }
            for (ChoicePoint cp : sg.getChPoints()) {
                if (cp == skip) continue;
                result.add(cp.getName());
            }
            for (Transition tr : sg.getTransitions()) {
                if (tr == skip) continue;
                result.add(tr.getName());
            }
            if (sg.eContainer() instanceof RefinedState) {
                sg = ((RefinedState)sg.eContainer()).getTarget().getSubgraph();
                continue;
            }
            if (!(sg.eContainer() instanceof ModelComponent) || (base = ((ModelComponent)sg.eContainer()).getBase()) != null && this.isCircularClassHierarchy(base)) break;
            StateGraph stateGraph = sg = base != null ? base.getStateMachine() : null;
        } while (sg != null);
        return result;
    }

    public Set<String> getAllStateNames(StateGraph sg) {
        return this.getAllNames(sg, null, FSMPackage.eINSTANCE.getStateGraph_States());
    }

    public Set<String> getAllStateNames(StateGraph sg, State skip) {
        return this.getAllNames(sg, skip, FSMPackage.eINSTANCE.getStateGraph_States());
    }

    public Set<String> getAllTrPointNames(StateGraph sg) {
        return this.getAllNames(sg, null, FSMPackage.eINSTANCE.getStateGraph_TrPoints());
    }

    public Set<String> getAllTrPointNames(StateGraph sg, TrPoint skip) {
        return this.getAllNames(sg, skip, FSMPackage.eINSTANCE.getStateGraph_TrPoints());
    }

    public Set<String> getAllChoicePointNames(StateGraph sg) {
        return this.getAllNames(sg, null, FSMPackage.eINSTANCE.getStateGraph_ChPoints());
    }

    public Set<String> getAllChoicePointNames(StateGraph sg, ChoicePoint skip) {
        return this.getAllNames(sg, skip, FSMPackage.eINSTANCE.getStateGraph_ChPoints());
    }

    public Set<String> getAllTransitionNames(StateGraph sg) {
        return this.getAllNames(sg, null, FSMPackage.eINSTANCE.getStateGraph_Transitions());
    }

    public Set<String> getAllTransitionNames(StateGraph sg, Transition skip) {
        return this.getAllNames(sg, skip, FSMPackage.eINSTANCE.getStateGraph_Transitions());
    }

    private <T extends StateGraphItem> Set<String> getAllNames(StateGraph sg, T skip, EReference feature) {
        List<T> items = this.getAllStateGraphItems(sg, feature, false);
        HashSet<String> names = new HashSet<String>();
        for (StateGraphItem item : items) {
            if (item == skip) continue;
            names.add(item.getName());
        }
        return names;
    }

    public boolean hasFlatStateMachine(ModelComponent mc) {
        if (this.isEmpty(mc.getStateMachine())) {
            return false;
        }
        if (!mc.getStateMachine().getTrPoints().isEmpty()) {
            return false;
        }
        for (State st : mc.getStateMachine().getStates()) {
            if (!this.hasDirectSubStructure(st)) continue;
            return false;
        }
        return true;
    }

    public SimpleState getBaseState(State s) {
        if (s instanceof SimpleState) {
            return (SimpleState)s;
        }
        if (s instanceof RefinedState) {
            return this.getBaseState(((RefinedState)s).getTarget());
        }
        return null;
    }

    public List<State> getReferencedStatesRecursively(RefinedState rs) {
        ArrayList<State> result = new ArrayList<State>();
        State target = rs.getTarget();
        result.add(target);
        if (target instanceof RefinedState) {
            List<State> refs = this.getReferencedStatesRecursively((RefinedState)target);
            result.addAll(refs);
        }
        return result;
    }

    public boolean referencesStateRecursively(RefinedState rs, State referenced) {
        State target = rs.getTarget();
        if (target == referenced) {
            return true;
        }
        if (target instanceof SimpleState) {
            return false;
        }
        if (target instanceof RefinedState) {
            return this.referencesStateRecursively((RefinedState)target, referenced);
        }
        assert (false) : "unexpected sub type";
        return false;
    }

    public Map<RefinedState, RefinedState> getRefinedStatesToRelocate(ModelComponent mc, Function<RefinedState, String> nameProvider) {
        ArrayList<RefinedState> refinedStates = new ArrayList<RefinedState>();
        ArrayList<String> paths = new ArrayList<String>();
        HashMap<String, RefinedState> path2rs = new HashMap<String, RefinedState>();
        TreeIterator it = mc.getStateMachine().eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof RefinedState)) continue;
            refinedStates.add((RefinedState)obj);
            String path = (String)nameProvider.apply((Object)((RefinedState)obj));
            paths.add(path);
            path2rs.put(path, (RefinedState)obj);
        }
        Collections.sort(paths, Collections.reverseOrder());
        HashMap<RefinedState, RefinedState> rs2parent = new HashMap<RefinedState, RefinedState>();
        block1: for (RefinedState rs : refinedStates) {
            String fullPath = (String)nameProvider.apply((Object)rs);
            for (String path : paths) {
                if (fullPath.equals(path) || !fullPath.startsWith(path) || fullPath.charAt(path.length()) != "_".charAt(0)) continue;
                RefinedState parent = (RefinedState)path2rs.get(path);
                if (parent.getSubgraph() != null && parent.getSubgraph().getStates().contains((Object)rs)) continue block1;
                rs2parent.put(rs, parent);
                continue block1;
            }
        }
        return rs2parent;
    }

    public String getBaseEntryCode(RefinedState state) {
        return this.getBaseCode(state, (EStructuralFeature)FSMPackage.Literals.STATE__ENTRY_CODE);
    }

    public String getBaseExitCode(RefinedState state) {
        return this.getBaseCode(state, (EStructuralFeature)FSMPackage.Literals.STATE__EXIT_CODE);
    }

    public String getBaseDoCode(RefinedState state) {
        return this.getBaseCode(state, (EStructuralFeature)FSMPackage.Literals.STATE__DO_CODE);
    }

    private String getBaseCode(RefinedState state, EStructuralFeature feat) {
        StringBuilder result = new StringBuilder();
        State base = state.getTarget();
        while (base != null) {
            String code = this.getDetailCode((DetailCode)base.eGet(feat));
            result.append(code);
            if (!(base instanceof RefinedState)) break;
            base = ((RefinedState)base).getTarget();
        }
        return result.toString();
    }

    public boolean hasActionCode(Transition trans, ModelComponent mc) {
        ModelComponent baseMC = this.getModelComponent(trans);
        while (mc != null) {
            if (mc == baseMC) {
                return this.hasDetailCode(trans.getAction());
            }
            if (mc.getStateMachine() != null) {
                for (RefinedTransition rt : mc.getStateMachine().getRefinedTransitions()) {
                    if (rt.getTarget() != trans || !this.hasDetailCode(rt.getAction())) continue;
                    return true;
                }
            }
            mc = mc.getBase();
        }
        return false;
    }

    public String getInheritedActionCode(Transition trans, ModelComponent mc) {
        return this.getActionCode(trans, mc, false);
    }

    public String getAllActionCode(Transition trans, ModelComponent mc) {
        return this.getActionCode(trans, mc, true);
    }

    private String getActionCode(Transition trans, ModelComponent mc, boolean includeOwn) {
        StringBuilder result = new StringBuilder();
        ModelComponent baseMC = this.getModelComponent(trans);
        if (!includeOwn) {
            if (mc == baseMC) {
                return null;
            }
            mc = mc.getBase();
        }
        while (mc != null) {
            if (mc == baseMC) {
                result.insert(0, this.getDetailCode(trans.getAction()));
                return result.toString();
            }
            if (mc.getStateMachine() != null) {
                for (RefinedTransition rt : mc.getStateMachine().getRefinedTransitions()) {
                    if (rt.getTarget() != trans) continue;
                    result.insert(0, this.getDetailCode(rt.getAction()));
                }
            }
            mc = mc.getBase();
        }
        return null;
    }

    public List<MessageFromIf> getMessagesFromInterfaces(ModelComponent mc) {
        ArrayList<MessageFromIf> result = new ArrayList<MessageFromIf>();
        EList<AbstractInterfaceItem> items = mc.getAbstractInterfaceItems();
        for (AbstractInterfaceItem item : items) {
            for (EObject msg : item.getAllIncomingAbstractMessages()) {
                MessageFromIf mif = FSMFactory.eINSTANCE.createMessageFromIf();
                mif.setMessage(msg);
                mif.setFrom(item);
                result.add(mif);
            }
        }
        return result;
    }

    public List<MessageFromIf> getOwnMessagesFromInterfaces(ModelComponent mc) {
        ArrayList<MessageFromIf> result = new ArrayList<MessageFromIf>();
        result.addAll(this.getMessagesFromInterfaces(mc));
        mc = mc.getBase();
        while (mc != null) {
            if (this.hasNonEmptyStateMachine(mc)) break;
            EList<AbstractInterfaceItem> items = mc.getAbstractInterfaceItems();
            for (AbstractInterfaceItem item : items) {
                for (EObject msg : item.getAllIncomingAbstractMessages()) {
                    MessageFromIf mif = FSMFactory.eINSTANCE.createMessageFromIf();
                    mif.setMessage(msg);
                    mif.setFrom(item);
                    result.add(mif);
                }
            }
            mc = mc.getBase();
        }
        return result;
    }

    public List<MessageFromIf> getAllMessagesFromInterfaces(ModelComponent mc) {
        ArrayList<MessageFromIf> result = new ArrayList<MessageFromIf>();
        while (mc != null) {
            EList<AbstractInterfaceItem> items = mc.getAbstractInterfaceItems();
            for (AbstractInterfaceItem item : items) {
                for (EObject msg : item.getAllIncomingAbstractMessages()) {
                    MessageFromIf mif = FSMFactory.eINSTANCE.createMessageFromIf();
                    mif.setMessage(msg);
                    mif.setFrom(item);
                    result.add(mif);
                }
            }
            mc = mc.getBase();
        }
        return result;
    }

    public Transition getInitTransition(StateGraph sg) {
        for (Transition tr : sg.getTransitions()) {
            if (!(tr instanceof InitialTransition)) continue;
            return tr;
        }
        return null;
    }

    public Transition getInitTransitionForNodeList(Set<StateGraph> sgs, List<StateGraphNode> allowedTargetNodes) {
        for (StateGraph sg : sgs) {
            StateGraphNode target;
            Transition initTrans = this.getInitTransition(sg);
            if (initTrans == null || !allowedTargetNodes.contains(target = this.getTerminalState(initTrans.getTo()))) continue;
            return initTrans;
        }
        return null;
    }

    public boolean hasInitTransition(StateGraph sg) {
        return this.getInitTransition(sg) != null;
    }

    public StateGraphNode getTerminalState(TransitionTerminal tt) {
        if (tt instanceof SubStateTrPointTerminal) {
            return ((SubStateTrPointTerminal)tt).getState();
        }
        return this.getTerminalNode(tt);
    }

    public StateGraphNode getTerminalNode(TransitionTerminal tt) {
        if (tt instanceof ChoicepointTerminal) {
            return ((ChoicepointTerminal)tt).getCp();
        }
        if (tt instanceof SubStateTrPointTerminal) {
            return ((SubStateTrPointTerminal)tt).getTrPoint();
        }
        if (tt instanceof TrPointTerminal) {
            return ((TrPointTerminal)tt).getTrPoint();
        }
        if (tt instanceof StateTerminal) {
            return ((StateTerminal)tt).getState();
        }
        return null;
    }

    public List<Transition> getTransitionsFromGraphNode(Set<StateGraph> sgs, StateGraphNode node) {
        HashSet<Transition> result = new HashSet<Transition>();
        for (StateGraph sg : sgs) {
            result.addAll(this.getTransitionsFromGraphNode(sg, node));
        }
        return new ArrayList<Transition>(result);
    }

    public List<Transition> getTransitionsFromGraphNode(StateGraph sg, StateGraphNode node) {
        ArrayList<Transition> result = new ArrayList<Transition>();
        for (Transition tr : sg.getTransitions()) {
            TransitionTerminal tt;
            if (!(tr instanceof NonInitialTransition) || this.getTerminalState(tt = ((NonInitialTransition)tr).getFrom()) != node) continue;
            result.add(tr);
        }
        return result;
    }

    public List<Transition> getTransitionsToGraphNode(Set<StateGraph> sgs, StateGraphNode node) {
        HashSet<Transition> result = new HashSet<Transition>();
        for (StateGraph sg : sgs) {
            result.addAll(this.getTransitionsToGraphNode(sg, node));
        }
        return new ArrayList<Transition>(result);
    }

    public List<Transition> getTransitionsToGraphNode(StateGraph sg, StateGraphNode node) {
        ArrayList<Transition> result = new ArrayList<Transition>();
        for (Transition tr : sg.getTransitions()) {
            TransitionTerminal tt = tr.getTo();
            if (this.getTerminalState(tt) != node) continue;
            result.add(tr);
        }
        return result;
    }

    public List<StateGraphNode> getAllNodes(StateGraph sg) {
        LinkedList<StateGraphNode> result = new LinkedList<StateGraphNode>();
        result.addAll((Collection<StateGraphNode>)sg.getTrPoints());
        result.addAll((Collection<StateGraphNode>)sg.getStates());
        result.addAll((Collection<StateGraphNode>)sg.getChPoints());
        return result;
    }

    public boolean isSelfTransition(Transition trans) {
        StateGraphNode to;
        StateGraphNode from = trans instanceof InitialTransition ? null : this.getTerminalState(((NonInitialTransition)trans).getFrom());
        return from == (to = this.getTerminalState(trans.getTo()));
    }

    public int getSamePathTransitionCount(StateGraph sg, Transition trans) {
        int count = 1;
        StateGraphNode src = trans instanceof InitialTransition ? null : this.getTerminalState(((NonInitialTransition)trans).getFrom());
        StateGraphNode dest = this.getTerminalState(trans.getTo());
        for (Transition t : sg.getTransitions()) {
            if (trans == t) continue;
            StateGraphNode tSrc = t instanceof InitialTransition ? null : this.getTerminalState(((NonInitialTransition)t).getFrom());
            StateGraphNode tDest = this.getTerminalState(t.getTo());
            if ((tSrc != src || tDest != dest) && (tSrc != dest || tDest != src)) continue;
            ++count;
        }
        return count;
    }
}

