/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.contentassist;

import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.core.common.base.util.RelativePathHelpers;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;

public class ImportModelAssist {
    public static void addPaths(final AbstractContentProposalProvider provider, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor, final String extension) {
        final IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getFullPath();
        Path modelPath = new Path(context.getRootModel().eResource().getURI().toPlatformString(true));
        modelPath = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)modelPath).getLocation();
        final URI modelURI = URI.createFileURI((String)modelPath.toOSString()).trimSegments(1);
        IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

            public boolean visit(IResourceProxy proxy) throws CoreException {
                if (proxy.getType() != 1) {
                    return true;
                }
                if (proxy.getName().endsWith(extension)) {
                    String displayString;
                    IPath relModelPath = proxy.requestFullPath();
                    relModelPath = ResourcesPlugin.getWorkspace().getRoot().getFile(relModelPath).getLocation();
                    URI relURI = URI.createFileURI((String)relModelPath.toOSString());
                    String relPath = RelativePathHelpers.getRelativePath((URI)modelURI, (URI)relURI, (boolean)true);
                    if (relPath == null) {
                        relPath = "file:/" + relURI.toFileString().replaceAll("\\\\", "/");
                    }
                    IPath relWorkspacePath = proxy.requestFullPath().makeRelativeTo(rootPath);
                    String proposalString = "\"" + relPath + "\"";
                    ICompletionProposal proposal = provider.createCompletionProposal(proposalString, new StyledString(displayString = String.valueOf(relModelPath.lastSegment()) + " - " + relWorkspacePath), null, context);
                    if (proposal instanceof ConfigurableCompletionProposal) {
                        ConfigurableCompletionProposal cfgProposal = (ConfigurableCompletionProposal)proposal;
                        cfgProposal.setAutoInsertable(false);
                        cfgProposal.setMatcher((PrefixMatcher)new ImportPrefixMatcher());
                    }
                    acceptor.accept(proposal);
                }
                return false;
            }
        };
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(visitor, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static class ImportPrefixMatcher
    extends PrefixMatcher {
        private ImportPrefixMatcher() {
        }

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            String[] segments = name.split("/");
            String last = segments.length > 0 ? segments[segments.length - 1] : "";
            return last.replace("\"", "").toLowerCase().startsWith(prefix.replace("\"", "").toLowerCase());
        }
    }
}

