/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.conversion.bitvectors;

import com.github.javabdd.BDD;
import com.github.javabdd.BDDFactory;
import java.math.BigInteger;
import java.util.Arrays;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.BddBitVectorAndCarry;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.SignedBddBitVector;
import org.eclipse.escet.cif.bdd.conversion.bitvectors.UnsignedBddBitVector;
import org.eclipse.escet.cif.bdd.spec.CifBddDomain;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Pair;
import org.eclipse.escet.common.java.Strings;

public abstract class BddBitVector<T extends BddBitVector<T, TC>, TC extends BddBitVectorAndCarry<T, TC>> {
    protected BDDFactory factory;
    protected BDD[] bits;

    protected BddBitVector(BDDFactory factory, int length) {
        if (length < this.getMinimumLength()) {
            throw new IllegalArgumentException(Strings.fmt((String)"Length is less than %d.", (Object[])new Object[]{this.getMinimumLength()}));
        }
        this.factory = factory;
        this.bits = new BDD[length];
    }

    protected abstract int getMinimumLength();

    protected abstract T createEmpty(int var1);

    public T copy() {
        T vector = this.createEmpty(this.bits.length);
        int i = 0;
        while (i < this.bits.length) {
            ((BddBitVector)vector).bits[i] = this.bits[i].id();
            ++i;
        }
        return vector;
    }

    public void replaceBy(T other) {
        this.free();
        this.factory = ((BddBitVector)other).factory;
        this.bits = ((BddBitVector)other).bits;
        ((BddBitVector)other).factory = null;
        ((BddBitVector)other).bits = null;
    }

    public static Pair<BddBitVector<?, ?>, BddBitVector<?, ?>> ensureCompatible(BddBitVector<?, ?> vector1, BddBitVector<?, ?> vector2) {
        if (vector1 instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uVector1 = (UnsignedBddBitVector)vector1;
            if (vector2 instanceof UnsignedBddBitVector) {
                return Pair.pair(vector1, vector2);
            }
            Assert.check((boolean)(vector2 instanceof SignedBddBitVector));
            SignedBddBitVector signedVector1 = SignedBddBitVector.createFromUnsignedBitVector(uVector1);
            uVector1.free();
            return Pair.pair((Object)signedVector1, vector2);
        }
        Assert.check((boolean)(vector1 instanceof SignedBddBitVector));
        if (vector2 instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uVector2 = (UnsignedBddBitVector)vector2;
            SignedBddBitVector signedVector2 = SignedBddBitVector.createFromUnsignedBitVector(uVector2);
            uVector2.free();
            return Pair.pair(vector1, (Object)signedVector2);
        }
        Assert.check((boolean)(vector2 instanceof SignedBddBitVector));
        return Pair.pair(vector1, vector2);
    }

    public static void ensureSameLength(BddBitVector<?, ?> vector1, BddBitVector<?, ?> vector2) {
        BddBitVector.ensureSameLength(vector1, vector2, 0);
    }

    public static void ensureSameLength(BddBitVector<?, ?> vector1, BddBitVector<?, ?> vector2, int extraBits) {
        if (extraBits < 0) {
            throw new IllegalArgumentException("The number of extra bits is negative.");
        }
        int length = Math.max(vector1.length(), vector2.length());
        vector1.resize(length += extraBits);
        vector2.resize(length);
    }

    public int length() {
        return this.bits.length;
    }

    int countInt() {
        if (this.bits.length > 30) {
            throw new IllegalStateException("More than 30 bits in vector.");
        }
        return 1 << this.bits.length;
    }

    long countLong() {
        if (this.bits.length > 62) {
            throw new IllegalStateException("More than 62 bits in vector.");
        }
        return 1L << this.bits.length;
    }

    public BDD getBit(int index) {
        return this.bits[index];
    }

    public abstract BigInteger getLower();

    public abstract int getLowerInt();

    public abstract BigInteger getUpper();

    public abstract int getUpperInt();

    public abstract Integer getInt();

    public abstract Long getLong();

    public void setBit(int idx, BDD bdd) {
        this.bits[idx].free();
        this.bits[idx] = bdd;
    }

    public void setBit(int idx, boolean value) {
        this.setBit(idx, value ? this.factory.one() : this.factory.zero());
    }

    public void setBitsToValue(boolean value) {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            this.bits[i] = value ? this.factory.one() : this.factory.zero();
            ++i;
        }
    }

    public abstract void setInt(int var1);

    public void setDomain(CifBddDomain domain) {
        int varCnt = domain.getVarCount();
        if (varCnt != this.bits.length) {
            throw new IllegalArgumentException("Domain length is not equal to the bit vector length.");
        }
        int[] vars = domain.getVarIndices();
        int i = 0;
        while (i < varCnt) {
            this.bits[i].free();
            this.bits[i] = this.factory.ithVar(vars[i]);
            ++i;
        }
    }

    public abstract void resize(int var1);

    public abstract T shrink();

    public abstract TC negate();

    public abstract TC abs();

    public abstract T sign();

    public abstract TC add(T var1);

    public BddBitVectorAndCarry<?, ?> addAny(BddBitVector<?, ?> other) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.add((UnsignedBddBitVector)other);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.add((SignedBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public abstract TC subtract(T var1);

    public BddBitVectorAndCarry<?, ?> subtractAny(BddBitVector<?, ?> other) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.subtract((UnsignedBddBitVector)other);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.subtract((SignedBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public abstract T div(int var1);

    public abstract T mod(int var1);

    public T shiftLeft(int amount, BDD carry) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount is negative.");
        }
        T result = this.createEmpty(this.bits.length);
        int numberOfCarryBits = Math.min(this.bits.length, amount);
        int i = 0;
        while (i < numberOfCarryBits) {
            ((BddBitVector)result).bits[i] = carry.id();
            ++i;
        }
        while (i < this.bits.length) {
            ((BddBitVector)result).bits[i] = this.bits[i - amount].id();
            ++i;
        }
        return result;
    }

    public T shiftRight(int amount, BDD carry) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount is negative.");
        }
        T result = this.createEmpty(this.bits.length);
        int numberOfPreservedBits = Math.max(0, this.bits.length - amount);
        int i = 0;
        while (i < numberOfPreservedBits) {
            ((BddBitVector)result).bits[i] = this.bits[i + amount].id();
            ++i;
        }
        while (i < this.bits.length) {
            ((BddBitVector)result).bits[i] = carry.id();
            ++i;
        }
        return result;
    }

    public T ifThenElse(T elseVector, BDD condition) {
        if (this.bits.length != ((BddBitVector)elseVector).bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        T rslt = this.createEmpty(this.bits.length);
        int i = 0;
        while (i < this.bits.length) {
            ((BddBitVector)rslt).bits[i] = condition.ite(this.getBit(i), ((BddBitVector)elseVector).getBit(i));
            ++i;
        }
        return rslt;
    }

    public BddBitVector<?, ?> ifThenElseAny(BddBitVector<?, ?> elseVector, BDD condition) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.ifThenElse((UnsignedBddBitVector)elseVector, condition);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.ifThenElse((SignedBddBitVector)elseVector, condition);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public abstract BDD lessThan(T var1);

    public BDD lessThanAny(BddBitVector<?, ?> other) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.lessThan((UnsignedBddBitVector)other);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.lessThan((SignedBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public abstract BDD lessOrEqual(T var1);

    public BDD lessOrEqualAny(BddBitVector<?, ?> other) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.lessOrEqual((UnsignedBddBitVector)other);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.lessOrEqual((SignedBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public BDD greaterThan(T other) {
        BDD le = this.lessOrEqual(other);
        BDD gt = le.not();
        le.free();
        return gt;
    }

    public BDD greaterThanAny(BddBitVector<?, ?> other) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.greaterThan((UnsignedBddBitVector)other);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.greaterThan((SignedBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public BDD greaterOrEqual(T other) {
        BDD lt = this.lessThan(other);
        BDD ge = lt.not();
        lt.free();
        return ge;
    }

    public BDD greaterOrEqualAny(BddBitVector<?, ?> other) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.greaterOrEqual((UnsignedBddBitVector)other);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.greaterOrEqual((SignedBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public BDD equalTo(T other) {
        if (this.bits.length != ((BddBitVector)other).bits.length) {
            throw new IllegalArgumentException("Different lengths.");
        }
        BDD eq = this.factory.one();
        int i = 0;
        while (i < this.bits.length) {
            BDD bit = this.bits[i].biimp(((BddBitVector)other).bits[i]);
            eq = eq.andWith(bit);
            ++i;
        }
        return eq;
    }

    public BDD equalToAny(BddBitVector<?, ?> other) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.equalTo((UnsignedBddBitVector)other);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.equalTo((SignedBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public BDD unequalTo(T other) {
        BDD eq = this.equalTo(other);
        BDD uneq = eq.not();
        eq.free();
        return uneq;
    }

    public BDD unequalToAny(BddBitVector<?, ?> other) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.unequalTo((UnsignedBddBitVector)other);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.unequalTo((SignedBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public T min(T other) {
        BDD cmp = this.lessOrEqual(other);
        T result = this.ifThenElse(other, cmp);
        cmp.free();
        return result;
    }

    public BddBitVector<?, ?> minAny(BddBitVector<?, ?> other) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.min((UnsignedBddBitVector)other);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.min((SignedBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public T max(T other) {
        BDD cmp = this.greaterOrEqual(other);
        T result = this.ifThenElse(other, cmp);
        cmp.free();
        return result;
    }

    public BddBitVector<?, ?> maxAny(BddBitVector<?, ?> other) {
        BddBitVector bddBitVector = this;
        if (bddBitVector instanceof UnsignedBddBitVector) {
            UnsignedBddBitVector uThis = (UnsignedBddBitVector)bddBitVector;
            return uThis.max((UnsignedBddBitVector)other);
        }
        BddBitVector bddBitVector2 = this;
        if (bddBitVector2 instanceof SignedBddBitVector) {
            SignedBddBitVector sThis = (SignedBddBitVector)bddBitVector2;
            return sThis.max((SignedBddBitVector)other);
        }
        throw new AssertionError((Object)("Unknown bit vector representation: " + String.valueOf(this.getClass())));
    }

    public void free() {
        int i = 0;
        while (i < this.bits.length) {
            this.bits[i].free();
            ++i;
        }
        this.factory = null;
        this.bits = null;
    }

    public String toString() {
        if (this.bits == null) {
            return "freed";
        }
        return Arrays.toString(this.bits);
    }
}

