/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.output;

import org.eclipse.escet.common.app.framework.io.AppStream;
import org.eclipse.escet.common.app.framework.io.StdAppStream;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.java.Strings;

public class StreamOutputComponent
implements IOutputComponent {
    protected final AppStream out;
    protected final AppStream warn;
    protected final AppStream err;

    public StreamOutputComponent() {
        this(StdAppStream.OUT, StdAppStream.ERR, StdAppStream.ERR);
    }

    public StreamOutputComponent(AppStream out, AppStream warn, AppStream err) {
        this.out = out;
        this.warn = warn;
        this.err = err;
    }

    @Override
    public void dbg(String msg, int indent) {
        String[] stringArray = Strings.splitLines((String)msg);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.isEmpty()) {
                this.out.println();
            } else {
                this.out.println(Strings.spaces((int)(indent * 4)) + line);
            }
            ++n2;
        }
    }

    @Override
    public void out(String msg, int indent) {
        String[] stringArray = Strings.splitLines((String)msg);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.isEmpty()) {
                this.out.println();
            } else {
                this.out.println(Strings.spaces((int)(indent * 4)) + line);
            }
            ++n2;
        }
    }

    @Override
    public void warn(String msg, int indent) {
        String[] stringArray = Strings.splitLines((String)msg);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.isEmpty()) {
                this.warn.println(Strings.spaces((int)(indent * 4)) + "WARNING:");
            } else {
                this.warn.println(Strings.spaces((int)(indent * 4)) + "WARNING: " + line);
            }
            ++n2;
        }
    }

    @Override
    public void err(String msg) {
        String[] stringArray = Strings.splitLines((String)msg);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            this.err.println(line);
            ++n2;
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void cleanup() {
    }
}

