/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.simulink.typeinfos;

import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.c89.typeinfos.C89ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.ArrayTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.BoolTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.EnumTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.IntTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.RealTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.box.MemoryCodeBox;
import org.eclipse.escet.common.java.Strings;

public class SimulinkArrayTypeInfo
extends C89ArrayTypeInfo {
    public SimulinkArrayTypeInfo(boolean genLocalFunctions, CifType cifType, TypeInfo[] childTIs, int length) {
        super(genLocalFunctions, cifType, childTIs, length);
    }

    @Override
    public void generateCode(CodeContext ctxt) {
        MemoryCodeBox declCode = ctxt.makeCodeBox();
        MemoryCodeBox defCode = ctxt.makeCodeBox();
        this.generateC89Code((CodeBox)declCode, (CodeBox)defCode, ctxt);
        this.generateSimulinkCode((CodeBox)declCode, (CodeBox)defCode, ctxt);
        declCode.add();
        ctxt.appendReplacement("generated-types", declCode.toString());
        ctxt.appendReplacement("type-support-code", defCode.toString());
    }

    private void generateSimulinkCode(CodeBox declCode, CodeBox defCode, CodeContext ctxt) {
        ArrayTypeInfo inner;
        String header;
        String declarationPrefix;
        String definitionPrefix;
        if (this.genLocalFunctions) {
            definitionPrefix = "static ";
            declarationPrefix = "static ";
        } else {
            definitionPrefix = "";
            declarationPrefix = "extern ";
        }
        String typeName = this.getTypeName();
        String elementCopy = SimulinkArrayTypeInfo.getElementConversionFromSimulinkVector(this.childInfos[0], "vec[i]");
        if (elementCopy != null) {
            header = Strings.fmt((String)"%s %sTypeFromSimulink(real_T *vec)", (Object[])new Object[]{this.getTargetType(), typeName});
            declCode.add("%s%s;", new Object[]{declarationPrefix, header});
            defCode.add("/**");
            defCode.add(" * Construct a CIF array from a Simulink vector.");
            defCode.add(" * @param vec Simulink vector to copy.");
            defCode.add(" * @return The constructed array.");
            defCode.add(" */");
            defCode.add("%s%s {", new Object[]{definitionPrefix, header});
            defCode.indent();
            defCode.add("%s result;", new Object[]{this.getTargetType()});
            defCode.add("int i;");
            defCode.add("for (i = 0; i < %d; i++) result.data[i] = %s;", new Object[]{this.length, elementCopy});
            defCode.add("return result;");
            defCode.dedent();
            defCode.add("}");
            defCode.add();
        }
        if ((elementCopy = this.getElementConversionFromSimulinkMatrix(Strings.fmt((String)"vec[r + c * %d]", (Object[])new Object[]{this.length}))) != null) {
            header = Strings.fmt((String)"%s %sTypeFromSimulink(real_T *vec)", (Object[])new Object[]{this.getTargetType(), typeName});
            declCode.add("%s%s;", new Object[]{declarationPrefix, header});
            defCode.add("/**");
            defCode.add(" * Construct a CIF array from a Simulink matrix.");
            defCode.add(" * @param vec Simulink matrix to copy.");
            defCode.add(" * @return The constructed array.");
            defCode.add(" */");
            defCode.add("%s%s {", new Object[]{definitionPrefix, header});
            defCode.indent();
            defCode.add("%s result;", new Object[]{this.getTargetType()});
            defCode.add("int r;");
            defCode.add("for (r = 0; r < %d; r++) {", new Object[]{this.length});
            defCode.indent();
            inner = (ArrayTypeInfo)this.childInfos[0];
            defCode.add("int c;");
            defCode.add("for (c = 0; c < %d; r++) result.data[r].data[c] = %s;", new Object[]{inner.length, elementCopy});
            defCode.dedent();
            defCode.add("}");
            defCode.add("return result;");
            defCode.dedent();
            defCode.add("}");
            defCode.add();
        }
        if ((elementCopy = SimulinkArrayTypeInfo.getElementConversionToSimulinkVector(this.childInfos[0], "arr->data[i]")) != null) {
            header = Strings.fmt((String)"void %sTypeToSimulink(real_T *vec, %s *arr)", (Object[])new Object[]{typeName, this.getTargetType()});
            declCode.add("%s%s;", new Object[]{declarationPrefix, header});
            defCode.add("/**");
            defCode.add(" * Fill a Simulink vector from a CIF array.");
            defCode.add(" * @param vec Simulink vector to copy to.");
            defCode.add(" * @param arr Source array to get values from.");
            defCode.add(" */");
            defCode.add("%s%s {", new Object[]{definitionPrefix, header});
            defCode.indent();
            defCode.add("int i;");
            defCode.add("for (i = 0; i < %d; i++) vec[i] = %s;", new Object[]{this.length, elementCopy});
            defCode.dedent();
            defCode.add("}");
            defCode.add();
        }
        if ((elementCopy = this.getElementConversionToSimulinkMatrix("mat->data[r].data[c]")) != null) {
            header = Strings.fmt((String)"void %sTypeToSimulink(real_T *vec, %s *mat)", (Object[])new Object[]{typeName, this.getTargetType()});
            declCode.add("%s%s;", new Object[]{declarationPrefix, header});
            defCode.add("/**");
            defCode.add(" * Fill a Simulink matrix from a CIF array.");
            defCode.add(" * @param vec Simulink matrix to copy to.");
            defCode.add(" * @param mat Source array to get values from.");
            defCode.add(" */");
            defCode.add("%s%s {", new Object[]{definitionPrefix, header});
            defCode.indent();
            defCode.add("int r;");
            defCode.add("for (r = 0; r < %d; r++) {", new Object[]{this.length});
            defCode.indent();
            inner = (ArrayTypeInfo)this.childInfos[0];
            defCode.add("int c;");
            defCode.add("for (c = 0; c < %d; c++) vec[r + c * %d] = %s;", new Object[]{inner.length, this.length, elementCopy});
            defCode.dedent();
            defCode.add("}");
            defCode.dedent();
            defCode.add("}");
            defCode.add();
        }
    }

    public static String getElementConversionFromSimulinkVector(TypeInfo elmTi, String elmText) {
        if (elmTi instanceof BoolTypeInfo) {
            return Strings.fmt((String)"SimulinkToBool(%s)", (Object[])new Object[]{elmText});
        }
        if (elmTi instanceof IntTypeInfo) {
            return Strings.fmt((String)"SimulinkToInt(%s)", (Object[])new Object[]{elmText});
        }
        if (elmTi instanceof EnumTypeInfo) {
            return Strings.fmt((String)"(%s)SimulinkToEnum(%s)", (Object[])new Object[]{elmTi.getTargetType(), elmText});
        }
        if (elmTi instanceof RealTypeInfo) {
            return Strings.fmt((String)"SimulinkToReal(%s)", (Object[])new Object[]{elmText});
        }
        return null;
    }

    private String getElementConversionFromSimulinkMatrix(String elmText) {
        if (this.childInfos[0] instanceof ArrayTypeInfo) {
            ArrayTypeInfo outer = (ArrayTypeInfo)this.childInfos[0];
            return SimulinkArrayTypeInfo.getElementConversionFromSimulinkVector(outer.childInfos[0], elmText);
        }
        return null;
    }

    public static String getElementConversionToSimulinkVector(TypeInfo elmTi, String elmText) {
        if (elmTi instanceof BoolTypeInfo) {
            return Strings.fmt((String)"BoolToSimulink(%s)", (Object[])new Object[]{elmText});
        }
        if (elmTi instanceof IntTypeInfo) {
            return Strings.fmt((String)"IntToSimulink(%s)", (Object[])new Object[]{elmText});
        }
        if (elmTi instanceof EnumTypeInfo) {
            return Strings.fmt((String)"IntToSimulink(%s)", (Object[])new Object[]{elmText});
        }
        if (elmTi instanceof RealTypeInfo) {
            return Strings.fmt((String)"RealToSimulink(%s)", (Object[])new Object[]{elmText});
        }
        return null;
    }

    private String getElementConversionToSimulinkMatrix(String elmText) {
        if (this.childInfos[0] instanceof ArrayTypeInfo) {
            ArrayTypeInfo outer = (ArrayTypeInfo)this.childInfos[0];
            return SimulinkArrayTypeInfo.getElementConversionToSimulinkVector(outer.childInfos[0], elmText);
        }
        return null;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimulinkArrayTypeInfo)) {
            return false;
        }
        SimulinkArrayTypeInfo otherArray = (SimulinkArrayTypeInfo)other;
        if (!this.childInfos[0].equals(otherArray.childInfos[0])) {
            return false;
        }
        return this.length == otherArray.length;
    }

    @Override
    public int hashCode() {
        int h = SimulinkArrayTypeInfo.class.hashCode();
        return (h += this.childInfos[0].hashCode()) + this.length;
    }
}

