/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.dependency.ui.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyModel;
import org.eclipse.soda.sat.plugin.dependency.IBundleDependencyPreferences;
import org.eclipse.soda.sat.plugin.dependency.bundle.Activator;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.BundleDependencyCompositeBuilder;
import org.eclipse.soda.sat.plugin.dependency.ui.internal.nls.Messages;
import org.eclipse.soda.sat.plugin.ui.util.UiUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class BundleDependencyViewConfigurationDialog
extends Dialog {
    private static final String HELP_KEY = "BundleDependencyViewConfigurationDialog.Help";
    private static final String TITLE_KEY = "BundleDependencyViewConfigurationDialog.Title";
    private static final String USE_PREFERENCES_KEY = "BundleDependencyViewConfigurationDialog.UsePreferences";
    private static final String HELP_CONTEXT_ID = "org.eclipse.soda.sat.plugin.dependency.ui.configuration";
    private static final int HELP_ID = 1025;
    private BundleDependencyCompositeBuilder builder;
    private Label errorImageLabel;
    private Label errorMessageLabel;
    private IBundleDependencyModel model;
    private SelectionListener selectionListener;
    private Button useDefaultsButton;

    public BundleDependencyViewConfigurationDialog(Shell parentShell, IBundleDependencyModel model) {
        super(parentShell);
        int style = this.getShellStyle();
        this.setShellStyle(style |= 0x410);
        this.setModel(model);
    }

    protected void buttonPressed(int buttonId) {
        if (1025 == buttonId) {
            this.helpPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String value = Messages.getString(TITLE_KEY);
        shell.setText(value);
    }

    public void create() {
        super.create();
        this.initialize();
        this.hookupModifyListener();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, String.valueOf('&') + IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, String.valueOf('&') + IDialogConstants.CANCEL_LABEL, false);
        String helpLabel = Messages.getString(HELP_KEY);
        this.createButton(parent, 1025, helpLabel, false);
    }

    protected Control createDialogArea(Composite parent) {
        UiUtility utility = UiUtility.getInstance();
        utility.setHelp((Control)parent, HELP_CONTEXT_ID);
        Composite area = (Composite)super.createDialogArea(parent);
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        builder.build(area);
        this.createUseDefaultsButton(area);
        this.createErrorMessageLabel(area);
        this.createHorizontalSeparator(area);
        Dialog.applyDialogFont((Control)parent);
        return area;
    }

    private void createErrorMessageLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1816));
        Label label = new Label(composite, 0);
        GridData data = new GridData();
        data.widthHint = 16;
        data.heightHint = 15;
        label.setLayoutData((Object)data);
        this.setErrorImageLabel(label);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        this.setErrorMessageLabel(label);
    }

    private void createHorizontalSeparator(Composite parent) {
        Label label = new Label(parent, 258);
        GridData data = new GridData(264);
        label.setLayoutData((Object)data);
    }

    private ModifyListener createModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                BundleDependencyViewConfigurationDialog.this.handleModifiedText();
            }
        };
    }

    private SelectionListener createSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                BundleDependencyViewConfigurationDialog.this.handleUsePreferencesButtonSelected();
            }
        };
    }

    private void createUseDefaultsButton(Composite parent) {
        Button button = new Button(parent, 8);
        String value = Messages.getString(USE_PREFERENCES_KEY);
        button.setText(value);
        GridData data = new GridData(128);
        button.setLayoutData((Object)data);
        SelectionListener listener = this.getSelectionListener();
        button.addSelectionListener(listener);
        this.setUseDefaultsButton(button);
    }

    private void enableOkButton(boolean validText) {
        boolean enabled = validText && this.isDirty();
        Button button = this.getButton(0);
        button.setEnabled(enabled);
    }

    private void enableUseDefaultsButton(boolean validText) {
        boolean enabled = !validText || !this.isUsingPreferences();
        Button button = this.getUseDefaultsButton();
        button.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleDependencyCompositeBuilder getBuilder() {
        BundleDependencyViewConfigurationDialog bundleDependencyViewConfigurationDialog = this;
        synchronized (bundleDependencyViewConfigurationDialog) {
            if (this.builder == null) {
                this.setBuilder(new BundleDependencyCompositeBuilder());
            }
        }
        return this.builder;
    }

    private Label getErrorImageLabel() {
        return this.errorImageLabel;
    }

    private Label getErrorMessageLabel() {
        return this.errorMessageLabel;
    }

    protected Point getInitialSize() {
        Point point = super.getInitialSize();
        point.x = (int)((double)point.x * 1.4);
        return point;
    }

    private IBundleDependencyModel getModel() {
        return this.model;
    }

    private IBundleDependencyPreferences getPreferences() {
        Activator activator = Activator.getDefault();
        IBundleDependencyPreferences preferences = activator.getPreferences();
        return preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SelectionListener getSelectionListener() {
        BundleDependencyViewConfigurationDialog bundleDependencyViewConfigurationDialog = this;
        synchronized (bundleDependencyViewConfigurationDialog) {
            if (this.selectionListener == null) {
                SelectionListener listener = this.createSelectionListener();
                this.setSelectionListener(listener);
            }
        }
        return this.selectionListener;
    }

    private Button getUseDefaultsButton() {
        return this.useDefaultsButton;
    }

    private void handleModifiedText() {
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        boolean valid = builder.isValid();
        this.enableUseDefaultsButton(valid);
        this.enableOkButton(valid);
        this.setDefaultButton();
        this.updateErrorMessageLabel();
    }

    private void handleUsePreferencesButtonSelected() {
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        IBundleDependencyPreferences preferences = this.getPreferences();
        String host = preferences.getHost();
        builder.setHost(host);
        String port = preferences.getPort();
        builder.setPort(port);
        String servletAlias = preferences.getServletAlias();
        builder.setServletAlias(servletAlias);
        String pollFrequency = preferences.getPollFrequency();
        builder.setPollFrequency(pollFrequency);
    }

    protected void helpPressed() {
        UiUtility utility = UiUtility.getInstance();
        IWorkbenchHelpSystem helpSystem = utility.getHelpSystem();
        helpSystem.displayHelp(HELP_CONTEXT_ID);
    }

    private void hookupModifyListener() {
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        ModifyListener listener = this.createModifyListener();
        builder.addModifyListener(listener);
    }

    private void initialize() {
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        IBundleDependencyModel model = this.getModel();
        String host = model.getHost();
        builder.setHost(host);
        String port = model.getPort();
        builder.setPort(port);
        String servletAlias = model.getServletAlias();
        builder.setServletAlias(servletAlias);
        String pollFrequency = model.getPollFrequency();
        builder.setPollFrequency(pollFrequency);
        this.handleModifiedText();
    }

    private boolean isDirty() {
        String modelPollFrequency;
        String modelServletAlias;
        String modelPort;
        String modelHost;
        boolean dirty;
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        IBundleDependencyModel model = this.getModel();
        String host = builder.getHost();
        boolean bl = dirty = !host.equals(modelHost = model.getHost());
        if (dirty) {
            return true;
        }
        String port = builder.getPort();
        boolean bl2 = dirty = !port.equals(modelPort = model.getPort());
        if (dirty) {
            return true;
        }
        String servletAlias = builder.getServletAlias();
        boolean bl3 = dirty = !servletAlias.equals(modelServletAlias = model.getServletAlias());
        if (dirty) {
            return true;
        }
        String pollFrequency = builder.getPollFrequency();
        boolean bl4 = dirty = !pollFrequency.equals(modelPollFrequency = model.getPollFrequency());
        if (dirty) {
            return true;
        }
        return dirty;
    }

    private boolean isUsingPreferences() {
        String preferredPollFrequency;
        String preferredServletAlias;
        String preferredPort;
        String preferredHost;
        IBundleDependencyPreferences preferences = this.getPreferences();
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        String host = builder.getHost();
        boolean usingPreference = host.equals(preferredHost = preferences.getHost());
        if (!usingPreference) {
            return false;
        }
        String port = builder.getPort();
        usingPreference = port.equals(preferredPort = preferences.getPort());
        if (!usingPreference) {
            return false;
        }
        String servletAlias = builder.getServletAlias();
        usingPreference = servletAlias.equals(preferredServletAlias = preferences.getServletAlias());
        if (!usingPreference) {
            return false;
        }
        String pollFrequency = builder.getPollFrequency();
        usingPreference = pollFrequency.equals(preferredPollFrequency = preferences.getPollFrequency());
        return usingPreference;
    }

    protected void okPressed() {
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        String host = builder.getHost();
        this.setHost(host);
        String port = builder.getPort();
        this.setPort(port);
        String servletAlias = builder.getServletAlias();
        this.setServletAlias(servletAlias);
        String pollFrequency = builder.getPollFrequency();
        this.setPollFrequency(pollFrequency);
        super.okPressed();
    }

    private void setBuilder(BundleDependencyCompositeBuilder builder) {
        this.builder = builder;
    }

    private void setDefaultButton() {
        Button button = this.getButton(0);
        boolean enabled = button.isEnabled();
        if (!enabled) {
            button = this.getButton(1);
            enabled = button.isEnabled();
        }
        if (!enabled) {
            return;
        }
        Shell shell = this.getShell();
        shell.setDefaultButton(button);
    }

    private void setErrorImageLabel(Label errorImageLabel) {
        this.errorImageLabel = errorImageLabel;
    }

    private void setErrorMessageLabel(Label errorMessageLabel) {
        this.errorMessageLabel = errorMessageLabel;
    }

    private void setHost(String host) {
        IBundleDependencyModel model = this.getModel();
        model.setHost(host);
    }

    private void setModel(IBundleDependencyModel model) {
        this.model = model;
    }

    private void setPollFrequency(String pollFrequency) {
        IBundleDependencyModel model = this.getModel();
        model.setPollFrequency(pollFrequency);
    }

    private void setPort(String port) {
        IBundleDependencyModel model = this.getModel();
        model.setPort(port);
    }

    private void setSelectionListener(SelectionListener selectionListener) {
        this.selectionListener = selectionListener;
    }

    private void setServletAlias(String servletAlias) {
        IBundleDependencyModel model = this.getModel();
        model.setServletAlias(servletAlias);
    }

    private void setUseDefaultsButton(Button useDefaultsButton) {
        this.useDefaultsButton = useDefaultsButton;
    }

    private void updateErrorMessageLabel() {
        BundleDependencyCompositeBuilder builder = this.getBuilder();
        String message = builder.getErrorMessage();
        Image image = null;
        if (message == null) {
            message = new String();
        } else {
            image = Dialog.getImage((String)"dialog_message_error_image");
        }
        Label label = this.getErrorMessageLabel();
        label.setText(message);
        label = this.getErrorImageLabel();
        label.setImage(image);
    }
}

