/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.FileManager;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.api.IFileManager;
import org.eclipse.soda.sat.plugin.activator.ui.internal.util.api.IManifestFileManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestFileManager
extends FileManager
implements IManifestFileManager {
    private Manifest manifest;
    private Map<String, String> updates;
    private Set<String> deletions;
    private Comparator<Attributes.Name> comparator;

    public ManifestFileManager(IFile file) {
        super(file);
        this.setUpdates(new HashMap<String, String>(37));
        this.setDeletions(new HashSet<String>(37));
    }

    private void applyDeletions() throws CoreException, IOException {
        Manifest manifest = this.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        Set<String> set = this.getDeletions();
        boolean empty = set.isEmpty();
        if (empty) {
            return;
        }
        for (String deletion : set) {
            Attributes.Name key = new Attributes.Name(deletion);
            attributes.remove(key);
        }
        set.clear();
    }

    private void applyUpdates() throws CoreException, IOException {
        Manifest manifest = this.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        Map<String, String> map = this.getUpdates();
        boolean empty = map.isEmpty();
        if (empty) {
            return;
        }
        Set<String> set = map.keySet();
        for (String key : set) {
            String value = map.get(key);
            attributes.putValue(key, value);
        }
        map.clear();
    }

    private Comparator<Attributes.Name> createComparator() {
        return new Comparator<Attributes.Name>(){

            @Override
            public int compare(Attributes.Name name1, Attributes.Name name2) {
                if (Attributes.Name.MANIFEST_VERSION.equals(name1)) {
                    return -1;
                }
                if (Attributes.Name.MANIFEST_VERSION.equals(name2)) {
                    return 1;
                }
                String value1 = name1.toString();
                String value2 = name2.toString();
                int result = this.compare(value1, value2);
                return result;
            }

            @Override
            private int compare(String value1, String value2) {
                int result = value1.compareTo(value2);
                return result;
            }
        };
    }

    private Manifest createManifest() throws CoreException, IOException {
        Manifest manifest;
        IFile file = this.getFile();
        InputStream stream = null;
        try {
            stream = file.getContents(true);
            manifest = new Manifest(stream);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String key) {
        Object lock;
        Set<String> set = this.getDeletions();
        Object object = lock = this.getLock();
        synchronized (object) {
            set.add(key);
            this.setDirty(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comparator<Attributes.Name> getComparator() {
        Object lock;
        Object object = lock = this.getLock();
        synchronized (object) {
            if (this.comparator == null) {
                Comparator<Attributes.Name> comparator = this.createComparator();
                this.setComparator(comparator);
            }
        }
        return this.comparator;
    }

    @Override
    protected String getContents() throws CoreException, IOException {
        String contents = this.toString();
        return contents;
    }

    private Set<String> getDeletions() {
        return this.deletions;
    }

    @Override
    public String getHeader(String header) throws CoreException, IOException {
        Manifest manifest = this.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        String value = attributes.getValue(header);
        if (value == null) {
            return null;
        }
        value = value.trim();
        return value;
    }

    private List<Attributes.Name> getKeys() throws Exception {
        Manifest manifest = this.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        Set<Object> set = attributes.keySet();
        int size = set.size();
        ArrayList<Attributes.Name> keys = new ArrayList<Attributes.Name>(size);
        for (Object object : set) {
            Attributes.Name name = (Attributes.Name)object;
            keys.add(name);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws CoreException, IOException {
        ManifestFileManager manifestFileManager = this;
        synchronized (manifestFileManager) {
            if (this.manifest == null) {
                Manifest manifest = this.createManifest();
                this.setManifest(manifest);
            }
        }
        return this.manifest;
    }

    private List<Attributes.Name> getSortedKeys() throws Exception {
        List<Attributes.Name> keys = this.getKeys();
        Comparator<Attributes.Name> comparator = this.getComparator();
        Collections.sort(keys, comparator);
        return keys;
    }

    private Map<String, String> getUpdates() {
        return this.updates;
    }

    private String getValue(Attributes.Name key) throws CoreException, IOException {
        Manifest manifest = this.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        String value = attributes.getValue(key);
        return value;
    }

    @Override
    protected void postApplyChanges() throws CoreException, IOException {
        Manifest manifest = this.createManifest();
        this.setManifest(manifest);
    }

    @Override
    protected void preApplyChanges() throws CoreException, IOException {
        this.applyDeletions();
        this.applyUpdates();
    }

    @Override
    protected void printOn(StringBuffer buffer) throws Exception {
        List<Attributes.Name> list = this.getSortedKeys();
        for (Attributes.Name key : list) {
            this.printOn(buffer, key);
        }
    }

    private void printOn(StringBuffer buffer, Attributes.Name key) throws CoreException, IOException {
        buffer.append(key);
        buffer.append(':');
        String value = this.getValue(key);
        this.printOn(buffer, value);
        buffer.append(IFileManager.LINE_SEPARATOR);
    }

    private void printOn(StringBuffer buffer, String value) {
        String delimiter = ",";
        StringTokenizer tokenizer = new StringTokenizer(value, delimiter);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            buffer.append(' ');
            buffer.append(token);
            if (!tokenizer.hasMoreTokens()) continue;
            buffer.append(delimiter);
            buffer.append(IFileManager.LINE_SEPARATOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, String value) {
        Object lock;
        Map<String, String> map = this.getUpdates();
        Object object = lock = this.getLock();
        synchronized (object) {
            map.put(key, value);
            this.setDirty(true);
        }
    }

    private void setComparator(Comparator<Attributes.Name> comparator) {
        this.comparator = comparator;
    }

    private void setDeletions(Set<String> deletions) {
        this.deletions = deletions;
    }

    private void setManifest(Manifest manifest) {
        this.manifest = manifest;
    }

    private void setUpdates(Map<String, String> updates) {
        this.updates = updates;
    }
}

