/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal.pages;

import java.util.List;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.soda.sat.plugin.activator.ui.internal.bundle.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceFolderViewerFilter
extends ViewerFilter {
    private List<Class<?>> types;

    SourceFolderViewerFilter(List<Class<?>> types) {
        this.setTypes(types);
    }

    private List<Class<?>> getTypes() {
        return this.types;
    }

    private void logError(Throwable throwable) {
        Activator activator = Activator.getDefault();
        activator.log(4, throwable);
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)element;
            try {
                int kind = root.getKind();
                boolean match = kind == 1;
                return match;
            }
            catch (JavaModelException exception) {
                this.logError(exception);
            }
        } else {
            List<Class<?>> types = this.getTypes();
            for (Class<?> type : types) {
                boolean match = type.isInstance(element);
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    private void setTypes(List<Class<?>> types) {
        this.types = types;
    }
}

