/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.plugin.activator.ui.internal;

import org.eclipse.soda.sat.plugin.activator.ui.internal.nls.Messages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class TypeScopePreferencesCompositeBuilder {
    public static final String TYPE_SCOPE_KEY = "TypeScopePreferencesCompositeBuilder.TypeScope";
    public static final String LIMIT_SERVICES_TO_INTERFACE_TYPES_KEY = "TypeScopePreferencesCompositeBuilder.LimitServicesToInterfaceTypes";
    public static final String LIMIT_SERVICES_TO_TYPES_VISIBLE_TO_THE_PROJECT_KEY = "TypeScopePreferencesCompositeBuilder.LimitServicesToTypesVisibleToTheProject";
    private int groupStyle;
    private Button limitServicesToInterfaceTypesButton;
    private Button limitServicesToTypesVisibleToProjectButton;

    public TypeScopePreferencesCompositeBuilder() {
        this.setGroupStyle(0);
    }

    public void addLimitServicesToInterfaceTypesSelectionListener(SelectionListener listener) {
        Button button = this.getLimitServicesToInterfaceTypesButton();
        button.addSelectionListener(listener);
    }

    public void addLimitServicesToTypesVisibleToProjectSelectionListener(SelectionListener listener) {
        Button button = this.getLimitServicesToTypesVisibleToProjectButton();
        button.addSelectionListener(listener);
    }

    public void build(Composite parent) {
        String text = Messages.getString(TYPE_SCOPE_KEY);
        Group composite = this.createGroup(parent, text);
        this.buildLimitServicesToInterfacesTypes((Composite)composite);
        this.buildLimitServicesToTypesVisibleToProject((Composite)composite);
    }

    private Button buildCheckbox(Composite parent, String text) {
        Button button = new Button(parent, 32);
        button.setText(text);
        return button;
    }

    private void buildLimitServicesToInterfacesTypes(Composite parent) {
        String value = Messages.getString(LIMIT_SERVICES_TO_INTERFACE_TYPES_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setLimitServicesToInterfaceTypesButton(button);
    }

    private void buildLimitServicesToTypesVisibleToProject(Composite parent) {
        String value = Messages.getString(LIMIT_SERVICES_TO_TYPES_VISIBLE_TO_THE_PROJECT_KEY);
        Button button = this.buildCheckbox(parent, value);
        this.setLimitServicesToTypesVisibleToProjectButton(button);
    }

    private Group createGroup(Composite parent, String text) {
        return this.createGroup(parent, text, 1);
    }

    private Group createGroup(Composite parent, String text, int columns) {
        Group group = new Group(parent, 0);
        group.setText(text);
        GridLayout layout = new GridLayout(columns, false);
        group.setLayout((Layout)layout);
        int style = this.getGroupStyle();
        GridData gridData = new GridData(style);
        group.setLayoutData((Object)gridData);
        return group;
    }

    public int getGroupStyle() {
        return this.groupStyle;
    }

    public boolean getLimitServicesToInterfaceTypes() {
        Button button = this.getLimitServicesToInterfaceTypesButton();
        boolean state = button.getSelection();
        return state;
    }

    private Button getLimitServicesToInterfaceTypesButton() {
        return this.limitServicesToInterfaceTypesButton;
    }

    public boolean getLimitServicesToTypesVisibleToProject() {
        Button button = this.getLimitServicesToTypesVisibleToProjectButton();
        boolean state = button.getSelection();
        return state;
    }

    private Button getLimitServicesToTypesVisibleToProjectButton() {
        return this.limitServicesToTypesVisibleToProjectButton;
    }

    public void removeLimitServicesToInterfaceTypesSelectionListener(SelectionListener listener) {
        Button button = this.getLimitServicesToInterfaceTypesButton();
        button.removeSelectionListener(listener);
    }

    public void removeLimitServicesToTypesVisibleToProjectSelectionListener(SelectionListener listener) {
        Button button = this.getLimitServicesToTypesVisibleToProjectButton();
        button.removeSelectionListener(listener);
    }

    public void setGroupStyle(int groupStyle) {
        this.groupStyle = groupStyle;
    }

    public void setLimitServicesToInterfaceTypes(boolean state) {
        Button button = this.getLimitServicesToInterfaceTypesButton();
        button.setSelection(state);
    }

    private void setLimitServicesToInterfaceTypesButton(Button limitServicesToInterfaceTypesButton) {
        this.limitServicesToInterfaceTypesButton = limitServicesToInterfaceTypesButton;
    }

    public void setLimitServicesToTypesVisibleToProject(boolean state) {
        Button button = this.getLimitServicesToTypesVisibleToProjectButton();
        button.setSelection(state);
    }

    private void setLimitServicesToTypesVisibleToProjectButton(Button limitServicesToTypesVisibleToProjectButton) {
        this.limitServicesToTypesVisibleToProjectButton = limitServicesToTypesVisibleToProjectButton;
    }
}

