/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.soda.sat.core.util.Assertion;

public class CollectionUtility {
    private static final CollectionUtility INSTANCE = new CollectionUtility();

    public static CollectionUtility getInstance() {
        return INSTANCE;
    }

    private CollectionUtility() {
    }

    private void checkArgumentsAreNotNull(Object collection, Object accessor) {
        Assertion.checkArgumentIsNotNull(collection, "collection");
        Assertion.checkArgumentIsNotNull(accessor, "accessor");
    }

    public List collect(Collection collection, Accessor accessor) {
        this.checkArgumentsAreNotNull(collection, accessor);
        int size = collection.size();
        ArrayList<Object> list = new ArrayList<Object>(size);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            Object value = accessor.get(item);
            list.add(value);
        }
        return list;
    }

    public Object detect(Collection collection, Accessor accessor) {
        this.checkArgumentsAreNotNull(collection, accessor);
        Object result = null;
        Iterator iterator = collection.iterator();
        while (result == null && iterator.hasNext()) {
            Object item = iterator.next();
            Object value = accessor.get(item);
            if (value == null) continue;
            result = item;
        }
        return result;
    }

    public int estimateHashedCollectionSize(int capacity) {
        return this.estimateHashedCollectionSize(capacity, 0.75f);
    }

    public int estimateHashedCollectionSize(int capacity, float loadFactor) {
        if (capacity <= 0) {
            return 0;
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException();
        }
        int size = (int)((float)capacity / loadFactor) + 1;
        return size;
    }

    public Object inject(Collection collection, Object value, InjectionAccessor accessor) {
        this.checkArgumentsAreNotNull(collection, accessor);
        Assertion.checkArgumentIsNotNull(value, "value");
        Iterator iterator = collection.iterator();
        Object result = value;
        while (iterator.hasNext()) {
            Object item = iterator.next();
            result = accessor.get(result, item);
        }
        return result;
    }

    private List iterate(Collection collection, Accessor accessor, boolean select) {
        this.checkArgumentsAreNotNull(collection, accessor);
        int size = collection.size();
        ArrayList<Object> list = new ArrayList<Object>(size);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            Object value = accessor.get(item);
            if (select && value == null || !select && value != null) continue;
            list.add(value);
        }
        list.trimToSize();
        return list;
    }

    public List reject(Collection collection, Accessor accessor) {
        return this.iterate(collection, accessor, false);
    }

    public List select(Collection collection, Accessor accessor) {
        return this.iterate(collection, accessor, true);
    }

    public List toList(Enumeration enumeration) {
        ArrayList list = new ArrayList(25);
        list = (ArrayList)this.toList(enumeration, list);
        list.trimToSize();
        return list;
    }

    public List toList(Enumeration enumeration, List list) {
        Assertion.checkArgumentIsNotNull(enumeration, "enumeration");
        Assertion.checkArgumentIsNotNull(list, "list");
        while (enumeration.hasMoreElements()) {
            Object element = enumeration.nextElement();
            list.add(element);
        }
        return list;
    }

    public static interface Accessor {
        public Object get(Object var1);
    }

    public static interface InjectionAccessor {
        public Object get(Object var1, Object var2);
    }
}

