/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.util.Enumeration;
import org.eclipse.soda.sat.core.framework.interfaces.ITokenizer;
import org.eclipse.soda.sat.core.internal.nls.Messages;
import org.eclipse.soda.sat.core.internal.util.SynchronizedTokenizer;
import org.eclipse.soda.sat.core.util.Assertion;

public class Tokenizer
implements Enumeration,
ITokenizer {
    private static final String INDEX_PARAMETER_MUST_BE_POSITIVE_INTEGER_KEY = "Tokenizer.IndexParameterMustBePositiveInteger";
    private static final char COMMA = ',';
    private char delimiter;
    private int index;
    private String token;
    private String value;
    private boolean emptyTokenIsValid;
    private boolean trimToken;

    public Tokenizer(String value) {
        this(value, ',');
    }

    public Tokenizer(String value, char delimiter) {
        this(value, delimiter, 0);
    }

    public Tokenizer(String value, char delimiter, int index) {
        this.setValue(value);
        this.setDelimiter(delimiter);
        this.setToken(null);
        this.checkIndex(index);
        this.setIndex(index);
        this.setEmptyTokenIsValid(true);
        this.setTrimToken(true);
    }

    public Tokenizer(String value, int index) {
        this(value, ',', index);
    }

    private void checkIndex(int index) {
        if (index >= 0) {
            return;
        }
        String message = Messages.getString(INDEX_PARAMETER_MUST_BE_POSITIVE_INTEGER_KEY);
        throw new IllegalArgumentException(message);
    }

    private char getDelimiter() {
        return this.delimiter;
    }

    private boolean getEmptyTokenIsValid() {
        return this.emptyTokenIsValid;
    }

    private int getIndex() {
        return this.index;
    }

    private String getNextToken() {
        String token = null;
        String value = this.getValue();
        int length = value.length();
        int start = this.getIndex();
        boolean trim = this.getTrimToken();
        while (start < length && !this.isTokenValid(token)) {
            char delimiter = this.getDelimiter();
            int stop = value.indexOf(delimiter, start);
            if (stop == -1) {
                token = value.substring(start);
                start = length;
            } else {
                token = value.substring(start, stop);
                start = stop + 1;
            }
            this.setIndex(start);
            if (!trim) continue;
            token = token.trim();
        }
        return token;
    }

    private String getToken() {
        if (this.token == null) {
            this.token = this.getNextToken();
        }
        return this.token;
    }

    private boolean getTrimToken() {
        return this.trimToken;
    }

    private String getValue() {
        return this.value;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        String token = this.getToken();
        boolean more = token != null;
        return more;
    }

    private boolean isTokenValid(String token) {
        if (token == null) {
            return false;
        }
        int length = token.length();
        if (length != 0) {
            return true;
        }
        boolean valid = this.getEmptyTokenIsValid();
        return valid;
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        String token = this.getToken();
        this.setToken(null);
        return token;
    }

    private void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setEmptyTokenIsValid(boolean emptyTokenIsValid) {
        this.emptyTokenIsValid = emptyTokenIsValid;
    }

    private void setIndex(int index) {
        this.index = index;
    }

    private void setToken(String token) {
        this.token = token;
    }

    public void setTrimToken(boolean trimToken) {
        this.trimToken = trimToken;
    }

    private void setValue(String value) {
        Assertion.checkArgumentIsNotNull(value, "value");
        this.value = value;
    }

    public ITokenizer toSynchronizedTokenizer() {
        return new SynchronizedTokenizer(this);
    }
}

