/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.util;

import java.util.Arrays;
import org.eclipse.soda.sat.core.framework.interfaces.ICharBuffer;
import org.eclipse.soda.sat.core.internal.util.SynchronizedCharBuffer;
import org.eclipse.soda.sat.core.util.Assertion;
import org.eclipse.soda.sat.core.util.MessageFormatter;

public class CharBuffer
implements ICharBuffer {
    private static final String UNKNOWN_GROW_STYLE = "CharBuffer.UnknownGrowStyle";
    private static final int DEFAULT_INITIAL_CAPACITY = 25;
    private char[] contents;
    private int initialCapacity;
    private int growPercentage;
    private short growStyle;
    private int index;

    public CharBuffer(int initialCapacity) {
        int capacity = this.validateInitialCapacity(initialCapacity);
        this.setInitialCapacity(capacity);
        this.setContents(this.createContents(capacity + 1));
        this.setGrowPercentage(100);
        this.setGrowStyle((short)0);
    }

    public ICharBuffer append(boolean booleanValue) {
        Boolean wrapper = booleanValue ? Boolean.TRUE : Boolean.FALSE;
        String value = wrapper.toString();
        return this.append(value);
    }

    public ICharBuffer append(char charValue) {
        this.ensureCapacity(1);
        char[] contents = this.getContents();
        int index = this.getIndex();
        contents[index] = charValue;
        this.setIndex(index + 1);
        return this;
    }

    public ICharBuffer append(char[] array) {
        return this.append(array, 0, array.length);
    }

    public ICharBuffer append(char[] array, int start, int length) {
        this.ensureCapacity(length);
        char[] contents = this.getContents();
        int index = this.getIndex();
        int stop = start + length;
        int i = start;
        while (i < stop) {
            contents[index] = array[i];
            ++index;
            ++i;
        }
        this.setIndex(index);
        return this;
    }

    public ICharBuffer append(double doubleValue) {
        String value = Double.toString(doubleValue);
        return this.append(value);
    }

    public ICharBuffer append(float floatValue) {
        String value = Float.toString(floatValue);
        return this.append(value);
    }

    public ICharBuffer append(int intValue) {
        String value = Integer.toString(intValue);
        return this.append(value);
    }

    public ICharBuffer append(long longValue) {
        String value = Long.toString(longValue);
        return this.append(value);
    }

    public ICharBuffer append(Object object) {
        String value = String.valueOf(object);
        ICharBuffer buffer = this.append(value);
        return buffer;
    }

    public ICharBuffer append(String value) {
        if (value == null) {
            String nullValue = String.valueOf(value);
            ICharBuffer buffer = this.append(nullValue);
            return buffer;
        }
        int length = value.length();
        this.ensureCapacity(length);
        char[] contents = this.getContents();
        int index = this.getIndex();
        value.getChars(0, length, contents, index);
        this.setIndex(index + length);
        return this;
    }

    public int capacity() {
        char[] contents = this.getContents();
        int capacity = contents.length - 1;
        return capacity;
    }

    public char charAt(int i) {
        char[] contents = this.getContents();
        char ch = contents[i];
        return ch;
    }

    private char[] copy(char[] source, char[] target, int length) {
        System.arraycopy(source, 0, target, 0, length);
        return target;
    }

    private char[] createContents(int size) {
        return new char[size];
    }

    private void ensureCapacity(int length) {
        char[] contents = this.getContents();
        int index = this.getIndex();
        int minimumSize = index + length;
        if (minimumSize < contents.length) {
            return;
        }
        int size = contents.length;
        size += minimumSize - contents.length + 1;
        int growBy = this.getGrowBy();
        contents = this.growContents(size += growBy);
        this.setContents(contents);
    }

    private char[] getContents() {
        return this.contents;
    }

    private int getGrowBy() {
        int capacity = this.getGrowByCapacity();
        int percentage = this.getGrowPercentage();
        int size = capacity * percentage / 100;
        return size;
    }

    private int getGrowByCapacity() {
        int value;
        short style = this.getGrowStyle();
        if (style == 0) {
            value = this.getInitialCapacity();
        } else if (style == 1) {
            char[] contents = this.getContents();
            value = contents.length;
        } else {
            String styleValue = String.valueOf(style);
            String message = MessageFormatter.format(UNKNOWN_GROW_STYLE, styleValue);
            throw new RuntimeException(message);
        }
        return value;
    }

    public int getGrowPercentage() {
        return this.growPercentage;
    }

    public short getGrowStyle() {
        return this.growStyle;
    }

    private int getIndex() {
        return this.index;
    }

    private int getInitialCapacity() {
        return this.initialCapacity;
    }

    public String getValue() {
        char[] contents = this.getContents();
        int length = this.getIndex();
        String value = new String(contents, 0, length);
        return value;
    }

    private char[] growContents(int size) {
        char[] source = this.getContents();
        char[] target = this.createContents(size);
        int index = this.getIndex();
        int length = index < source.length ? index : source.length;
        this.copy(source, target, length);
        this.setIndex(length);
        return target;
    }

    public int length() {
        int length = this.getIndex();
        return length;
    }

    public void setChar(int i, char ch) {
        char[] contents = this.getContents();
        contents[i] = ch;
    }

    private void setContents(char[] contents) {
        this.contents = contents;
    }

    public void setGrowPercentage(int growPercentage) {
        Assertion.checkRange(growPercentage, "growPercentage", 1L, Integer.MAX_VALUE);
        this.growPercentage = growPercentage;
    }

    public void setGrowStyle(short growStyle) {
        this.growStyle = growStyle;
    }

    private void setIndex(int index) {
        this.index = index;
    }

    private void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public void setLength(int length) {
        int index = this.getIndex();
        if (length == index) {
            return;
        }
        if (length < index) {
            char[] contents = this.getContents();
            char ch = '\u0000';
            Arrays.fill(contents, length, index, ch);
        } else {
            this.ensureCapacity(length);
        }
        this.setIndex(length);
    }

    public char[] toArray() {
        char[] source = this.getContents();
        int length = this.getIndex();
        char[] target = new char[length];
        this.copy(source, target, length);
        return target;
    }

    public char[] toArray(char[] target) {
        char[] source = this.getContents();
        int length = this.getIndex();
        char[] result = target == null || target.length < length ? this.toArray() : this.copy(source, target, length);
        return result;
    }

    public String toString() {
        return this.getValue();
    }

    public ICharBuffer toSynchronizedCharBuffer() {
        return new SynchronizedCharBuffer(this);
    }

    private int validateInitialCapacity(int initialCapacity) {
        return initialCapacity > 0 ? initialCapacity : 25;
    }
}

