/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.sat.core.internal.framework.bundle.cm;

import java.util.Dictionary;
import org.eclipse.soda.sat.core.framework.interfaces.IBundleActivationManager;
import org.eclipse.soda.sat.core.util.FactoryUtility;

class ConfigurationData {
    private String pid;
    private IBundleActivationManager bundleActivationManager;
    private Object object;
    private Dictionary oldProperties;
    private Dictionary properties;

    ConfigurationData(Dictionary properties) {
        this.setProperties(properties);
        this.setPid(this.createPid());
        this.setBundleActivationManager(this.createBundleActivationManager());
    }

    private IBundleActivationManager createBundleActivationManager() {
        String pid = this.getPid();
        FactoryUtility utility = FactoryUtility.getInstance();
        IBundleActivationManager manager = utility.createBundleActivationManager(pid);
        return manager;
    }

    private String createPid() {
        Dictionary properties = this.getProperties();
        String pid = (String)properties.get("service.pid");
        return pid;
    }

    IBundleActivationManager getBundleActivationManager() {
        return this.bundleActivationManager;
    }

    Object getObject() {
        return this.object;
    }

    Dictionary getOldProperties() {
        return this.oldProperties;
    }

    private String getPid() {
        return this.pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dictionary getProperties() {
        ConfigurationData configurationData = this;
        synchronized (configurationData) {
            return this.properties;
        }
    }

    private void setBundleActivationManager(IBundleActivationManager bundleActivationManager) {
        this.bundleActivationManager = bundleActivationManager;
    }

    void setObject(Object object) {
        this.object = object;
    }

    private void setOldProperties(Dictionary oldProperties) {
        this.oldProperties = oldProperties;
    }

    private void setPid(String pid) {
        this.pid = pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProperties(Dictionary properties) {
        ConfigurationData configurationData = this;
        synchronized (configurationData) {
            this.setOldProperties(this.properties);
            this.properties = properties;
        }
    }
}

