/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.rfid.inventory.benchmark.servlet;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.soda.dk.device.servlet.DeviceServletContext;
import org.eclipse.soda.dk.notification.service.NotificationListener;
import org.eclipse.soda.dk.notification.service.NotificationService;
import org.eclipse.soda.dk.rfid.inventory.benchmark.servlet.IRfidInventoryBenchmarkReader;

public class RfidInventoryBenchmarkReader
implements IRfidInventoryBenchmarkReader,
NotificationListener {
    private String prefixTagReadingTopic;
    private String prefixTagReportTopic;
    private String prefixTagReadingGetTopic;
    private String prefixBenchmarkingTopic;
    private String prefixBenchmarkingGetTopic;
    private String prefixBenchmarkingWriteTopic;
    private String prefixBenchmarkReportTopic;
    private String prefixControlBitChangeRequestTopic;
    private NotificationService notificationService;
    private String prefix;
    private boolean benchmarkEnabled;
    private boolean tagreadStarted;
    private List benchmarkReports;
    private Map controlBitsMap;
    private Byte tagReadState_wait = new Byte(0);
    private Byte benchMarkingState_wait = new Byte(0);
    private Byte benchMarkRunStopped_wait = new Byte(0);
    private boolean benchmarkRunStopped = true;
    private int tagReportsCount = 0;
    private int currentRunTotalCycle = 0;
    private int currentRunFinishedCycles = 0;
    private String latestTagReportTimestamp;

    public RfidInventoryBenchmarkReader(String prefix, NotificationService notificationService) {
        this.prefix = prefix;
        this.notificationService = notificationService;
        this.prefixTagReportTopic = String.valueOf(this.prefix) + "/RfidInventory/TagReport";
        this.prefixTagReadingTopic = String.valueOf(this.prefix) + "/RfidInventory/TagReading";
        this.prefixTagReadingGetTopic = String.valueOf(this.prefix) + "/RfidInventory/TagReading/get";
        this.prefixBenchmarkingTopic = String.valueOf(this.prefix) + "/RfidInventoryBenchmark/Benchmarking";
        this.prefixBenchmarkingGetTopic = String.valueOf(this.prefix) + "/RfidInventoryBenchmark/Benchmarking/get";
        this.prefixBenchmarkingWriteTopic = String.valueOf(this.prefix) + "/RfidInventoryBenchmark/Benchmarking/write";
        this.prefixBenchmarkReportTopic = String.valueOf(this.prefix) + "/RfidInventoryBenchmark/BenchmarkReport";
        this.prefixControlBitChangeRequestTopic = String.valueOf(this.prefix) + "/Control/BitsChangeRequest/execute";
        this.subscribeTopics();
        this.requestStates();
    }

    protected void benchmarkReportReceived(Map benchmarkReport) {
        this.getBenchmarkReports().add(benchmarkReport);
    }

    public void clearBenchmarkReports() {
        this.tagReportsCount = 0;
        this.setCurrentRunTotalCycle(0);
        this.setCurrentRunFinishedCycles(0);
        this.getBenchmarkReports().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void controlTagRead(Boolean state) {
        this.sendRequest(this.prefixControlBitChangeRequestTopic, this.getControlBitsMap("b1", state));
        Byte by = this.tagReadState_wait;
        synchronized (by) {
            if (this.isTagreadStarted() != state.booleanValue()) {
                try {
                    this.tagReadState_wait.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void displayBenchmarkDetailReports(DeviceServletContext context, int serialNum) {
        List reports = this.getBenchmarkDetailReports(serialNum);
        if (reports == null) {
            context.addEntity("message", (Object)("SerialNum " + serialNum + " doesn't exist."));
            context.template("error");
            return;
        }
        context.addEntity("Reader", (Object)this.getPrefix());
        context.addEntity("serialnum", (Object)new Integer(serialNum));
        context.template("detail_report_begin");
        int i = 0;
        while (i < reports.size()) {
            Map report = (Map)reports.get(i);
            context.addEntity("serialnum", (Object)String.valueOf(i + 1));
            context.addEntities(report);
            context.template("detail_report_entry");
            ++i;
        }
        context.template("report_end");
    }

    public String getBenchmarkDetailReportStrin(int serialNum) {
        return null;
    }

    public List getBenchmarkDetailReports(int serialNum) {
        List reports = this.getBenchmarkReports();
        int i = 0;
        while (i < reports.size()) {
            Map report = (Map)reports.get(i);
            if (serialNum == ((Number)report.get("serialnum")).intValue()) {
                return (List)report.get("tags");
            }
            ++i;
        }
        return null;
    }

    public void getBenchmarkReport_ajax(DeviceServletContext context) {
        List benchmarkReports = this.getBenchmarkReports();
        context.addEntity("BenchmarkTestStatus", (Object)(this.isBenchmarkRunStopped() ? "STOPPED" : "STARTED"));
        context.addEntity("Cycles", (Object)(String.valueOf(this.getCurrentRunFinishedCycles()) + "/" + this.getCurrentRunTotalCycle()));
        context.addEntity("TagReadStatus", (Object)(this.isTagreadStarted() ? "STARTED" : "STOPPED"));
        context.addEntity("TagReportsCount", (Object)String.valueOf(this.tagReportsCount));
        context.addEntity("LatestReportTime", (Object)this.getLatestTagReportTimestamp());
        context.template("benchmark_report_begin");
        int i = 0;
        while (i < benchmarkReports.size()) {
            context.addEntities((Map)benchmarkReports.get(i));
            context.addEntity("Reader", (Object)this.getPrefix());
            context.template("benchmark_report_entry");
            ++i;
        }
        context.template("report_end");
    }

    public List getBenchmarkReports() {
        if (this.benchmarkReports == null) {
            this.benchmarkReports = new ArrayList();
        }
        return this.benchmarkReports;
    }

    protected Map getControlBitsMap(String bit, Boolean state) {
        if (this.controlBitsMap == null) {
            this.controlBitsMap = new HashMap();
        }
        this.controlBitsMap.clear();
        this.controlBitsMap.put(bit, state);
        return this.controlBitsMap;
    }

    public int getCurrentRunFinishedCycles() {
        return this.currentRunFinishedCycles;
    }

    public int getCurrentRunTotalCycle() {
        return this.currentRunTotalCycle;
    }

    public String getLatestTagReportTimestamp() {
        if (this.latestTagReportTimestamp == null) {
            this.latestTagReportTimestamp = "";
        }
        return this.latestTagReportTimestamp;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isBenchmarkEnabled() {
        return this.benchmarkEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBenchmarkRunStopped() {
        Byte by = this.benchMarkRunStopped_wait;
        synchronized (by) {
            return this.benchmarkRunStopped;
        }
    }

    public boolean isTagreadStarted() {
        return this.tagreadStarted;
    }

    public void notificationReceived(String externalKey, Dictionary data) {
        Object value = data.get("value");
        if (externalKey.equals(this.prefixBenchmarkReportTopic)) {
            this.benchmarkReportReceived((Map)value);
        } else if (externalKey.equals(this.prefixTagReadingTopic)) {
            this.setTagreadState((Boolean)value);
        } else if (externalKey.equals(this.prefixBenchmarkingTopic)) {
            this.setBenchmarkState((Boolean)value);
        } else if (externalKey.equals(this.prefixTagReportTopic)) {
            ++this.tagReportsCount;
            this.setLatestTagReportTimestamp();
        }
    }

    private void requestStates() {
        this.sendRequest(this.prefixTagReadingGetTopic, "");
        this.sendRequest(this.prefixBenchmarkingGetTopic, "");
    }

    protected void sendRequest(String topic, Object request) {
        Hashtable<String, Object> value = new Hashtable<String, Object>();
        ((Dictionary)value).put("value", request);
        this.getNotificationService().broadcast(topic, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBenchmarkRunStopped(boolean benchmarkRunStopped) {
        Byte by = this.benchMarkRunStopped_wait;
        synchronized (by) {
            this.benchmarkRunStopped = benchmarkRunStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBenchmarkState(Boolean benchmarkEnabled) {
        Byte by = this.benchMarkingState_wait;
        synchronized (by) {
            if (benchmarkEnabled == null) {
                this.benchmarkEnabled = false;
                return;
            }
            this.benchmarkEnabled = benchmarkEnabled;
            this.benchMarkingState_wait.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBenchmarking(boolean state) {
        if (this.isBenchmarkEnabled() == state) {
            return;
        }
        this.sendRequest(this.prefixBenchmarkingWriteTopic, state ? Boolean.TRUE : Boolean.FALSE);
        Byte by = this.benchMarkingState_wait;
        synchronized (by) {
            while (true) {
                if (this.benchmarkEnabled == state) {
                    return;
                }
                try {
                    this.benchMarkingState_wait.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void setCurrentRunFinishedCycles(int currentRunFinishedCycles) {
        this.currentRunFinishedCycles = currentRunFinishedCycles;
    }

    public void setCurrentRunTotalCycle(int currentRunTotalCycle) {
        this.currentRunTotalCycle = currentRunTotalCycle;
    }

    public void setLatestTagReportTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date date = new Date();
        this.latestTagReportTimestamp = dateFormat.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTagreadState(Boolean tagreadStarted) {
        Byte by = this.tagReadState_wait;
        synchronized (by) {
            this.tagreadStarted = tagreadStarted == null ? false : tagreadStarted;
            this.tagReadState_wait.notifyAll();
        }
    }

    protected void singleBenchmarkRun(long duration, long delay) {
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException interruptedException) {}
        this.controlTagRead(Boolean.TRUE);
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {}
        this.controlTagRead(Boolean.FALSE);
    }

    public boolean startBenchmarkRuns(final int cycles, final long duration, final long delay) {
        if (this.isTagreadStarted() || !this.isBenchmarkRunStopped()) {
            return false;
        }
        this.setCurrentRunTotalCycle(cycles);
        this.setBenchmarkRunStopped(false);
        new Thread(new Runnable(){

            public void run() {
                int i = 0;
                while (i < cycles) {
                    if (RfidInventoryBenchmarkReader.this.isBenchmarkRunStopped()) break;
                    RfidInventoryBenchmarkReader.this.singleBenchmarkRun(duration, delay);
                    RfidInventoryBenchmarkReader.this.setCurrentRunFinishedCycles(i + 1);
                    ++i;
                }
                RfidInventoryBenchmarkReader.this.setBenchmarkRunStopped(true);
            }
        }).start();
        return true;
    }

    public void stopBenchmarkRuns() {
        this.setBenchmarkRunStopped(true);
    }

    private void subscribeTopics() {
        this.getNotificationService().register(this.prefixTagReportTopic, (NotificationListener)this);
        this.getNotificationService().register(this.prefixTagReadingTopic, (NotificationListener)this);
        this.getNotificationService().register(this.prefixBenchmarkingTopic, (NotificationListener)this);
        this.getNotificationService().register(this.prefixBenchmarkReportTopic, (NotificationListener)this);
    }
}

