/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.dk.signal;

import org.eclipse.soda.dk.message.service.MessageService;
import org.eclipse.soda.dk.multiplex.connection.service.ChannelService;
import org.eclipse.soda.dk.signal.DataSignal;
import org.eclipse.soda.dk.signal.service.SignalListener;
import org.eclipse.soda.dk.transform.service.TransformService;
import org.eclipse.soda.dk.transport.service.TransportService;

public class TransformSignal
extends DataSignal {
    private TransformService transform;

    public TransformSignal(String key, MessageService message, TransformService transform) {
        super(key, message);
        this.setTransform(transform);
    }

    public Object decode(Object value) {
        TransformService transform = this.getTransform();
        if (transform == null) {
            return value;
        }
        return transform.decode(value);
    }

    public TransformService getTransform() {
        return this.transform;
    }

    public void messageReceived(TransportService transportService, Object timestamp, MessageService message) {
        this.messageReceived(transportService, timestamp, null, message);
    }

    public void messageReceived(TransportService transportService, Object timestamp, ChannelService channel, MessageService message) {
        SignalListener signalListener = this.getSignalListener();
        if (signalListener != null) {
            try {
                MessageService myMessage = this.getMessage().matches(message);
                if (myMessage != null) {
                    this.fireSignalOccurred(signalListener, timestamp, channel, this.decode(myMessage.decodeMessage(message)));
                }
            }
            catch (RuntimeException exception) {
                this.handleError(exception, 1);
            }
        }
    }

    public void setTransform(TransformService transform) {
        this.transform = transform;
    }
}

