/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.profile.operation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.model.xml.XmlModel;
import org.eclipse.soda.devicekit.ui.operation.DeviceKitGenerateOperation;

public class ProfileOperation
extends DeviceKitGenerateOperation {
    public ProfileOperation(Map variables) {
        super(variables);
    }

    protected void addDkmlBody(IXmlElement element, int type) {
        switch (type) {
            case 0: {
                this.addProfileDkmlBody(element);
                break;
            }
            case 1: {
                this.addProfileTestDkmlBody(element);
            }
        }
    }

    protected void addProfileDkmlBody(IXmlElement dkmlElement) {
        IXmlElement element = dkmlElement.add("profile");
        boolean abstractState = this.createCommonTop(element, true);
        this.addGroup(element);
        if (!abstractState) {
            this.addCommonBundle(element);
        }
    }

    protected void addProfileTestDkmlBody(IXmlElement element) {
        IXmlElement test = element.add("profiletest");
        String name = this.getNameFull();
        this.addCommonTestTop(test);
        IXmlElement profile = test.add("profile");
        StringBuffer refBuffer = new StringBuffer(128);
        refBuffer.append(this.getProjectName());
        refBuffer.append("/dk/profile.xml#");
        refBuffer.append(name);
        profile.addAttribute("idref", refBuffer.toString());
        if (this.doGenerateTestcase()) {
            test.add("testcase");
        }
        this.addCommonBundle(test);
    }

    protected IFile createDkmlFile(int type, IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFile iFile;
        InputStream stream = null;
        try {
            String name = "profile.xml";
            if (type == 1) {
                name = "profile_test.xml";
            }
            XmlModel model = new XmlModel(name);
            this.populateTemplateModel(model, type);
            String contents = model.getContents();
            stream = new BufferedInputStream(new ByteArrayInputStream(contents.getBytes()));
            IFile file = folder.getFile(name);
            file.create(stream, true, monitor);
            iFile = file;
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }
        catch (IOException iOException) {}
        return iFile;
    }

    public String getName() {
        String name = (String)this.getVariables().get("name");
        name = String.valueOf(name) + "Profile";
        return name;
    }

    protected String[] getRequiredClasses() {
        return new String[0];
    }
}

