/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import java.util.ArrayList;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.soda.devicekit.ui.preference.LeafItem;

public class ParentItem {
    private LeafItem[] items = new LeafItem[0];
    private String id = "";
    private String name = "";

    public ParentItem() {
    }

    public ParentItem(String id, String name) {
        this.setId(id);
        this.setName(name);
    }

    public void collectChildren(String[] ids, TemplateStore templateStore) {
        ArrayList<LeafItem> list = new ArrayList<LeafItem>();
        String parentId = String.valueOf(this.getId()) + '/';
        int i = 0;
        while (i < ids.length) {
            TemplatePersistenceData templatePersistenceData;
            if (ids[i].startsWith(parentId) && (templatePersistenceData = templateStore.getTemplateData(ids[i])) != null && templatePersistenceData.getTemplate().getName().length() > 0) {
                LeafItem leafItem = new LeafItem(this, templatePersistenceData);
                list.add(leafItem);
            }
            ++i;
        }
        LeafItem[] children = new LeafItem[list.size()];
        children = list.toArray(children);
        this.setItems(children);
    }

    public String getContents() {
        return "";
    }

    public String getId() {
        return this.id;
    }

    public LeafItem[] getItems() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public void revert() {
        LeafItem[] items = this.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                items[i].revert();
                ++i;
            }
        }
    }

    public void save() {
        LeafItem[] items = this.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                items[i].save();
                ++i;
            }
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setItems(LeafItem[] items) {
        this.items = items;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getId();
    }
}

