/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.preference;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.soda.devicekit.generator.util.JREPreferenceUtil;
import org.eclipse.soda.devicekit.ui.preference.ExecutionEnvironmentsLabelProvider;
import org.eclipse.soda.devicekit.ui.preference.PreferenceMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class ExecutionEnvironmentsControl {
    private Table eeTable;
    private TableViewer eeTableViewer;
    private Button addButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private DialogPage parentPage;
    private String[] initEEs;
    private int buttonWidthHint;

    public ExecutionEnvironmentsControl(DialogPage parentPage, String[] initEEs) {
        this.parentPage = parentPage;
        this.initEEs = initEEs;
    }

    protected void EETableSelected() {
        this.updateButtons();
    }

    protected void addButtonPressed() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getParentDialogPage().getShell(), (ILabelProvider)new ExecutionEnvironmentsLabelProvider());
        dialog.setElements(this.getUnselectedEE());
        dialog.setAllowDuplicates(false);
        dialog.setMultipleSelection(true);
        dialog.setTitle(PreferenceMessages.getString("ExecutionEnvironment_dialog_title"));
        dialog.setMessage(PreferenceMessages.getString("ExecutionEnvironment_dialogMessage"));
        if (dialog.open() == 0) {
            this.addExecutionEnvironments(dialog.getResult());
        }
    }

    protected void addExecutionEnvironments(Object[] addedEE) {
        ArrayList newDisplayedEE = this.getEETableItemsList();
        int i = 0;
        while (i < addedEE.length) {
            newDisplayedEE.add(addedEE[i]);
            ++i;
        }
        this.getEETableViewer().setInput((Object)newDisplayedEE.toArray());
    }

    private void addListeners() {
        this.getEETable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionEnvironmentsControl.this.EETableSelected();
            }
        });
        this.getAddButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExecutionEnvironmentsControl.this.addButtonPressed();
            }
        });
        this.getRemoveButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExecutionEnvironmentsControl.this.removeButtonPressed();
            }
        });
        this.getUpButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExecutionEnvironmentsControl.this.upBottonPressed();
            }
        });
        this.getDownButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExecutionEnvironmentsControl.this.downButtonPressed();
            }
        });
    }

    private String[] convertTableItemsToArray(TableItem[] items) {
        String[] result = new String[items.length];
        int i = 0;
        while (i < items.length) {
            result[i] = items[i].getText();
            ++i;
        }
        return result;
    }

    private Button createButton(Composite parent, String text, boolean enabled) {
        GridData buttonGridData = new GridData(2);
        buttonGridData.horizontalSpan = 1;
        Button button = new Button(parent, 0x1000008);
        button.setText(text);
        buttonGridData.widthHint = Math.max(this.buttonWidthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)buttonGridData);
        button.setEnabled(enabled);
        return button;
    }

    private void createContent(Composite parent) {
        GridData labelGridData = new GridData(770);
        labelGridData.horizontalSpan = 3;
        Label eeLabel = new Label(parent, 16384);
        eeLabel.setText(PreferenceMessages.getString("eeLabel"));
        eeLabel.setToolTipText(PreferenceMessages.getString("eeLabel.hint"));
        eeLabel.setLayoutData((Object)labelGridData);
        GridData contentGridData = new GridData(1810);
        contentGridData.horizontalSpan = 2;
        contentGridData.horizontalIndent = 5;
        this.eeTable = new Table(parent, 2050);
        this.eeTable.setLayoutData((Object)contentGridData);
        this.eeTable.setHeaderVisible(false);
        this.eeTableViewer = new TableViewer(this.eeTable);
        this.eeTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.eeTableViewer.setLabelProvider((IBaseLabelProvider)new ExecutionEnvironmentsLabelProvider());
        this.eeTableViewer.setInput((Object)this.initEEs);
        Composite buttonComposite = new Composite(parent, 131072);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        GridData buttonGridData = new GridData();
        buttonGridData.verticalAlignment = 128;
        buttonGridData.horizontalSpan = 1;
        buttonComposite.setLayoutData((Object)buttonGridData);
        this.addButton = this.createButton(buttonComposite, "Add...", true);
        this.removeButton = this.createButton(buttonComposite, "Remove", false);
        this.upButton = this.createButton(buttonComposite, "UP", false);
        this.downButton = this.createButton(buttonComposite, "DOWN", false);
    }

    public TableViewer createControl(Composite parent) {
        this.createContent(parent);
        this.addListeners();
        return this.eeTableViewer;
    }

    protected void downButtonPressed() {
        ArrayList displayedEE = this.getEETableItemsList();
        int index = this.getEETable().getSelectionIndex();
        Collections.swap(displayedEE, index, index + 1);
        this.getEETableViewer().setInput((Object)displayedEE.toArray());
        this.getEETable().setSelection(index + 1);
        this.updateButtons();
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getDownButton() {
        return this.downButton;
    }

    public Table getEETable() {
        return this.eeTable;
    }

    protected String[] getEETableItems() {
        TableItem[] items = this.getEETable().getItems();
        return this.convertTableItemsToArray(items);
    }

    protected ArrayList getEETableItemsList() {
        TableItem[] displayedEE = this.getEETable().getItems();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < displayedEE.length) {
            list.add(displayedEE[i].getText());
            ++i;
        }
        return list;
    }

    protected String[] getEETableSelections() {
        TableItem[] items = this.getEETable().getSelection();
        return this.convertTableItemsToArray(items);
    }

    public TableViewer getEETableViewer() {
        return this.eeTableViewer;
    }

    public DialogPage getParentDialogPage() {
        return this.parentPage;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    protected Object[] getUnselectedEE() {
        String[] allEE = JREPreferenceUtil.getAllExecutionEnvironments();
        TableItem[] displayedEE = this.getEETable().getItems();
        ArrayList<String> unselectedEE = new ArrayList<String>();
        int i = 0;
        while (i < allEE.length) {
            unselectedEE.add(allEE[i]);
            ++i;
        }
        i = 0;
        while (i < displayedEE.length) {
            if (unselectedEE.contains(displayedEE[i].getText())) {
                unselectedEE.remove(displayedEE[i].getText());
            }
            ++i;
        }
        return unselectedEE.toArray();
    }

    public Button getUpButton() {
        return this.upButton;
    }

    protected void removeButtonPressed() {
        String[] selectedEE = this.getEETableSelections();
        this.removeExecutionEnvironments(selectedEE);
        this.updateButtons();
    }

    protected void removeExecutionEnvironments(String[] selectedEE) {
        ArrayList newDisplayedEE = this.getEETableItemsList();
        int i = 0;
        while (i < selectedEE.length) {
            newDisplayedEE.remove(selectedEE[i]);
            ++i;
        }
        this.getEETableViewer().setInput((Object)newDisplayedEE.toArray());
    }

    public void setButtonWidthHint(int buttonWidthHint) {
        this.buttonWidthHint = buttonWidthHint;
    }

    protected void upBottonPressed() {
        ArrayList displayedEE = this.getEETableItemsList();
        int index = this.getEETable().getSelectionIndex();
        Collections.swap(displayedEE, index, index - 1);
        this.getEETableViewer().setInput((Object)displayedEE.toArray());
        this.getEETable().setSelection(index - 1);
        this.updateButtons();
    }

    private void updateButtons() {
        int totalItems = this.getEETable().getItemCount();
        int[] selectedItems = this.getEETable().getSelectionIndices();
        boolean enableRemove = selectedItems.length > 0;
        boolean enableUp = totalItems > 0 && selectedItems.length == 1 && selectedItems[0] > 0;
        boolean enableDown = totalItems > 0 && selectedItems.length == 1 && selectedItems[0] < totalItems - 1;
        this.getRemoveButton().setEnabled(enableRemove);
        this.getUpButton().setEnabled(enableUp);
        this.getDownButton().setEnabled(enableDown);
    }
}

