/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.generic.adapter.wizard;

import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.ui.generic.adapter.wizard.GenericAdapterMessages;
import org.eclipse.soda.devicekit.ui.wizard.DeviceKitBasePage;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.swt.widgets.Composite;

public class GenericAdapterPage
extends DeviceKitBasePage {
    private static IWizardMessages messages = GenericAdapterMessages.getInstance();

    public GenericAdapterPage(String pageName) {
        super(messages.getString("new.adapter"));
        this.setTitle(messages.getString("adapter"));
    }

    public GenericAdapterPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    protected void createCommonOptions(Composite composite) {
        String profileOptionsLabel = this.getString("profile.options");
        this.createCheckBoxControl(composite, "inventory.profile", profileOptionsLabel);
        this.createCheckBoxControl(composite, "gpio.profile");
        this.createCheckBoxControl(composite, "write.profile");
        this.createCheckBoxControl(composite, "barcode.profile");
        String bundlelabelString = this.getString("bundleoptions");
        this.createCheckBoxControl(composite, "create.bundle", bundlelabelString).setSelection(false);
        this.createCheckBoxControl(composite, "create.managed.bundle").setSelection(false);
        this.createCheckBoxControl(composite, "create.managed.factory.bundle");
    }

    protected void createCustomControl(Composite composite) {
        this.createCommonOptions(composite);
    }

    public String[] createSupportChoices() {
        if (this.isTest()) {
            return this.getNameShortAdapterTestChoices();
        }
        return null;
    }

    protected String getKey() {
        return "adapter";
    }

    public String[] getNameChoices() {
        if (this.isTest()) {
            return this.getNameShortAdapterTestChoices();
        }
        return this.getNameShortAdapterChoices();
    }

    public String getString(String key) {
        try {
            return messages.getString(key);
        }
        catch (Exception exception) {
            return super.getString(key);
        }
    }

    public Map getVariables() {
        Map table = super.getVariables();
        table.put("device.superclass", "");
        return table;
    }
}

