/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.print;

import java.util.List;
import org.eclipse.soda.devicekit.generator.print.IndentationPrinter;

public class XmlPrinter
extends IndentationPrinter {
    public XmlPrinter() {
        this(0);
    }

    public XmlPrinter(int indentation) {
        super(indentation);
    }

    public void endComment() {
        this.print(" --");
        this.endTag(true);
    }

    public void endEmptyTag(boolean newLine) {
        this.print("/");
        this.endTag(newLine);
    }

    public void endEmpyTag() {
        this.endEmptyTag(true);
    }

    public void endTag(String tagName, boolean newLine) {
        this.startTag();
        this.print("/");
        this.print(tagName);
        this.endTag(newLine);
    }

    public void endTag(String tagName) {
        this.startTag();
        this.print("/");
        this.print(tagName);
        this.endTag(false);
    }

    public void endTag() {
        this.endTag(true);
    }

    public void endTag(boolean newLine) {
        this.print(">");
        if (newLine) {
            this.printNewLine();
        }
    }

    public void printAttribute(String name, String value) {
        this.print(" ");
        this.print(name);
        this.print("=");
        this.print(this.quote(value));
    }

    public void printComment(String comment) {
        if (comment.trim().length() > 0) {
            this.startComment();
            this.print(comment);
            this.endComment();
        } else {
            this.print("\n");
        }
    }

    public void printComments(String[] comments) {
        int length = comments.length;
        int max = 0;
        int i = 0;
        while (i < length) {
            max = Math.max(max, comments[i].length());
            ++i;
        }
        i = 0;
        while (i < length) {
            String comment = comments[i];
            int size = comment.length();
            if (size > 0) {
                this.startComment();
                this.print(comment);
                int j = 0;
                while (j < max - size) {
                    this.printSpace();
                    ++j;
                }
                this.endComment();
            }
            ++i;
        }
    }

    public void printComments(List comments) {
        int length = comments.size();
        int max = 0;
        int i = 0;
        while (i < length) {
            max = Math.max(max, String.valueOf(comments.get(i)).length());
            ++i;
        }
        i = 0;
        while (i < length) {
            String comment = String.valueOf(comments.get(i));
            int size = comment.length();
            this.startComment();
            if (size > 0) {
                this.print(comment);
            }
            int j = 0;
            while (j < max - size) {
                this.printSpace();
                ++j;
            }
            this.endComment();
            ++i;
        }
    }

    public void printXmlHeader() {
        this.printlnWithIndent("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    protected String quote(String string) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('\"');
        buffer.append(string);
        buffer.append('\"');
        return buffer.toString();
    }

    public void startComment() {
        this.startTagWithIndentation();
        this.print("!-- ");
    }

    public void startTag(String tagName) {
        this.startTag();
        this.print(tagName);
    }

    public void startTag() {
        this.print("<");
    }

    public void startTagWithIndentation() {
        this.printIndentation();
        this.startTag();
    }
}

